% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/utilities.R
\name{getCompendium}
\alias{getCompendium}
\title{This method allows to download/import the full compendium for the selected organism}
\usage{
getCompendium(organism = "hpylo", path = NULL)
}
\arguments{
\item{organism}{A character containing the organism id: use \code{\link{listOrganisms}} to display
the available organisms.}

\item{path}{A string indicating the path where the file will be either downloaded or read,
if already retrieved}
}
\value{
A list containing two or three data.frames.

In case \code{\link{switchVersion}} is equal to 2:
\item{exprdata}{the full compendium for the selected organism}
\item{condannot}{The condition annotation for the selected organism}

In case \code{\link{switchVersion}} is equal to 3:
\item{exprdata}{the full compendium for the selected organism}
\item{refannot}{The condition annotation for the reference contrasts}
\item{testannot}{The condition annotation for the test contrasts}
}
\description{
This method allows to download/import the full compendium for the selected organism
}
\examples{
\dontrun{
library('Rcolombos')
hpylo <- getCompendium("hpylo")
}
}
\references{
http://colombos.net
}

