% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleBuilding.R
\name{sortLabel}
\alias{sortLabel}
\title{Clusters labels sorting}
\usage{
sortLabel(label)
}
\arguments{
\item{label}{vector of labels (integers).}
}
\value{
sorted labels
}
\description{
Sort clusters labels by decreasing sizes for unsupervised classification.
}
\details{
sortLabel sorts clusters labels by decreasing sizes, in unsupervised classification
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
tf <- tempfile()
write.table(dat, tf, sep=",", dec=".")

x <- importSample(file.features=tf, dir.save=tempdir())
res <- KmeansQuick(x$features$initial$x, K=3)

sortLabel(res$cluster)


}
\keyword{internal}
