read_PDT <- function(pdt_file, sep=","){
  
  options(warn=0)
  pdt_all <- c()
  
  for(f in pdt_file){
    cat('running pdt_file',f,"\n")
    
    #### check for header line:
    skip <- -1
    header_found <- F
    while(!header_found){
      skip <- skip +1
      header0 <- as.character(unlist(read.delim(f,sep=sep,header=F,nrows=1,skip=skip,stringsAsFactors=F)))
      header_found <- any(grepl("MaxTemp",header0))
    }
    
    #### recreate extended header for PDT file:
    repcols <- c("Depth1", "MinTemp1", "MaxTemp1", "%Ox1","Discont1")
    start_repcols <- c()
    keep <- c() ## check which of the repeated column names exist in the pdt header
    for(n in repcols) {
      start_repcols <- min(c(start_repcols,grep(n,header0)))
      if(any(grepl(n,header0))) keep <- c(keep, n)
    }
    repcols <- keep
    header <- header0[1:(start_repcols-1)]
    for(i in 1:50){
      add_cols <- paste0(gsub(1,i,repcols))
      header <- c(header,add_cols)
    }
    
    #### read in pdt data with extended header:
    add_pdt0 <- read.table(f,header=F,skip=skip+1,sep=sep,fill=T,col.names=header,stringsAsFactors = F)
    if(add_pdt0$DeployID[1] == "DeployID") add_pdt0 <- read.table(f,header=F,skip=skip+2,sep=sep,fill=T,col.names=header,stringsAsFactors = F)
    add_pdt0 <- cbind(pdt_file=f,add_pdt0)
    add_pdt0 <- add_pdt0[which(add_pdt0$NumBins != "NumBins"),]
    
    j <- which(grepl('Ox',names(add_pdt0))| grepl('Disc',names(add_pdt0)))
    if(length(j) > 0) add_pdt0 <- add_pdt0[,-j]
    
    ### reorganize and add required data
    for(i in 1:nrow(add_pdt0)){
      nbins <- add_pdt0$NumBins[i]
      #       print(round(100*i/nrow(add_pdt0),1))
      info <- add_pdt0[i,c("pdt_file","DeployID",'Ptt','Date',"NumBins")]
      for(j in 1:nbins){
        add_pdt <- cbind(info,
                         Depth= .fact2num(add_pdt0[[paste0("Depth",j)]][i]),
                         MinTemp= .fact2num(add_pdt0[[paste0("MinTemp",j)]][i]),
                         MaxTemp= .fact2num(add_pdt0[[paste0("MaxTemp",j)]][i]))
        pdt_all <- rbind(pdt_all,add_pdt)              
      }
    }
  }
  lct <- Sys.getlocale("LC_TIME"); Sys.setlocale("LC_TIME", "C")
  pdt_all$date.long <- strptime(pdt_all$Date,"%H:%M:%S %d-%b-%Y")
  pdt_all$date <- as.Date(pdt_all$date.long)
  
  # check if date conversion worked out
  ii <- which(is.na(pdt_all$date))
  if(length(ii) > 0){
    stop('Column "Date" of pdt_file(s):\n',paste(pdt_all$pdt_file[ii],collapse=',\n'),
         '\n not in correct format (%H:%M:%S %d-%b-%Y). Please revise.')
  }
  
  pdt_all <- pdt_all[which(!is.na(pdt_all$Depth)),]
  pdt_all$MeanPDT <- (pdt_all$MinTemp+pdt_all$MaxTemp)/2
  pdt_all$Date <- c()
  
  return(pdt_all)
}


