% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beqs.R
\name{beqs}
\alias{beqs}
\title{Run 'Bloomberg EQS' Queries}
\usage{
beqs(screenName, screenType = "GLOBAL", language = "", group = "",
  date = NULL, verbose = FALSE, con = defaultConnection())
}
\arguments{
\item{screenName}{A character string with the name of the screen
to execute.  It can be a user defined EQS screen or one of the
Bloomberg Example screens on EQS}

\item{screenType}{A character string of value PRIVATE or GLOBAL
Use PRIVATE for user-defined EQS screen.
Use GLOBAL for Bloomberg EQS screen.}

\item{language}{An optional character string with the EQS language}

\item{group}{An optional character string with the Screen folder
name as defined in EQS}

\item{date}{An optional Date object with the \sQuote{point in time} date
of the screen to execute.}

\item{verbose}{A boolean indicating whether verbose operation is
desired, defaults to \sQuote{FALSE}.}

\item{con}{A connection object as created by a \code{blpConnect}
call, and retrieved via the internal function
\code{defaultConnection}.}
}
\value{
A data frame object with the date in the first column and
and the requested EQS data in the remaining columns.
}
\description{
This function uses the Bloomberg API to retrieve 'beqs' (Bloomberg
EQS Data) queries
}
\examples{
\dontrun{
beqs("Global Oil Companies YTD Return")
beqs("Global Oil Companies YTD Return", "GLOBAL")
beqs("Global Oil Companies YTD Return", "GLOBAL", "GERMAN")
beqs("Global Oil Companies YTD Return", "GLOBAL", "GERMAN", "GENERAL")
beqs("Global Oil Companies YTD Return", "GLOBAL", "ENGLISH", "GENERAL", as.Date("2015-09-30"))
}
}
\author{
Rademeyer Vermaak and Dirk Eddelbuettel
}

