\docType{package}
\name{Rbitcoin}
\alias{BTC}
\alias{Rbitcoin}
\alias{Rbitcoin-package}
\alias{bitcoin}
\alias{btc}
\title{R & bitcoin integration}
\description{
Utilities related to Bitcoin and other cryptocurrencies.
Core functionalities are: \itemize{ \item
\code{market.api.query} - launch query on market's API
(\code{bitstamp}, \code{btce}, \code{kraken},
\code{bitmarket}). Both public and private API calls
supported. All currency pairs supported. \item
\code{market.api.process} - integration of market's
processing structures: pre-process of API request,
post-process API results, market error catching. Input and
output unified structure. Requires API dictionary
definition, for details of package built-in dictionary see
\code{\link{api.dict}}. \item \code{blockchain.api.query} -
launch query on blockchain.info API json interface. \item
\code{blockchain.api.process} - postprocess blockchain api
result, transform to \code{data.table}. \item
\code{Rbitcoin.plot} - illustrate the data returned by some
Rbitcoin functions. \item \code{wallet_manager} - track the
assets amounts and values in multiple wallet sources. } You
need to note that imported \code{digest} package docs
states: \emph{Please note that this package is not meant to
be deployed for cryptographic purposes for which more
comprehensive (and widely tested) libraries such as OpenSSL
should be used}. Still \code{digest} is one of the top
downloaded package from CRAN.\cr To do not get banned by
market's API anti-DDoS protection user should use:
\code{Sys.sleep(10)} between the API calls or
\code{\link{antiddos}} function.\cr It is advised to
maintain your API keys security level as tight as possible,
if you do not need withdraw api method be sure to disable
it for api keys.\cr You can print debug messages of
\code{Rbitcoin} to console using verbose argument in FUNs
or \code{options("Rbitcoin.verbose" = 1)}.\cr Two params
\code{ssl.verify} and \code{curl.verbose} have been
deprecated since \code{0.8.5}. They can and should be
controlled using \code{options("RCurlOptions")}. SSL verify
is by default active.\cr At the time of writing the most
recent market's API version were used: \itemize{ \item
bitstamp v2 (public) / ? (private) \item btce v2 (public) /
"tapi" (private) \item kraken v0 \item bitmarket v2 \item
mtgox v2 (market already closed) }

SSL is by default active, to disable SSL set
\code{RCurlOptions} to \code{ssl.verify* = FALSE} and
\code{cainfo = NULL}, see examples. In case of SSL error
try update certificate CA file (\code{cacert.pem} in
location mentioned below as \code{cainfo}), see references
for CA file source. Alternatively you can always disable
SSL.

For others package-level options see examples.

BTC donation:
\url{bitcoin:15Mb2QcgF3XDMeVn6M7oCG6CQLw4mkedDi}
}
\examples{
\dontrun{
# default options used by Rbitcoin

# print Rbitcoin processing to console set "Rbitcoin.verbose" to 1 (or more)
options(Rbitcoin.verbose=0)

# print Rcurl processing to console set RCurlOptions[["verbose"]] to TRUE
options(RCurlOptions=list(ssl.verifypeer = TRUE,
                          ssl.verifyhost = TRUE,
                          cainfo = system.file("CurlSSL","cacert.pem",package="RCurl"),
                          verbose = FALSE))

# currency type dictionary used by wallet_manager
options(Rbitcoin.ct.dict = list(
  crypto = c('BTC','LTC','NMC', ...),
  fiat = c('USD','EUR','GBP', ...)
))
}
}
\references{
Package discussion thread:
\url{https://bitcointalk.org/index.php?topic=343504}\cr
Example SSL CA file source:
\url{http://curl.haxx.se/docs/caextract.html}
}
\seealso{
\code{\link{market.api.process}},
\code{\link{blockchain.api.process}},
\code{\link{wallet_manager}}, \code{\link{Rbitcoin.plot}},
\code{\link{api.dict}}, \code{\link{available_wallet}}
}

