% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_monthly_vbias.R
\name{rvn_monthly_vbias}
\alias{rvn_monthly_vbias}
\title{Monthly Volume Bias}
\usage{
rvn_monthly_vbias(
  sim,
  obs,
  add_line = TRUE,
  normalize = TRUE,
  add_labels = TRUE
)
}
\arguments{
\item{sim}{time series object of simulated flows}

\item{obs}{time series object of observed flows}

\item{add_line}{optionally adds a horizontal line to the plot for reference
(default \code{TRUE})}

\item{normalize}{option to normalize the biases and report as percent error
(default \code{TRUE})}

\item{add_labels}{optionally adds labels for early peak/late peaks on right
side axis (default \code{TRUE})}
}
\value{
\item{mvbias}{monthly volume biases}
}
\description{
Creates a plot of the monthly volume biases in the simulated
flow series.
}
\details{
Calculates the monthly volume biases and optionally creates a
plot of them. The monthly volume biases are averaged across all years of
data. If normalized, the biases are calculated as:

(Vi_sim - Vi_obs)/Vi_obs*100

to be expressed as a percent error.

The sim and obs should be of time series (xts) format and are assumed to be
of the same length and time period. The flow series are assumed to be daily
flows with units of m3/s. Note that a plot title is purposely omitted in
order to allow the automatic generation of plot titles.

The add_labels will add the labels of 'overestimated' and 'underestimated'
to the right hand side axis if set to \code{TRUE}. This is useful in interpreting
the plots. Note that the biases are calculated as sim_Volume - obs_Volume,
which means that negative values mean the volume is underestimated, and
positive values mean the volume is overestimated.
}
\examples{
# load sample hydrograph data, two years worth of sim/obs
data(rvn_hydrograph_data)
sim <- rvn_hydrograph_data$hyd$Sub36
obs <- rvn_hydrograph_data$hyd$Sub36_obs

# check the monthly volume bias; normalizes by default
rvn_monthly_vbias(sim,obs)

# check unnormalzied monthly volume biases; see the larger volumes in certain periods
rvn_monthly_vbias(sim,obs,normalize = FALSE)

}
\seealso{
\code{\link{rvn_annual_volume}} to create a scatterplot of annual flow
volumes
}
