% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_rvi_read.R
\name{rvn_rvi_read}
\alias{rvn_rvi_read}
\title{Read Raven .rvi (watershed discretization) file}
\usage{
rvn_rvi_read(filename)
}
\arguments{
\item{filename}{the name of the .rvi file (with .rvi extension included ), either relative
to the working directory or absolute.}
}
\value{
Returns a list including a lone item:
\item{HydProcTable}{a data table of hydrologic processes. Includes the following data columns:
process type, algorithm, 'from' compartment, 'to' compartment, and condition}
}
\description{
This routine reads in a valid Raven main input (.rvi) file and returns the
information about hydrological processes as a data table.
}
\details{
This function does not like tabs in the .rvi file - it should be untabified first. Comma-delimited tables with a trailing comma are also problematic.
The .rvi file can have arbitrary contents outside of the :HydrologicProcesses-
:EndHydrologicProcesses block and :SubBasins-:EndSubBasins command blocks.
}
\examples{
# sample workflow of rvn_rvi_read
rvi <- system.file("extdata","Nith.rvi", package="RavenR") \%>\%
rvn_rvi_read(.)

# get number of Hydrologic processes
nrow(rvi$HydProcTable)

}
\author{
James R. Craig, University of Waterloo
}
