% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plt-visualize-walks.R
\name{visualize_walks}
\alias{visualize_walks}
\title{Visualize Walks}
\usage{
visualize_walks(.data, .alpha = 0.7)
}
\arguments{
\item{.data}{The input data. Assumed to be created by one of the random walk
functions in the RandomWalker package, but can be any data frame or tibble
that contains columns \code{walk_number}, \code{x}, and one or more numeric columns
like \code{x}, \code{cum_sum}, \code{cum_prod}, \code{cum_min}, \code{cum_max} and \code{cum_mean}, for
instance.}

\item{.alpha}{The alpha value for all the line charts in the visualization.
Values range from 0 to 1. Default is 0.7.}
}
\value{
A patchwork composed of 1 or more patches
}
\description{
visualize_walks() visualizes the output of the random walk
functions in the RandomWalker package, resulting in one or more ggplot2 plots
put together in a patchwork composed of 1 or more patches.
}
\details{
visualize_walks() generates visualizations of the random walks
generated by the  random walk functions in the RandomWalker package. These
are the functions at the moment of writing:
\itemize{
\item brownian_motion()
\item discrete_walk()
\item geometric_brownian_motion()
\item random_normal_drift_walk()
\item random_normal_walk()
\item rw30()
}

It is possible there are more when you read this, but you can check the rest
of the documentation for the current situation.

The visualization function is meant to be easy to use. No parameters needed,
but you can set the \code{.alpha} if the default value of 0.7 isn't to your
liking.

You can combine this function with many tidyverse functions (either before or
after). There's one example below.
}
\examples{
# Generate random walks and visualize the result
set.seed(123)
rw30() |>
 visualize_walks()

# Set the alpha value to be other than the default 0.7
set.seed(123)
rw30() |>
 visualize_walks(.alpha = 0.5)

# Use the function with an input that has alternatives for y
set.seed(123)
random_normal_walk() |>
 visualize_walks()

# Use the pluck function from purrr to pick just one visualization
set.seed(123)
random_normal_walk() |>
 visualize_walks() |>
 purrr::pluck(2)

}
\author{
Antti Lennart Rask
}
\concept{Visualization Functions}
