% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legendrequad.R
\name{legendrequad}
\alias{legendrequad}
\title{Auxiliary function that compute the Legendre quadrature of order K}
\usage{
legendrequad(K)
}
\arguments{
\item{K}{order of the Legendre quadraure}
}
\value{
a list containing, in order:

- t : points of the Legendre quadrature

-  w : weigths for the Legendre quadrature

-  Pbarmat : the eigenvectors of J
}
\description{
Generate nodes and weights for Legendre-Gauss quadrature on [-1,1]. Note that t is a column vector and w is a
row vector. Also normalizes and returns the eigenvectors of J so that they are samples of the unit-norm Legendre
polynomials
}
\examples{
K=30
res2 <-  legendrequad(K)


}
