% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/name_stages.R
\name{name_stages}
\alias{name_stages}
\title{Add stage names to matrices}
\usage{
name_stages(mat, names = NULL, prefix = "stage_", left_pad = TRUE)
}
\arguments{
\item{mat}{An MPM, either as a single matrix or list of matrices.}

\item{names}{A character vector specifying the name of each life stage, in
order. If provided, \code{prefix} and \code{left_pad} arguments are
ignored.}

\item{prefix}{A string to be pre-pended to the stage number when
automatically naming stages. Defaults to \code{stage_}.}

\item{left_pad}{Logical, whether to pre-pend \code{0} to stage names such
that all stage numbers have equal length, enabling lexicographic sorting.
For example, stage \code{1} becomes \code{01} for matrices with 10-99
stages, \code{001} for matrices with 100-999 stages, and so on. Defaults to
\code{TRUE}.}
}
\value{
The input matrix or matrices with named rows and columns.
}
\description{
Adds user-supplied or automatically-generated stage names to a matrix
population model (MPM).
}
\examples{
matU <- rbind(
  c(0.0, 0.0, 0.0),
  c(0.3, 0.1, 0.0),
  c(0.0, 0.5, 0.8)
)
# (semi)automated naming
name_stages(matU)
name_stages(matU, prefix = "s")
# custom stage names
name_stages(matU, names = c("small", "medium", "large"))
# overwrite existing stage names
data(mpm1)
name_stages(mpm1)

}
\seealso{
Other transformation: 
\code{\link{is_leslie_matrix}()},
\code{\link{leslie_collapse}()},
\code{\link{mpm_collapse}()},
\code{\link{mpm_rearrange}()},
\code{\link{mpm_split}()},
\code{\link{mpm_standardize}()},
\code{\link{repro_stages}()},
\code{\link{standard_stages}()}
}
\author{
William K. Petry <wpetry@ncsu.edu>
}
\concept{transformation}
