% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarID_functions.R
\name{getExpData}
\alias{getExpData}
\title{Function for extracting a filtered expression matrix from a \pkg{RaceID} \code{SCseq} object}
\usage{
getExpData(object, genes = NULL)
}
\arguments{
\item{object}{\pkg{RaceID} \code{SCseq} object.}

\item{genes}{Vector of valid gene identifiers corresponding to valid rownames of the input expression data. An expression matrix is returned only for these genes.
Default is \code{NULL} and an expression matrix is returned for all genes retained after filtering of the \code{SCseq} object, i.e. all genes in \code{genes}
slot of the \code{SCseq} object.}
}
\value{
noise Sparse Matrix with genes as rows and cells as columns after filtering.
}
\description{
This function for extracts a filtered expression matrix from a \pkg{RaceID} \code{SCseq} object. The \code{filterdata} function from
the \pkg{RaceID} package has to be run on the \code{SCseq} object before.
}
\examples{
sc <- SCseq(intestinalDataSmall)
sc <- filterdata(sc)
sc <- compdist(sc)
d <- getExpData(sc)
res <- pruneKnn(d,distM=sc@distances,knn=10,alpha=1,no_cores=1,FSelect=FALSE)
}
