% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarID_functions.R
\name{plotRegNB}
\alias{plotRegNB}
\title{Function for plotting negative binomial regression}
\usage{
plotRegNB(expData, noise, par.nb = NULL)
}
\arguments{
\item{expData}{Matrix of gene expression values with genes as rows and cells as columns. The matrix need to contain the same cell IDs as columns like the input matrix
used to derive the pruned k nearest neighbours with the \code{pruneKnn} function.}

\item{noise}{List object with the background noise model and a variability matrix, returned by the \code{compNoise} function.}

\item{par.nb}{Parameter to be plotted, i.e. valid column of \code{noise$regData$nbRegr}.
of the log10 total UMI count. \code{intercept} is the intercept inferred by the regression. Default is \code{NULL} and \code{theta} is shown.}
}
\value{
None
}
\description{
This function plots the parameters obatined by the negative binomial regression of the transcript counts on the total transcript count in each cells.
Smoothed parameter estimates are also shown.
}
\examples{
res <- pruneKnn(intestinalDataSmall,metric="pearson",knn=10,alpha=1,no_cores=1,FSelect=FALSE)
noise <- compNoise(intestinalDataSmall,res,regNB=TRUE,pvalue=0.01,genes = NULL,no_cores=1)
plotRegNB(intestinalDataSmall,noise,"theta")
}
