% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RaceID.R
\name{plotmarkergenes}
\alias{plotmarkergenes}
\title{Plotting a Heatmap of Marker Gene Expression}
\usage{
plotmarkergenes(object, genes, imputed = FALSE, cthr = 0, cl = NULL,
  cells = NULL, order.cells = FALSE, aggr = FALSE, norm = FALSE,
  cap = NULL, flo = NULL, samples = NULL, cluster_cols = FALSE,
  cluster_rows = TRUE, cluster_set = FALSE, samples_col = NULL,
  zsc = FALSE, logscale = TRUE, noise = FALSE, fontsize = 10)
}
\arguments{
\item{object}{\code{SCseq} class object.}

\item{genes}{A vector with a group of gene names corresponding to a subset of valid row names of the \code{ndata} slot
of the \code{SCseq} object.}

\item{imputed}{logical. If \code{TRUE} and imputing was done by calling \code{compdist} with \code{knn > 0}, then imputed expression values are shown.
If \code{FALSE}, then raw counts are shown. Default is \code{FALSE}}

\item{cthr}{Interger number greater or equal zero. Only clusters with \code{>cthr} cells are included in the t-SNE map. Default is 0.}

\item{cl}{Vector of valid cluster numbers contained in slot \code{cpart} of the \code{SCseq} object. Default is \code{NULL} and all clusters with \code{>cthr}
cells are included.}

\item{cells}{Vector of valid cell names corresponding to column names of slot \code{ndata} of the \code{SCseq} object. Gene expression is only shown for
this subset.
Default is \code{NULL} and all cells are included. The set of \code{cells} is intersected with the subset of clusters in \code{cl} if given.}

\item{order.cells}{logical. If \code{TRUE}, then columns of the heatmap are ordered by cell name and not by cluster number. If \code{cells} are given, then columns are ordered as in \code{cells}.}

\item{aggr}{logical. If \code{TRUE}, then only average expression is shown for each cluster. Default is \code{FALSE} and expression in individual cells is shown.}

\item{norm}{logical. If \code{TRUE}, then expression of each gene across clusters is normalized to 1, in order to depict all genes on the same scale.
Default is \code{FALSE}.}

\item{cap}{Numeric. Upper bound for gene expression. All values larger then \code{cap} are replaced by \code{cap}.
Default is \code{NULL} and no \code{cap} is applied.}

\item{flo}{Numeric. Lower bound for gene expression. All values smaller then \code{floor} are replaced by \code{floor}.
Default is \code{NULL} and no \code{floor} is applied.}

\item{samples}{A vector with a group of sample names for each cell in the same order as the column names of the \code{ndata} slot of the \code{SCseq} object.}

\item{cluster_cols}{logical. If \code{TRUE}, then columns are clustered. Default is \code{FALSE}.}

\item{cluster_rows}{logical. If \code{TRUE}, then rows are clustered. Default is \code{TRUE}.}

\item{cluster_set}{logical. If \code{TRUE} then clusters are ordered by hierarchical clustering of the cluster medoids.}

\item{samples_col}{Vector of colors used for highlighting all samples contained in \code{samples} in the heatmap. Default is \code{NULL}.}

\item{zsc}{logical. If \code{TRUE} then a z-score transformation is applied. Default is \code{FALSE}.}

\item{logscale}{logical. If \code{TRUE} then a log2 transformation is applied. Default is \code{TRUE}.}

\item{noise}{logical. If \code{TRUE} then display local gene expression variability instead of gene expression (requires VarID analysis)/ Default value is \code{FALSE}.}

\item{fontsize}{postive real number. Font size of gene name labels. Default is 10.}
}
\value{
Object with clustering information for rows and columns returned by the function \code{pheatmap} from the package \pkg{pheatmap}.
}
\description{
This functions generates a heatmap of expression for  defined group of genes and can highlight the clustering partition and another sample grouping,
e.g. origin or cell type.
}
