% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a_intro.R
\docType{package}
\name{RWsearch-package}
\alias{RWsearch-package}
\alias{RWsearch}
\title{Package RWsearch}
\description{
Search by keywords in R packages, task views, CRAN, the web and display the 
results in the console or in txt, html or pdf files. Download the package 
documentation (html index, README, NEWS, pdf manual, vignettes, source code, 
binaries) with a single instruction. Visualize the package dependencies and 
CRAN checks. Compare the package versions, unload and install the packages 
and their dependencies in a safe order. Explore CRAN archives. Use the above 
functions for task view maintenance. Access web search engines from the 
console thanks to 80+ bookmarks. All functions accept standard and 
non-standard evaluation. Inspired by the packages ctv, foghorn, latexpdf, 
pacman and sos.
}
\examples{
\donttest{
### THE W IN RWsearch: LAUNCH WEBSITES AND SEARCH ENGINES
h_cranbydate(repos = "https://cloud.r-project.org")
h_yt("Serge Gainsbourg Ne dis rien")
h_osm("La Ferriere sous Jougne")
h_mw(recension)
h_lexilogos()
}
### A CONVENIENT FUNCTION FOR NON-STANDARD EVALUATION
## Non-standard content (nsc1, nsc2), standard content ("stc3", "double word4") 
## and regular object (obj) stored in .GlobalEnv can be merged with cnsc()
obj <- c("obj5", "obj6")
cnsc(nsc1, nsc2, "stc3", "double word4", obj)

### DOWNLOAD CRANDB AND CHECKDB
## In real life, download crandb and checkdb from CRAN or load them 
## with functions crandb_down(), crandb_load(), checkdb_down(), checkdb_load(). 
## checkdb can be ignored if less than npkgs are explored. 
## In this example, we use two small files.
crandb_load(system.file("data", "zcrandb.rda", package = "RWsearch"))
checkdb_load(system.file("aabb", "zcheck_results.rds", package = "RWsearch"))

### PRINT THE LATEST PACKAGES UPLOADED INTO CRAN (LAST DATE = "2021-06-01")
crandb_fromto(from = "2021-03-01", to = Sys.Date())
crandb_fromto(from = -15, to = max(crandb$Published))

### SEARCH IN CRANDB
## Search in crandb. Use standard or non-standard content. 
## Display the results in a vector or in a list.
s_crandb(search, find, cran, web)
s_crandb(search, find, cran, web, select = "PD", mode = "and")
s_crandb("^f", select = "P")
s_crandb(c("thermodynamic", "chemical reaction"))
(lst <- s_crandb_list(thermodynamic, "chemical reaction"))
\donttest{
### DISPLAY THE RESULTS
## in the console, in (txt, md, pdf) files or in the browser.
p_table2(lst)
p_table7pdf(lst, dir = file.path(tempdir(), "ptable"), cleantex = FALSE, openpdf = TRUE)
p_text(lst, dir = file.path(tempdir(), "ptext2"), editor = TRUE,  
           repos = "https://cloud.r-project.org")
p_text2pdf(lst, dir = file.path(tempdir(), "ptext2"), cleantex = FALSE,  
           openpdf = TRUE, repos = "https://cloud.r-project.org")
p_display(lst, dir = tempdir())
 
### VISUALIZE THE DOCUMENTATION 
## from installed packages or U. Pennsylviana in the browser
p_html(brew, sig) 
p_htmlweb(foghorn) 
p_pdfweb(sos, repos = "https://cloud.r-project.org")
 
### VISUALIZE THE PACKAGE DEPENDENCIES AND THE INSTALLED VERSIONS
p_graphF(actuar, fitdistrplus, reverse = TRUE) # Children
p_graphF(RWsearch)    # Parents
p_vers_deps(RWsearch) # Installed versions
 
### VISUALIZE THE PACKAGE CHECKS (USE checkdb FOR FASTER RESULTS)
p_check(RWsearch, repos = "https://cloud.r-project.org")
p_checkdeps_lst(RWsearch, repos = "https://cloud.r-project.org")

### DOWNLOAD THE DOCUMENTATION
## Vector => download in the "docpkgs" directory ("." is the current directory)
## List   => download in subdirectories named after the keywords
## (non-standard content is accepted)
p_down(pacman, pdfsearch, sos, dir = file.path(tempdir(), "pdown"),  
       repos = "https://cloud.r-project.org")
p_down(lst, dir = file.path(tempdir(), "pdown"), repos = "https://cloud.r-project.org")

### SEARCH WITH sos (ON R-PROJECT HELP PAGES), rdrr AND rdoc
(res <- s_sos(distillation))
data.frame(res)
h_rdrr(distillation)
h_rdoc(distillation)
}
### TASK VIEW MAINTENANCE
## In real life, download crandb and tvdb from CRAN or load them from your directory 
## with functions crandb_down(), crandb_load(), tvdb_down(), tvdb_load(). 
## In this example, we use small files.
crandb_load(system.file("data", "zcrandb.rda", package = "RWsearch"))
tvdb_load(system.file("data", "ztvdb.rda", package = "RWsearch"))

## List the task views
tvdb_vec()
tvdb_pkgs(gR, Genetics, Robust)

## Search for some packages in the task views
s_tvdb(actuar, FatTailsR, MASS, zoo, nopackage)

## Search for recent packages in crandb that contain the keyword 
## and verify if the packages are already referred in the task view.
## from = "2017-01-01" and "2018-01-01" are selected for this small example.
s_crandb_tvdb("distribution", tv = "Distributions", from = "2017-01-01")
s_crandb_tvdb("distribution", tv = "Distributions", from = "2018-01-01")
\donttest{
### EXPLORE CRAN ARCHIVE AND DOWNLOAD OLD tar.gz FILES
## In real life, download archivedb and crandb from CRAN
## with the functions archivedb_down() and crandb_down().  
## In this example, we load two small files (50 and 43 packages).
crandb_load(system.file("data", "zcrandb.rda", package = "RWsearch"))
archivedb_load(system.file("aabb", "zCRAN-archive.html", package = "RWsearch")) 
archivedb_npkgs()
lapply(archivedb_list(), tail)

## Download the latest tar.gz version from CRAN archive 
## (this works for both both existing and removed packages).
p_downarch(fitur, zmatrix, dir = file.path(tempdir(), "pdownarch"))
}

}
