/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.SimpleStreamFilter;

public class RandomSubset
extends SimpleStreamFilter {
    private static final long serialVersionUID = 2911221724251628050L;
    protected double m_NumAttributes = 0.5;
    protected int m_Seed = 1;
    protected int[] m_Indices = null;
    protected boolean m_invertSelection;

    @Override
    public String globalInfo() {
        return "Chooses a random subset of attributes, either an absolute number or a percentage. The class is always included in the output (as the last attribute).";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe number of attributes to randomly select.\n\tIf < 1 then percentage, >= 1 absolute number.\n\t(default: 0.5)", "N", 1, "-N <double>"));
        result.addElement(new Option("\tInvert selection - i.e. randomly remove rather than select.", "V", 0, "-V"));
        result.addElement(new Option("\tThe seed value.\n\t(default: 1)", "S", 1, "-S <int>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-N");
        result.add("" + this.m_NumAttributes);
        if (this.getInvertSelection()) {
            result.add("-V");
        }
        result.add("-S");
        result.add("" + this.m_Seed);
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption("N", options);
        if (tmpStr.length() != 0) {
            this.setNumAttributes(Double.parseDouble(tmpStr));
        } else {
            this.setNumAttributes(0.5);
        }
        this.setInvertSelection(Utils.getFlag('V', options));
        tmpStr = Utils.getOption("S", options);
        if (tmpStr.length() != 0) {
            this.setSeed(Integer.parseInt(tmpStr));
        } else {
            this.setSeed(1);
        }
        super.setOptions(options);
    }

    public String numAttributesTipText() {
        return "The number of attributes to choose: < 1 percentage, >= 1 absolute number.";
    }

    public double getNumAttributes() {
        return this.m_NumAttributes;
    }

    public void setNumAttributes(double value) {
        this.m_NumAttributes = value;
    }

    public String invertSelectionTipText() {
        return "Randomly remove rather than select attributes.";
    }

    public void setInvertSelection(boolean inv) {
        this.m_invertSelection = inv;
    }

    public boolean getInvertSelection() {
        return this.m_invertSelection;
    }

    public String seedTipText() {
        return "The seed value for the random number generator.";
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public void setSeed(int value) {
        this.m_Seed = value;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        int i;
        int numAtts = inputFormat.numAttributes();
        if (inputFormat.classIndex() > -1) {
            --numAtts;
        }
        if (this.m_NumAttributes < 1.0) {
            numAtts = (int)Math.round((double)numAtts * this.m_NumAttributes);
        } else if (this.m_NumAttributes < (double)numAtts) {
            numAtts = (int)this.m_NumAttributes;
        }
        if (this.getDebug()) {
            System.out.println("# of atts: " + numAtts);
        }
        Vector<Integer> indices = new Vector<Integer>();
        for (i = 0; i < inputFormat.numAttributes(); ++i) {
            if (i == inputFormat.classIndex()) continue;
            indices.add(i);
        }
        Vector subset = new Vector();
        Random rand = new Random(this.m_Seed);
        for (i = 0; i < numAtts; ++i) {
            int index = rand.nextInt(indices.size());
            subset.add(indices.get(index));
            indices.remove(index);
        }
        if (this.m_invertSelection) {
            subset = indices;
        }
        Collections.sort(subset);
        if (inputFormat.classIndex() > -1) {
            subset.add(inputFormat.classIndex());
        }
        if (this.getDebug()) {
            System.out.println("indices: " + subset);
        }
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        this.m_Indices = new int[subset.size()];
        for (i = 0; i < subset.size(); ++i) {
            atts.add(inputFormat.attribute((Integer)subset.get(i)));
            this.m_Indices[i] = (Integer)subset.get(i);
        }
        Instances result = new Instances(inputFormat.relationName(), atts, 0);
        if (inputFormat.classIndex() > -1) {
            result.setClassIndex(result.numAttributes() - 1);
        }
        return result;
    }

    @Override
    protected Instance process(Instance instance) throws Exception {
        double[] values = new double[this.m_Indices.length];
        for (int i = 0; i < this.m_Indices.length; ++i) {
            values[i] = instance.value(this.m_Indices[i]);
        }
        DenseInstance result = new DenseInstance(instance.weight(), values);
        this.copyValues(result, false, instance.dataset(), this.outputFormatPeek());
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 12037 $");
    }

    public static void main(String[] args) {
        RandomSubset.runFilter(new RandomSubset(), args);
    }
}

