/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.io.Serializable;
import weka.associations.Associator;
import weka.associations.AssociatorEvaluation;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.CapabilitiesIgnorer;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SerializedObject;
import weka.core.Utils;

public abstract class AbstractAssociator
implements Cloneable,
Associator,
Serializable,
CapabilitiesHandler,
CapabilitiesIgnorer,
RevisionHandler {
    private static final long serialVersionUID = -3017644543382432070L;
    protected boolean m_DoNotCheckCapabilities = false;

    public String doNotCheckCapabilitiesTipText() {
        return "If set, associator capabilities are not checked before associator is built (Use with caution to reduce runtime).";
    }

    @Override
    public void setDoNotCheckCapabilities(boolean doNotCheckCapabilities) {
        this.m_DoNotCheckCapabilities = doNotCheckCapabilities;
    }

    @Override
    public boolean getDoNotCheckCapabilities() {
        return this.m_DoNotCheckCapabilities;
    }

    public static Associator forName(String associatorName, String[] options) throws Exception {
        return (Associator)Utils.forName(Associator.class, associatorName, options);
    }

    public static Associator makeCopy(Associator model) throws Exception {
        return (Associator)new SerializedObject(model).getObject();
    }

    public static Associator[] makeCopies(Associator model, int num) throws Exception {
        if (model == null) {
            throw new Exception("No model associator set");
        }
        Associator[] associators = new Associator[num];
        SerializedObject so = new SerializedObject(model);
        for (int i = 0; i < associators.length; ++i) {
            associators[i] = (Associator)so.getObject();
        }
        return associators;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities defaultC = new Capabilities(this);
        defaultC.enableAll();
        return defaultC;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 11006 $");
    }

    public static void runAssociator(Associator associator, String[] options) {
        try {
            System.out.println(AssociatorEvaluation.evaluate(associator, options));
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().indexOf("General options") == -1) {
                e.printStackTrace();
            }
            System.err.println(e.getMessage());
        }
    }
}

