/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.MultiFilter;
import weka.filters.SimpleBatchFilter;
import weka.filters.unsupervised.attribute.Normalize;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class Wavelet
extends SimpleBatchFilter
implements TechnicalInformationHandler {
    static final long serialVersionUID = -3335106965521265631L;
    public static final int ALGORITHM_HAAR = 0;
    public static final Tag[] TAGS_ALGORITHM = new Tag[]{new Tag(0, "Haar")};
    public static final int PADDING_ZERO = 0;
    public static final Tag[] TAGS_PADDING = new Tag[]{new Tag(0, "Zero")};
    protected Filter m_Filter = new MultiFilter();
    protected int m_Algorithm = 0;
    protected int m_Padding = 0;

    public Wavelet() {
        ((MultiFilter)this.m_Filter).setFilters(new Filter[]{new ReplaceMissingValues(), new Normalize()});
    }

    public String globalInfo() {
        return "A filter for wavelet transformation.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Wikipedia");
        result.setValue(TechnicalInformation.Field.YEAR, "2004");
        result.setValue(TechnicalInformation.Field.TITLE, "Discrete wavelet transform");
        result.setValue(TechnicalInformation.Field.HTTP, "http://en.wikipedia.org/wiki/Discrete_wavelet_transform");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.MISC);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "Kristian Sandberg");
        additional.setValue(TechnicalInformation.Field.YEAR, "2000");
        additional.setValue(TechnicalInformation.Field.TITLE, "The Haar wavelet transform");
        additional.setValue(TechnicalInformation.Field.INSTITUTION, "Dept. of Applied Mathematics");
        additional.setValue(TechnicalInformation.Field.ADDRESS, "University of Colorado at Boulder, USA");
        additional.setValue(TechnicalInformation.Field.HTTP, "http://amath.colorado.edu/courses/5720/2000Spr/Labs/Haar/haar.html");
        return result;
    }

    public Enumeration listOptions() {
        SelectedTag tag;
        int i;
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.addElement(enm.nextElement());
        }
        String param = "";
        for (i = 0; i < TAGS_ALGORITHM.length; ++i) {
            if (i > 0) {
                param = param + "|";
            }
            tag = new SelectedTag(TAGS_ALGORITHM[i].getID(), TAGS_ALGORITHM);
            param = param + tag.getSelectedTag().getReadable();
        }
        result.addElement(new Option("\tThe algorithm to use.\n\t(default: HAAR)", "A", 1, "-A <" + param + ">"));
        param = "";
        for (i = 0; i < TAGS_PADDING.length; ++i) {
            if (i > 0) {
                param = param + "|";
            }
            tag = new SelectedTag(TAGS_PADDING[i].getID(), TAGS_PADDING);
            param = param + tag.getSelectedTag().getReadable();
        }
        result.addElement(new Option("\tThe padding to use.\n\t(default: ZERO)", "P", 1, "-P <" + param + ">"));
        result.addElement(new Option("\tThe filter to use as preprocessing step (classname and options).\n\t(default: MultiFilter with ReplaceMissingValues and Normalize)", "F", 1, "-F <filter specification>"));
        if (this.getFilter() instanceof OptionHandler) {
            result.addElement(new Option("", "", 0, "\nOptions specific to filter " + this.getFilter().getClass().getName() + " ('-F'):"));
            enm = ((OptionHandler)((Object)this.getFilter())).listOptions();
            while (enm.hasMoreElements()) {
                result.addElement(enm.nextElement());
            }
        }
        return result.elements();
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        result.add("-A");
        result.add("" + this.getAlgorithm().getSelectedTag().getReadable());
        result.add("-P");
        result.add("" + this.getPadding().getSelectedTag().getReadable());
        result.add("-F");
        if (this.getFilter() instanceof OptionHandler) {
            result.add(this.getFilter().getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)this.getFilter())).getOptions()));
        } else {
            result.add(this.getFilter().getClass().getName());
        }
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption("A", options);
        if (tmpStr.length() != 0) {
            this.setAlgorithm(new SelectedTag(tmpStr, TAGS_ALGORITHM));
        } else {
            this.setAlgorithm(new SelectedTag(0, TAGS_ALGORITHM));
        }
        tmpStr = Utils.getOption("P", options);
        if (tmpStr.length() != 0) {
            this.setPadding(new SelectedTag(tmpStr, TAGS_PADDING));
        } else {
            this.setPadding(new SelectedTag(0, TAGS_PADDING));
        }
        tmpStr = Utils.getOption("F", options);
        String[] tmpOptions = Utils.splitOptions(tmpStr);
        if (tmpOptions.length != 0) {
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            this.setFilter((Filter)Utils.forName(Filter.class, tmpStr, tmpOptions));
        } else {
            MultiFilter filter = new MultiFilter();
            filter.setFilters(new Filter[]{new ReplaceMissingValues(), new Normalize()});
            this.setFilter(filter);
        }
    }

    public String filterTipText() {
        return "The preprocessing filter to use.";
    }

    public void setFilter(Filter value) {
        this.m_Filter = value;
    }

    public Filter getFilter() {
        return this.m_Filter;
    }

    public String algorithmTipText() {
        return "Sets the type of algorithm to use.";
    }

    public void setAlgorithm(SelectedTag value) {
        if (value.getTags() == TAGS_ALGORITHM) {
            this.m_Algorithm = value.getSelectedTag().getID();
        }
    }

    public SelectedTag getAlgorithm() {
        return new SelectedTag(this.m_Algorithm, TAGS_ALGORITHM);
    }

    public String paddingTipText() {
        return "Sets the type of padding to use.";
    }

    public void setPadding(SelectedTag value) {
        if (value.getTags() == TAGS_PADDING) {
            this.m_Padding = value.getSelectedTag().getID();
        }
    }

    public SelectedTag getPadding() {
        return new SelectedTag(this.m_Padding, TAGS_PADDING);
    }

    protected static int nextPowerOf2(int n) {
        int exp = (int)StrictMath.ceil(StrictMath.log(n) / StrictMath.log(2.0));
        exp = StrictMath.max(2, exp);
        return (int)StrictMath.pow(2.0, exp);
    }

    protected Instances pad(Instances data) {
        int n;
        int i;
        int numAtts;
        switch (this.m_Padding) {
            case 0: {
                if (data.classIndex() > -1) {
                    numAtts = Wavelet.nextPowerOf2(data.numAttributes() - 1) + 1 - data.numAttributes();
                    break;
                }
                numAtts = Wavelet.nextPowerOf2(data.numAttributes()) - data.numAttributes();
                break;
            }
            default: {
                throw new IllegalStateException("Padding " + new SelectedTag(this.m_Algorithm, TAGS_PADDING) + " not implemented!");
            }
        }
        Instances result = new Instances(data);
        String prefix = this.getAlgorithm().getSelectedTag().getReadable();
        if (numAtts > 0) {
            boolean isLast = data.classIndex() == data.numAttributes() - 1;
            Vector<Integer> padded = new Vector<Integer>();
            for (i = 0; i < numAtts; ++i) {
                int index = isLast ? result.numAttributes() - 1 : result.numAttributes();
                result.insertAttributeAt(new Attribute(prefix + "_padding_" + (i + 1)), index);
                padded.add(new Integer(index));
            }
            int[] indices = new int[padded.size()];
            for (i = 0; i < padded.size(); ++i) {
                indices[i] = (Integer)padded.get(i);
            }
            switch (this.m_Padding) {
                case 0: {
                    for (i = 0; i < result.numInstances(); ++i) {
                        for (n = 0; n < indices.length; ++n) {
                            result.instance(i).setValue(indices[n], 0.0);
                        }
                    }
                    break;
                }
            }
        }
        data = result;
        FastVector<Attribute> atts = new FastVector<Attribute>();
        n = 0;
        for (i = 0; i < data.numAttributes(); ++i) {
            ++n;
            if (i == data.classIndex()) {
                atts.addElement((Attribute)data.attribute(i).copy());
                continue;
            }
            atts.addElement(new Attribute(prefix + "_" + n));
        }
        result = new Instances(data.relationName(), atts, data.numInstances());
        result.setClassIndex(data.classIndex());
        for (i = 0; i < data.numInstances(); ++i) {
            result.add(new DenseInstance(1.0, data.instance(i).toDoubleArray()));
        }
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        return this.pad(new Instances(inputFormat, 0));
    }

    protected Instances processHAAR(Instances instances) throws Exception {
        int i;
        int clsIdx = instances.classIndex();
        double[] clsVal = null;
        Attribute clsAtt = null;
        if (clsIdx > -1) {
            clsVal = instances.attributeToDoubleArray(clsIdx);
            clsAtt = (Attribute)instances.classAttribute().copy();
            instances.setClassIndex(-1);
            instances.deleteAttributeAt(clsIdx);
        }
        Instances result = new Instances(instances, 0);
        int level = (int)StrictMath.ceil(StrictMath.log(instances.numAttributes()) / StrictMath.log(2.0));
        for (i = 0; i < instances.numInstances(); ++i) {
            double[] oldVal = instances.instance(i).toDoubleArray();
            double[] newVal = new double[oldVal.length];
            for (int n = level; n > 0; --n) {
                int length = (int)StrictMath.pow(2.0, n - 1);
                for (int j = 0; j < length; ++j) {
                    newVal[j] = (oldVal[j * 2] + oldVal[j * 2 + 1]) / StrictMath.sqrt(2.0);
                    newVal[j + length] = (oldVal[j * 2] - oldVal[j * 2 + 1]) / StrictMath.sqrt(2.0);
                }
                System.arraycopy(newVal, 0, oldVal, 0, newVal.length);
            }
            result.add(new DenseInstance(1.0, newVal));
        }
        if (clsIdx > -1) {
            result.insertAttributeAt(clsAtt, clsIdx);
            result.setClassIndex(clsIdx);
            for (i = 0; i < clsVal.length; ++i) {
                result.instance(i).setClassValue(clsVal[i]);
            }
        }
        return result;
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    protected Instances process(Instances instances) throws Exception {
        if (!this.isFirstBatchDone()) {
            this.m_Filter.setInputFormat(instances);
        }
        instances = Filter.useFilter(instances, this.m_Filter);
        switch (this.m_Algorithm) {
            case 0: {
                return this.processHAAR(this.pad(instances));
            }
        }
        throw new IllegalStateException("Algorithm type '" + this.m_Algorithm + "' is not recognized!");
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5987 $");
    }

    public static void main(String[] args) {
        Wavelet.runFilter(new Wavelet(), args);
    }
}

