/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class RandomProjection
extends Filter
implements UnsupervisedFilter,
OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = 4428905532728645880L;
    protected int m_k = 10;
    protected double m_percent = 0.0;
    protected boolean m_useGaussian = false;
    public static final int SPARSE1 = 1;
    public static final int SPARSE2 = 2;
    public static final int GAUSSIAN = 3;
    public static final Tag[] TAGS_DSTRS_TYPE = new Tag[]{new Tag(1, "Sparse 1"), new Tag(2, "Sparse 2"), new Tag(3, "Gaussian")};
    protected int m_distribution = 1;
    protected boolean m_useReplaceMissing = false;
    protected boolean m_OutputFormatDefined = false;
    protected Filter m_ntob;
    protected Filter m_replaceMissing;
    protected long m_rndmSeed = 42L;
    protected double[][] m_rmatrix;
    protected Random m_random;
    private static final int[] weights = new int[]{1, 1, 4};
    private static final int[] vals = new int[]{-1, 1, 0};
    private static final int[] weights2 = new int[]{1, 1};
    private static final int[] vals2 = new int[]{-1, 1};
    private static final double sqrt3 = Math.sqrt(3.0);

    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(2);
        newVector.addElement(new Option("\tThe number of dimensions (attributes) the data should be reduced to\n\t(default 10; exclusive of the class attribute, if it is set).", "N", 1, "-N <number>"));
        newVector.addElement(new Option("\tThe distribution to use for calculating the random matrix.\n\tSparse1 is:\n\t  sqrt(3)*{-1 with prob(1/6), 0 with prob(2/3), +1 with prob(1/6)}\n\tSparse2 is:\n\t  {-1 with prob(1/2), +1 with prob(1/2)}\n", "D", 1, "-D [SPARSE1|SPARSE2|GAUSSIAN]"));
        newVector.addElement(new Option("\tThe percentage of dimensions (attributes) the data should\n\tbe reduced to (exclusive of the class attribute, if it is set). This -N\n\toption is ignored if this option is present or is greater\n\tthan zero.", "P", 1, "-P <percent>"));
        newVector.addElement(new Option("\tReplace missing values using the ReplaceMissingValues filter", "M", 0, "-M"));
        newVector.addElement(new Option("\tThe random seed for the random number generator used for\n\tcalculating the random matrix (default 42).", "R", 0, "-R <num>"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String mString = Utils.getOption('P', options);
        if (mString.length() != 0) {
            this.setPercent(Double.parseDouble(mString));
        } else {
            this.setPercent(0.0);
            mString = Utils.getOption('N', options);
            if (mString.length() != 0) {
                this.setNumberOfAttributes(Integer.parseInt(mString));
            } else {
                this.setNumberOfAttributes(10);
            }
        }
        mString = Utils.getOption('R', options);
        if (mString.length() != 0) {
            this.setRandomSeed(Long.parseLong(mString));
        }
        if ((mString = Utils.getOption('D', options)).length() != 0) {
            if (mString.equalsIgnoreCase("sparse1")) {
                this.setDistribution(new SelectedTag(1, TAGS_DSTRS_TYPE));
            } else if (mString.equalsIgnoreCase("sparse2")) {
                this.setDistribution(new SelectedTag(2, TAGS_DSTRS_TYPE));
            } else if (mString.equalsIgnoreCase("gaussian")) {
                this.setDistribution(new SelectedTag(3, TAGS_DSTRS_TYPE));
            }
        }
        if (Utils.getFlag('M', options)) {
            this.setReplaceMissingValues(true);
        } else {
            this.setReplaceMissingValues(false);
        }
    }

    public String[] getOptions() {
        String[] options = new String[10];
        int current = 0;
        if (this.getReplaceMissingValues()) {
            options[current++] = "-M";
        }
        if (this.getPercent() == 0.0) {
            options[current++] = "-N";
            options[current++] = "" + this.getNumberOfAttributes();
        } else {
            options[current++] = "-P";
            options[current++] = "" + this.getPercent();
        }
        options[current++] = "-R";
        options[current++] = "" + this.getRandomSeed();
        SelectedTag t = this.getDistribution();
        options[current++] = "-D";
        options[current++] = "" + t.getSelectedTag().getReadable();
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String globalInfo() {
        return "Reduces the dimensionality of the data by projecting it onto a lower dimensional subspace using a random matrix with columns of unit length (i.e. It will reduce the number of attributes in the data while preserving much of its variation like PCA, but at a much less computational cost).\nIt first applies the  NominalToBinary filter to convert all attributes to numeric before reducing the dimension. It preserves the class attribute.\n\nFor more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Dmitriy Fradkin and David Madigan");
        result.setValue(TechnicalInformation.Field.TITLE, "Experiments with random projections for machine learning");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "KDD '03: Proceedings of the ninth ACM SIGKDD international conference on Knowledge discovery and data mining");
        result.setValue(TechnicalInformation.Field.YEAR, "003");
        result.setValue(TechnicalInformation.Field.PAGES, "517-522");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "ACM Press");
        result.setValue(TechnicalInformation.Field.ADDRESS, "New York, NY, USA");
        return result;
    }

    public String numberOfAttributesTipText() {
        return "The number of dimensions (attributes) the data should be reduced to.";
    }

    public void setNumberOfAttributes(int newAttNum) {
        this.m_k = newAttNum;
    }

    public int getNumberOfAttributes() {
        return this.m_k;
    }

    public String percentTipText() {
        return " The percentage of dimensions (attributes) the data should be reduced to  (inclusive of the class attribute). This  NumberOfAttributes option is ignored if this option is present or is greater than zero.";
    }

    public void setPercent(double newPercent) {
        if (newPercent > 0.0) {
            newPercent /= 100.0;
        }
        this.m_percent = newPercent;
    }

    public double getPercent() {
        return this.m_percent * 100.0;
    }

    public String randomSeedTipText() {
        return "The random seed used by the random number generator used for generating the random matrix ";
    }

    public void setRandomSeed(long seed) {
        this.m_rndmSeed = seed;
    }

    public long getRandomSeed() {
        return this.m_rndmSeed;
    }

    public String distributionTipText() {
        return "The distribution to use for calculating the random matrix.\nSparse1 is:\n sqrt(3) * { -1 with prob(1/6), \n               0 with prob(2/3),  \n              +1 with prob(1/6) } \nSparse2 is:\n { -1 with prob(1/2), \n   +1 with prob(1/2) } ";
    }

    public void setDistribution(SelectedTag newDstr) {
        if (newDstr.getTags() == TAGS_DSTRS_TYPE) {
            this.m_distribution = newDstr.getSelectedTag().getID();
        }
    }

    public SelectedTag getDistribution() {
        return new SelectedTag(this.m_distribution, TAGS_DSTRS_TYPE);
    }

    public String replaceMissingValuesTipText() {
        return "If set the filter uses weka.filters.unsupervised.attribute.ReplaceMissingValues to replace the missing values";
    }

    public void setReplaceMissingValues(boolean t) {
        this.m_useReplaceMissing = t;
    }

    public boolean getReplaceMissingValues() {
        return this.m_useReplaceMissing;
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        for (int i = 0; i < instanceInfo.numAttributes(); ++i) {
            if (i == instanceInfo.classIndex() || !instanceInfo.attribute(i).isNominal()) continue;
            if (instanceInfo.classIndex() >= 0) {
                this.m_ntob = new weka.filters.supervised.attribute.NominalToBinary();
                break;
            }
            this.m_ntob = new NominalToBinary();
            break;
        }
        boolean temp = true;
        if (this.m_replaceMissing != null) {
            this.m_replaceMissing = new ReplaceMissingValues();
            temp = this.m_replaceMissing.setInputFormat(instanceInfo);
        }
        if (this.m_ntob != null) {
            if (this.m_ntob.setInputFormat(instanceInfo)) {
                this.setOutputFormat();
                return temp;
            }
            return false;
        }
        this.setOutputFormat();
        return temp;
    }

    public boolean input(Instance instance) throws Exception {
        Instance newInstance = null;
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        boolean replaceDone = false;
        if (this.m_replaceMissing != null) {
            if (this.m_replaceMissing.input(instance)) {
                if (!this.m_OutputFormatDefined) {
                    this.setOutputFormat();
                }
                newInstance = this.m_replaceMissing.output();
                replaceDone = true;
            } else {
                return false;
            }
        }
        if (this.m_ntob != null) {
            if (!replaceDone) {
                newInstance = instance;
            }
            if (this.m_ntob.input(newInstance)) {
                if (!this.m_OutputFormatDefined) {
                    this.setOutputFormat();
                }
                newInstance = this.m_ntob.output();
                newInstance = this.convertInstance(newInstance);
                this.push(newInstance);
                return true;
            }
            return false;
        }
        if (!replaceDone) {
            newInstance = instance;
        }
        newInstance = this.convertInstance(newInstance);
        this.push(newInstance);
        return true;
    }

    public boolean batchFinished() throws Exception {
        Instance newInstance;
        Instance instance;
        if (this.getInputFormat() == null) {
            throw new NullPointerException("No input instance format defined");
        }
        boolean conversionDone = false;
        if (this.m_replaceMissing != null && this.m_replaceMissing.batchFinished()) {
            while ((instance = this.m_replaceMissing.output()) != null) {
                if (!this.m_OutputFormatDefined) {
                    this.setOutputFormat();
                }
                if (this.m_ntob != null) {
                    this.m_ntob.input(instance);
                    continue;
                }
                newInstance = this.convertInstance(instance);
                this.push(newInstance);
            }
            if (this.m_ntob != null && this.m_ntob.batchFinished()) {
                while ((instance = this.m_ntob.output()) != null) {
                    if (!this.m_OutputFormatDefined) {
                        this.setOutputFormat();
                    }
                    newInstance = this.convertInstance(instance);
                    this.push(newInstance);
                }
                this.m_ntob = null;
            }
            this.m_replaceMissing = null;
            conversionDone = true;
        }
        if (!conversionDone && this.m_ntob != null && this.m_ntob.batchFinished()) {
            while ((instance = this.m_ntob.output()) != null) {
                if (!this.m_OutputFormatDefined) {
                    this.setOutputFormat();
                }
                newInstance = this.convertInstance(instance);
                this.push(newInstance);
            }
            this.m_ntob = null;
        }
        this.m_OutputFormatDefined = false;
        return super.batchFinished();
    }

    protected void setOutputFormat() {
        int i;
        Instances currentFormat = this.m_ntob != null ? this.m_ntob.getOutputFormat() : this.getInputFormat();
        if (this.m_percent > 0.0) {
            this.m_k = (int)((double)(this.getInputFormat().numAttributes() - 1) * this.m_percent);
        }
        int newClassIndex = -1;
        FastVector<Attribute> attributes = new FastVector<Attribute>();
        for (i = 0; i < this.m_k; ++i) {
            attributes.addElement(new Attribute("K" + (i + 1)));
        }
        if (currentFormat.classIndex() != -1) {
            attributes.addElement(currentFormat.attribute(currentFormat.classIndex()));
            newClassIndex = attributes.size() - 1;
        }
        Instances newFormat = new Instances(currentFormat.relationName(), attributes, 0);
        if (newClassIndex != -1) {
            newFormat.setClassIndex(newClassIndex);
        }
        this.m_OutputFormatDefined = true;
        this.m_random = new Random();
        this.m_random.setSeed(this.m_rndmSeed);
        this.m_rmatrix = new double[this.m_k][currentFormat.numAttributes()];
        if (this.m_distribution == 3) {
            for (i = 0; i < this.m_rmatrix.length; ++i) {
                for (int j = 0; j < this.m_rmatrix[i].length; ++j) {
                    this.m_rmatrix[i][j] = this.m_random.nextGaussian();
                }
            }
        } else {
            boolean useDstrWithZero = this.m_distribution == 1;
            for (int i2 = 0; i2 < this.m_rmatrix.length; ++i2) {
                for (int j = 0; j < this.m_rmatrix[i2].length; ++j) {
                    this.m_rmatrix[i2][j] = this.rndmNum(useDstrWithZero);
                }
            }
        }
        this.setOutputFormat(newFormat);
    }

    protected Instance convertInstance(Instance currentInstance) {
        double[] vals = new double[this.getOutputFormat().numAttributes()];
        int classIndex = this.m_ntob == null ? this.getInputFormat().classIndex() : this.m_ntob.getOutputFormat().classIndex();
        for (int i = 0; i < this.m_k; ++i) {
            vals[i] = this.computeRandomProjection(i, classIndex, currentInstance);
        }
        if (classIndex != -1) {
            vals[this.m_k] = currentInstance.value(classIndex);
        }
        DenseInstance newInstance = new DenseInstance(currentInstance.weight(), vals);
        newInstance.setDataset(this.getOutputFormat());
        return newInstance;
    }

    protected double computeRandomProjection(int rpIndex, int classIndex, Instance instance) {
        double sum = 0.0;
        for (int i = 0; i < instance.numValues(); ++i) {
            double value;
            int index = instance.index(i);
            if (index == classIndex || Utils.isMissingValue(value = instance.valueSparse(i))) continue;
            sum += this.m_rmatrix[rpIndex][index] * value;
        }
        return sum;
    }

    protected double rndmNum(boolean useDstrWithZero) {
        if (useDstrWithZero) {
            return sqrt3 * (double)vals[this.weightedDistribution(weights)];
        }
        return vals2[this.weightedDistribution(weights2)];
    }

    protected int weightedDistribution(int[] weights) {
        int sum = 0;
        for (int i = 0; i < weights.length; ++i) {
            sum += weights[i];
        }
        int val = (int)Math.floor(this.m_random.nextDouble() * (double)sum);
        for (int i = 0; i < weights.length; ++i) {
            if ((val -= weights[i]) >= 0) continue;
            return i;
        }
        return -1;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5987 $");
    }

    public static void main(String[] argv) {
        RandomProjection.runFilter(new RandomProjection(), argv);
    }
}

