/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import weka.classifiers.bayes.net.GUI;
import weka.classifiers.evaluation.ThresholdCurve;
import weka.core.Copyright;
import weka.core.Instances;
import weka.core.Memory;
import weka.core.SystemInfo;
import weka.core.Utils;
import weka.core.Version;
import weka.core.logging.Logger;
import weka.core.scripting.Groovy;
import weka.core.scripting.Jython;
import weka.gui.BrowserHelper;
import weka.gui.ExtensionFileFilter;
import weka.gui.GenericObjectEditor;
import weka.gui.LogWindow;
import weka.gui.LookAndFeel;
import weka.gui.MainMenuExtension;
import weka.gui.MemoryUsagePanel;
import weka.gui.SimpleCLI;
import weka.gui.arffviewer.ArffViewer;
import weka.gui.beans.KnowledgeFlow;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.beans.StartUpListener;
import weka.gui.boundaryvisualizer.BoundaryVisualizer;
import weka.gui.experiment.Experimenter;
import weka.gui.explorer.Explorer;
import weka.gui.graphvisualizer.GraphVisualizer;
import weka.gui.scripting.GroovyPanel;
import weka.gui.scripting.JythonPanel;
import weka.gui.sql.SqlViewer;
import weka.gui.treevisualizer.Node;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeBuild;
import weka.gui.treevisualizer.TreeVisualizer;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.ThresholdVisualizePanel;
import weka.gui.visualize.VisualizePanel;

public class GUIChooser
extends JFrame {
    private static final long serialVersionUID = 9001529425230247914L;
    protected GUIChooser m_Self;
    private JMenuBar m_jMenuBar;
    private JMenu m_jMenuProgram;
    private JMenu m_jMenuVisualization;
    private JMenu m_jMenuTools;
    private JMenu m_jMenuHelp;
    protected JPanel m_PanelApplications = new JPanel();
    protected JButton m_ExplorerBut = new JButton("Explorer");
    protected JFrame m_ExplorerFrame;
    protected JButton m_ExperimenterBut = new JButton("Experimenter");
    protected JFrame m_ExperimenterFrame;
    protected JButton m_KnowledgeFlowBut = new JButton("KnowledgeFlow");
    protected JFrame m_KnowledgeFlowFrame;
    protected JButton m_SimpleBut = new JButton("Simple CLI");
    protected SimpleCLI m_SimpleCLI;
    protected JFrame m_GroovyConsoleFrame;
    protected JFrame m_JythonConsoleFrame;
    protected Vector m_ArffViewers = new Vector();
    protected JFrame m_SqlViewerFrame;
    protected JFrame m_BayesNetGUIFrame;
    protected JFrame m_EnsembleLibraryFrame;
    protected Vector m_Plots = new Vector();
    protected Vector m_ROCs = new Vector();
    protected Vector m_TreeVisualizers = new Vector();
    protected Vector m_GraphVisualizers = new Vector();
    protected JFrame m_BoundaryVisualizerFrame;
    protected JFrame m_SystemInfoFrame;
    protected JFrame m_MemoryUsageFrame;
    protected static LogWindow m_LogWindow = new LogWindow();
    Image m_weka = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("weka/gui/images/weka_background.gif"));
    protected JFileChooser m_FileChooserTreeVisualizer = new JFileChooser(new File(System.getProperty("user.dir")));
    protected JFileChooser m_FileChooserGraphVisualizer = new JFileChooser(new File(System.getProperty("user.dir")));
    protected JFileChooser m_FileChooserPlot = new JFileChooser(new File(System.getProperty("user.dir")));
    protected JFileChooser m_FileChooserROC = new JFileChooser(new File(System.getProperty("user.dir")));
    protected Image m_Icon;
    protected HashSet<Container> m_ChildFrames = new HashSet();
    private static GUIChooser m_chooser;
    private static Memory m_Memory;

    public GUIChooser() {
        super("Weka GUI Chooser");
        this.m_Self = this;
        this.m_FileChooserGraphVisualizer.addChoosableFileFilter(new ExtensionFileFilter(".bif", "BIF Files (*.bif)"));
        this.m_FileChooserGraphVisualizer.addChoosableFileFilter(new ExtensionFileFilter(".xml", "XML Files (*.xml)"));
        this.m_FileChooserPlot.addChoosableFileFilter(new ExtensionFileFilter(".arff", "ARFF Files (*.arff)"));
        this.m_FileChooserPlot.setMultiSelectionEnabled(true);
        this.m_FileChooserROC.addChoosableFileFilter(new ExtensionFileFilter(".arff", "ARFF Files (*.arff)"));
        this.m_Icon = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("weka/gui/weka_icon.gif"));
        this.setIconImage(this.m_Icon);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.m_PanelApplications, "East");
        this.m_PanelApplications.setBorder(BorderFactory.createTitledBorder("Applications"));
        this.m_PanelApplications.setLayout(new GridLayout(4, 1));
        this.m_PanelApplications.add(this.m_ExplorerBut);
        this.m_PanelApplications.add(this.m_ExperimenterBut);
        this.m_PanelApplications.add(this.m_KnowledgeFlowBut);
        this.m_PanelApplications.add(this.m_SimpleBut);
        JPanel wekaPan = new JPanel();
        wekaPan.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        wekaPan.setLayout(new BorderLayout());
        wekaPan.setToolTipText("Weka, a native bird of New Zealand");
        ImageIcon wii = new ImageIcon(this.m_weka);
        JLabel wekaLab = new JLabel(wii);
        wekaPan.add((Component)wekaLab, "Center");
        String infoString = "<html><font size=-2>Waikato Environment for Knowledge Analysis<br>Version " + Version.VERSION + "<br>" + "(c) " + Copyright.getFromYear() + " - " + Copyright.getToYear() + "<br>" + Copyright.getOwner() + "<br>" + Copyright.getAddress() + "</font>" + "</html>";
        JLabel infoLab = new JLabel(infoString);
        infoLab.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        wekaPan.add((Component)infoLab, "South");
        this.getContentPane().add((Component)wekaPan, "Center");
        this.m_jMenuBar = new JMenuBar();
        this.m_jMenuProgram = new JMenu();
        this.m_jMenuBar.add(this.m_jMenuProgram);
        this.m_jMenuProgram.setText("Program");
        this.m_jMenuProgram.setMnemonic('P');
        JMenuItem jMenuItemProgramLogWindow = new JMenuItem();
        this.m_jMenuProgram.add(jMenuItemProgramLogWindow);
        jMenuItemProgramLogWindow.setText("LogWindow");
        jMenuItemProgramLogWindow.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        m_LogWindow.setIconImage(this.m_Icon);
        jMenuItemProgramLogWindow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                m_LogWindow.setVisible(true);
            }
        });
        final JMenuItem jMenuItemProgramMemUsage = new JMenuItem();
        this.m_jMenuProgram.add(jMenuItemProgramMemUsage);
        jMenuItemProgramMemUsage.setText("Memory usage");
        jMenuItemProgramMemUsage.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        jMenuItemProgramMemUsage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GUIChooser.this.m_MemoryUsageFrame == null) {
                    final MemoryUsagePanel panel = new MemoryUsagePanel();
                    jMenuItemProgramMemUsage.setEnabled(false);
                    GUIChooser.this.m_MemoryUsageFrame = new JFrame("Memory usage");
                    GUIChooser.this.m_MemoryUsageFrame.setIconImage(GUIChooser.this.m_Icon);
                    GUIChooser.this.m_MemoryUsageFrame.getContentPane().setLayout(new BorderLayout());
                    GUIChooser.this.m_MemoryUsageFrame.getContentPane().add((Component)panel, "Center");
                    GUIChooser.this.m_MemoryUsageFrame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent w) {
                            panel.stopMonitoring();
                            GUIChooser.this.m_MemoryUsageFrame.dispose();
                            GUIChooser.this.m_MemoryUsageFrame = null;
                            jMenuItemProgramMemUsage.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_MemoryUsageFrame.pack();
                    GUIChooser.this.m_MemoryUsageFrame.setSize(400, 50);
                    Point l = panel.getFrameLocation();
                    if (l.x != -1 && l.y != -1) {
                        GUIChooser.this.m_MemoryUsageFrame.setLocation(l);
                    }
                    GUIChooser.this.m_MemoryUsageFrame.setVisible(true);
                    Dimension size = GUIChooser.this.m_MemoryUsageFrame.getPreferredSize();
                    GUIChooser.this.m_MemoryUsageFrame.setSize(new Dimension((int)size.getWidth(), (int)size.getHeight()));
                }
            }
        });
        this.m_jMenuProgram.add(new JSeparator());
        JMenuItem jMenuItemProgramExit = new JMenuItem();
        this.m_jMenuProgram.add(jMenuItemProgramExit);
        jMenuItemProgramExit.setText("Exit");
        jMenuItemProgramExit.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        jMenuItemProgramExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIChooser.this.dispose();
                GUIChooser.this.checkExit();
            }
        });
        this.m_jMenuVisualization = new JMenu();
        this.m_jMenuBar.add(this.m_jMenuVisualization);
        this.m_jMenuVisualization.setText("Visualization");
        this.m_jMenuVisualization.setMnemonic('V');
        JMenuItem jMenuItemVisualizationPlot = new JMenuItem();
        this.m_jMenuVisualization.add(jMenuItemVisualizationPlot);
        jMenuItemVisualizationPlot.setText("Plot");
        jMenuItemVisualizationPlot.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        jMenuItemVisualizationPlot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int retVal = GUIChooser.this.m_FileChooserPlot.showOpenDialog(GUIChooser.this.m_Self);
                if (retVal != 0) {
                    return;
                }
                VisualizePanel panel = new VisualizePanel();
                String filenames = "";
                File[] files = GUIChooser.this.m_FileChooserPlot.getSelectedFiles();
                for (int j = 0; j < files.length; ++j) {
                    String filename = files[j].getAbsolutePath();
                    if (j > 0) {
                        filenames = filenames + ", ";
                    }
                    filenames = filenames + filename;
                    System.err.println("Loading instances from " + filename);
                    try {
                        BufferedReader r = new BufferedReader(new FileReader(filename));
                        Instances i = new Instances(r);
                        i.setClassIndex(i.numAttributes() - 1);
                        PlotData2D pd1 = new PlotData2D(i);
                        if (j == 0) {
                            pd1.setPlotName("Master plot");
                            panel.setMasterPlot(pd1);
                            continue;
                        }
                        pd1.setPlotName("Plot " + (j + 1));
                        pd1.m_useCustomColour = true;
                        pd1.m_customColour = j % 2 == 0 ? Color.red : Color.blue;
                        panel.addPlot(pd1);
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(GUIChooser.this.m_Self, "Error loading file '" + files[j] + "':\n" + ex.getMessage());
                        return;
                    }
                }
                final JFrame frame = new JFrame("Plot - " + filenames);
                frame.setIconImage(GUIChooser.this.m_Icon);
                frame.getContentPane().setLayout(new BorderLayout());
                frame.getContentPane().add((Component)panel, "Center");
                frame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        GUIChooser.this.m_Plots.remove(frame);
                        frame.dispose();
                        GUIChooser.this.checkExit();
                    }
                });
                frame.pack();
                frame.setSize(800, 600);
                frame.setVisible(true);
                GUIChooser.this.m_Plots.add(frame);
            }
        });
        JMenuItem jMenuItemVisualizationROC = new JMenuItem();
        this.m_jMenuVisualization.add(jMenuItemVisualizationROC);
        jMenuItemVisualizationROC.setText("ROC");
        jMenuItemVisualizationROC.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        jMenuItemVisualizationROC.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int retVal = GUIChooser.this.m_FileChooserROC.showOpenDialog(GUIChooser.this.m_Self);
                if (retVal != 0) {
                    return;
                }
                String filename = GUIChooser.this.m_FileChooserROC.getSelectedFile().getAbsolutePath();
                Instances result = null;
                try {
                    result = new Instances(new BufferedReader(new FileReader(filename)));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(GUIChooser.this.m_Self, "Error loading file '" + filename + "':\n" + ex.getMessage());
                    return;
                }
                result.setClassIndex(result.numAttributes() - 1);
                ThresholdVisualizePanel vmc = new ThresholdVisualizePanel();
                vmc.setROCString("(Area under ROC = " + Utils.doubleToString(ThresholdCurve.getROCArea(result), 4) + ")");
                vmc.setName(result.relationName());
                PlotData2D tempd = new PlotData2D(result);
                tempd.setPlotName(result.relationName());
                tempd.addInstanceNumberAttribute();
                try {
                    vmc.addPlot(tempd);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(GUIChooser.this.m_Self, "Error adding plot:\n" + ex.getMessage());
                    return;
                }
                final JFrame frame = new JFrame("ROC - " + filename);
                frame.setIconImage(GUIChooser.this.m_Icon);
                frame.getContentPane().setLayout(new BorderLayout());
                frame.getContentPane().add((Component)vmc, "Center");
                frame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        GUIChooser.this.m_ROCs.remove(frame);
                        frame.dispose();
                        GUIChooser.this.checkExit();
                    }
                });
                frame.pack();
                frame.setSize(800, 600);
                frame.setVisible(true);
                GUIChooser.this.m_ROCs.add(frame);
            }
        });
        JMenuItem jMenuItemVisualizationTree = new JMenuItem();
        this.m_jMenuVisualization.add(jMenuItemVisualizationTree);
        jMenuItemVisualizationTree.setText("TreeVisualizer");
        jMenuItemVisualizationTree.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        jMenuItemVisualizationTree.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int retVal = GUIChooser.this.m_FileChooserTreeVisualizer.showOpenDialog(GUIChooser.this.m_Self);
                if (retVal != 0) {
                    return;
                }
                String filename = GUIChooser.this.m_FileChooserTreeVisualizer.getSelectedFile().getAbsolutePath();
                TreeBuild builder = new TreeBuild();
                Node top = null;
                PlaceNode2 arrange = new PlaceNode2();
                try {
                    top = builder.create(new FileReader(filename));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(GUIChooser.this.m_Self, "Error loading file '" + filename + "':\n" + ex.getMessage());
                    return;
                }
                final JFrame frame = new JFrame("TreeVisualizer - " + filename);
                frame.setIconImage(GUIChooser.this.m_Icon);
                frame.getContentPane().setLayout(new BorderLayout());
                frame.getContentPane().add((Component)new TreeVisualizer(null, top, (NodePlace)arrange), "Center");
                frame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        GUIChooser.this.m_TreeVisualizers.remove(frame);
                        frame.dispose();
                        GUIChooser.this.checkExit();
                    }
                });
                frame.pack();
                frame.setSize(800, 600);
                frame.setVisible(true);
                GUIChooser.this.m_TreeVisualizers.add(frame);
            }
        });
        JMenuItem jMenuItemVisualizationGraph = new JMenuItem();
        this.m_jMenuVisualization.add(jMenuItemVisualizationGraph);
        jMenuItemVisualizationGraph.setText("GraphVisualizer");
        jMenuItemVisualizationGraph.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        jMenuItemVisualizationGraph.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int retVal = GUIChooser.this.m_FileChooserGraphVisualizer.showOpenDialog(GUIChooser.this.m_Self);
                if (retVal != 0) {
                    return;
                }
                String filename = GUIChooser.this.m_FileChooserGraphVisualizer.getSelectedFile().getAbsolutePath();
                GraphVisualizer panel = new GraphVisualizer();
                try {
                    if (filename.toLowerCase().endsWith(".xml") || filename.toLowerCase().endsWith(".bif")) {
                        panel.readBIF(new FileInputStream(filename));
                    } else {
                        panel.readDOT(new FileReader(filename));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(GUIChooser.this.m_Self, "Error loading file '" + filename + "':\n" + ex.getMessage());
                    return;
                }
                final JFrame frame = new JFrame("GraphVisualizer - " + filename);
                frame.setIconImage(GUIChooser.this.m_Icon);
                frame.getContentPane().setLayout(new BorderLayout());
                frame.getContentPane().add((Component)panel, "Center");
                frame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        GUIChooser.this.m_GraphVisualizers.remove(frame);
                        frame.dispose();
                        GUIChooser.this.checkExit();
                    }
                });
                frame.pack();
                frame.setSize(800, 600);
                frame.setVisible(true);
                GUIChooser.this.m_GraphVisualizers.add(frame);
            }
        });
        final JMenuItem jMenuItemVisualizationBoundary = new JMenuItem();
        this.m_jMenuVisualization.add(jMenuItemVisualizationBoundary);
        jMenuItemVisualizationBoundary.setText("BoundaryVisualizer");
        jMenuItemVisualizationBoundary.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        jMenuItemVisualizationBoundary.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GUIChooser.this.m_BoundaryVisualizerFrame == null) {
                    jMenuItemVisualizationBoundary.setEnabled(false);
                    GUIChooser.this.m_BoundaryVisualizerFrame = new JFrame("BoundaryVisualizer");
                    GUIChooser.this.m_BoundaryVisualizerFrame.setIconImage(GUIChooser.this.m_Icon);
                    GUIChooser.this.m_BoundaryVisualizerFrame.getContentPane().setLayout(new BorderLayout());
                    final BoundaryVisualizer bv = new BoundaryVisualizer();
                    GUIChooser.this.m_BoundaryVisualizerFrame.getContentPane().add((Component)bv, "Center");
                    GUIChooser.this.m_BoundaryVisualizerFrame.setSize(bv.getMinimumSize());
                    GUIChooser.this.m_BoundaryVisualizerFrame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent w) {
                            bv.stopPlotting();
                            GUIChooser.this.m_BoundaryVisualizerFrame.dispose();
                            GUIChooser.this.m_BoundaryVisualizerFrame = null;
                            jMenuItemVisualizationBoundary.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_BoundaryVisualizerFrame.pack();
                    GUIChooser.this.m_BoundaryVisualizerFrame.setResizable(false);
                    GUIChooser.this.m_BoundaryVisualizerFrame.setVisible(true);
                    BoundaryVisualizer.setExitIfNoWindowsOpen(false);
                }
            }
        });
        JMenu jMenuExtensions = new JMenu("Extensions");
        jMenuExtensions.setMnemonic(69);
        this.m_jMenuBar.add(jMenuExtensions);
        jMenuExtensions.setVisible(false);
        String extensions = GenericObjectEditor.EDITOR_PROPERTIES.getProperty(MainMenuExtension.class.getName(), "");
        if (extensions.length() > 0) {
            jMenuExtensions.setVisible(true);
            String[] classnames = GenericObjectEditor.EDITOR_PROPERTIES.getProperty(MainMenuExtension.class.getName(), "").split(",");
            Hashtable<String, JMenu> submenus = new Hashtable<String, JMenu>();
            for (int i = 0; i < classnames.length; ++i) {
                String classname = classnames[i];
                try {
                    MainMenuExtension ext = (MainMenuExtension)Class.forName(classname).newInstance();
                    JMenu submenu = null;
                    if (ext.getSubmenuTitle() != null && (submenu = (JMenu)submenus.get(ext.getSubmenuTitle())) == null) {
                        submenu = new JMenu(ext.getSubmenuTitle());
                        submenus.put(ext.getSubmenuTitle(), submenu);
                        this.insertMenuItem(jMenuExtensions, submenu);
                    }
                    JMenuItem menuitem = new JMenuItem();
                    menuitem.setText(ext.getMenuTitle());
                    ActionListener listener = ext.getActionListener(this.m_Self);
                    if (listener != null) {
                        menuitem.addActionListener(listener);
                    } else {
                        final JMenuItem finalMenuitem = menuitem;
                        final MainMenuExtension finalExt = ext;
                        menuitem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                Container frame = GUIChooser.this.createFrame(GUIChooser.this.m_Self, finalMenuitem.getText(), null, null, null, -1, -1, null, false, false);
                                finalExt.fillFrame(frame);
                                frame.setVisible(true);
                            }
                        });
                    }
                    if (submenu != null) {
                        this.insertMenuItem(submenu, menuitem);
                        continue;
                    }
                    this.insertMenuItem(jMenuExtensions, menuitem);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.m_jMenuTools = new JMenu();
        this.m_jMenuBar.add(this.m_jMenuTools);
        this.m_jMenuTools.setText("Tools");
        this.m_jMenuTools.setMnemonic('T');
        JMenuItem jMenuItemToolsArffViewer = new JMenuItem();
        this.m_jMenuTools.add(jMenuItemToolsArffViewer);
        jMenuItemToolsArffViewer.setText("ArffViewer");
        jMenuItemToolsArffViewer.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        jMenuItemToolsArffViewer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                final ArffViewer av = new ArffViewer();
                av.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent w) {
                        GUIChooser.this.m_ArffViewers.remove(av);
                        GUIChooser.this.checkExit();
                    }
                });
                av.setVisible(true);
                GUIChooser.this.m_ArffViewers.add(av);
            }
        });
        final JMenuItem jMenuItemToolsSql = new JMenuItem();
        this.m_jMenuTools.add(jMenuItemToolsSql);
        jMenuItemToolsSql.setText("SqlViewer");
        jMenuItemToolsSql.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        jMenuItemToolsSql.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GUIChooser.this.m_SqlViewerFrame == null) {
                    jMenuItemToolsSql.setEnabled(false);
                    final SqlViewer sql = new SqlViewer(null);
                    GUIChooser.this.m_SqlViewerFrame = new JFrame("SqlViewer");
                    GUIChooser.this.m_SqlViewerFrame.setIconImage(GUIChooser.this.m_Icon);
                    GUIChooser.this.m_SqlViewerFrame.getContentPane().setLayout(new BorderLayout());
                    GUIChooser.this.m_SqlViewerFrame.getContentPane().add((Component)sql, "Center");
                    GUIChooser.this.m_SqlViewerFrame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent w) {
                            sql.saveSize();
                            GUIChooser.this.m_SqlViewerFrame.dispose();
                            GUIChooser.this.m_SqlViewerFrame = null;
                            jMenuItemToolsSql.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_SqlViewerFrame.pack();
                    GUIChooser.this.m_SqlViewerFrame.setVisible(true);
                }
            }
        });
        final JMenuItem jMenuItemBayesNet = new JMenuItem();
        this.m_jMenuTools.add(jMenuItemBayesNet);
        jMenuItemBayesNet.setText("Bayes net editor");
        jMenuItemBayesNet.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        jMenuItemBayesNet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GUIChooser.this.m_BayesNetGUIFrame == null) {
                    jMenuItemBayesNet.setEnabled(false);
                    GUI bayesNetGUI = new GUI();
                    JMenuBar bayesBar = bayesNetGUI.getMenuBar();
                    GUIChooser.this.m_BayesNetGUIFrame = new JFrame("Bayes Network Editor");
                    GUIChooser.this.m_BayesNetGUIFrame.setIconImage(GUIChooser.this.m_Icon);
                    GUIChooser.this.m_BayesNetGUIFrame.setJMenuBar(bayesBar);
                    GUIChooser.this.m_BayesNetGUIFrame.getContentPane().add((Component)bayesNetGUI, "Center");
                    GUIChooser.this.m_BayesNetGUIFrame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent w) {
                            GUIChooser.this.m_BayesNetGUIFrame.dispose();
                            GUIChooser.this.m_BayesNetGUIFrame = null;
                            jMenuItemBayesNet.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_BayesNetGUIFrame.setSize(800, 600);
                    GUIChooser.this.m_BayesNetGUIFrame.setVisible(true);
                }
            }
        });
        if (Groovy.isPresent()) {
            final JMenuItem jMenuItemGroovyConsole = new JMenuItem();
            this.m_jMenuTools.add(jMenuItemGroovyConsole);
            jMenuItemGroovyConsole.setText("Groovy console");
            jMenuItemGroovyConsole.setAccelerator(KeyStroke.getKeyStroke(71, 2));
            jMenuItemGroovyConsole.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (GUIChooser.this.m_BayesNetGUIFrame == null) {
                        jMenuItemGroovyConsole.setEnabled(false);
                        GroovyPanel groovyPanel = new GroovyPanel();
                        GUIChooser.this.m_GroovyConsoleFrame = new JFrame(groovyPanel.getPlainTitle());
                        GUIChooser.this.m_GroovyConsoleFrame.setIconImage(GUIChooser.this.m_Icon);
                        GUIChooser.this.m_GroovyConsoleFrame.setDefaultCloseOperation(2);
                        GUIChooser.this.m_GroovyConsoleFrame.setJMenuBar(groovyPanel.getMenuBar());
                        GUIChooser.this.m_GroovyConsoleFrame.getContentPane().add((Component)groovyPanel, "Center");
                        GUIChooser.this.m_GroovyConsoleFrame.addWindowListener(new WindowAdapter(){

                            public void windowClosed(WindowEvent w) {
                                GUIChooser.this.m_GroovyConsoleFrame = null;
                                jMenuItemGroovyConsole.setEnabled(true);
                                GUIChooser.this.checkExit();
                            }
                        });
                        GUIChooser.this.m_GroovyConsoleFrame.setSize(800, 600);
                        GUIChooser.this.m_GroovyConsoleFrame.setVisible(true);
                    }
                }
            });
        }
        if (Jython.isPresent()) {
            final JMenuItem jMenuItemJythonConsole = new JMenuItem();
            this.m_jMenuTools.add(jMenuItemJythonConsole);
            jMenuItemJythonConsole.setText("Jython console");
            jMenuItemJythonConsole.setAccelerator(KeyStroke.getKeyStroke(74, 2));
            jMenuItemJythonConsole.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (GUIChooser.this.m_BayesNetGUIFrame == null) {
                        jMenuItemJythonConsole.setEnabled(false);
                        JythonPanel jythonPanel = new JythonPanel();
                        GUIChooser.this.m_JythonConsoleFrame = new JFrame(jythonPanel.getPlainTitle());
                        GUIChooser.this.m_JythonConsoleFrame.setIconImage(GUIChooser.this.m_Icon);
                        GUIChooser.this.m_JythonConsoleFrame.setDefaultCloseOperation(2);
                        GUIChooser.this.m_JythonConsoleFrame.setJMenuBar(jythonPanel.getMenuBar());
                        GUIChooser.this.m_JythonConsoleFrame.getContentPane().add((Component)jythonPanel, "Center");
                        GUIChooser.this.m_JythonConsoleFrame.addWindowListener(new WindowAdapter(){

                            public void windowClosed(WindowEvent w) {
                                GUIChooser.this.m_JythonConsoleFrame = null;
                                jMenuItemJythonConsole.setEnabled(true);
                                GUIChooser.this.checkExit();
                            }
                        });
                        GUIChooser.this.m_JythonConsoleFrame.setSize(800, 600);
                        GUIChooser.this.m_JythonConsoleFrame.setVisible(true);
                    }
                }
            });
        }
        this.m_jMenuHelp = new JMenu();
        this.m_jMenuBar.add(this.m_jMenuHelp);
        this.m_jMenuHelp.setText("Help");
        this.m_jMenuHelp.setMnemonic('H');
        JMenuItem jMenuItemHelpHomepage = new JMenuItem();
        this.m_jMenuHelp.add(jMenuItemHelpHomepage);
        jMenuItemHelpHomepage.setText("Weka homepage");
        jMenuItemHelpHomepage.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        jMenuItemHelpHomepage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrowserHelper.openURL("http://www.cs.waikato.ac.nz/~ml/weka/");
            }
        });
        this.m_jMenuHelp.add(new JSeparator());
        JMenuItem jMenuItemHelpWekaWiki = new JMenuItem();
        this.m_jMenuHelp.add(jMenuItemHelpWekaWiki);
        jMenuItemHelpWekaWiki.setText("HOWTOs, code snippets, etc.");
        jMenuItemHelpWekaWiki.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        jMenuItemHelpWekaWiki.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrowserHelper.openURL("http://weka.wikispaces.com/");
            }
        });
        JMenuItem jMenuItemHelpSourceforge = new JMenuItem();
        this.m_jMenuHelp.add(jMenuItemHelpSourceforge);
        jMenuItemHelpSourceforge.setText("Weka on Sourceforge");
        jMenuItemHelpSourceforge.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        jMenuItemHelpSourceforge.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrowserHelper.openURL("http://sourceforge.net/projects/weka/");
            }
        });
        final JMenuItem jMenuItemHelpSysInfo = new JMenuItem();
        this.m_jMenuHelp.add(jMenuItemHelpSysInfo);
        jMenuItemHelpSysInfo.setText("SystemInfo");
        jMenuItemHelpSysInfo.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        jMenuItemHelpSysInfo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GUIChooser.this.m_SystemInfoFrame == null) {
                    jMenuItemHelpSysInfo.setEnabled(false);
                    GUIChooser.this.m_SystemInfoFrame = new JFrame("SystemInfo");
                    GUIChooser.this.m_SystemInfoFrame.setIconImage(GUIChooser.this.m_Icon);
                    GUIChooser.this.m_SystemInfoFrame.getContentPane().setLayout(new BorderLayout());
                    Hashtable info = new SystemInfo().getSystemInfo();
                    Vector names = new Vector();
                    Enumeration enm = info.keys();
                    while (enm.hasMoreElements()) {
                        names.add(enm.nextElement());
                    }
                    Collections.sort(names);
                    Object[][] data = new String[info.size()][2];
                    for (int i = 0; i < names.size(); ++i) {
                        data[i][0] = names.get(i).toString();
                        data[i][1] = info.get(data[i][0]).toString();
                    }
                    Object[] titles = new String[]{"Key", "Value"};
                    JTable table = new JTable(data, titles);
                    GUIChooser.this.m_SystemInfoFrame.getContentPane().add((Component)new JScrollPane(table), "Center");
                    GUIChooser.this.m_SystemInfoFrame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent w) {
                            GUIChooser.this.m_SystemInfoFrame.dispose();
                            GUIChooser.this.m_SystemInfoFrame = null;
                            jMenuItemHelpSysInfo.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_SystemInfoFrame.pack();
                    GUIChooser.this.m_SystemInfoFrame.setSize(800, 600);
                    GUIChooser.this.m_SystemInfoFrame.setVisible(true);
                }
            }
        });
        this.m_ExplorerBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GUIChooser.this.m_ExplorerFrame == null) {
                    GUIChooser.this.m_ExplorerBut.setEnabled(false);
                    GUIChooser.this.m_ExplorerFrame = new JFrame("Weka Explorer");
                    GUIChooser.this.m_ExplorerFrame.setIconImage(GUIChooser.this.m_Icon);
                    GUIChooser.this.m_ExplorerFrame.getContentPane().setLayout(new BorderLayout());
                    GUIChooser.this.m_ExplorerFrame.getContentPane().add((Component)new Explorer(), "Center");
                    GUIChooser.this.m_ExplorerFrame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent w) {
                            GUIChooser.this.m_ExplorerFrame.dispose();
                            GUIChooser.this.m_ExplorerFrame = null;
                            GUIChooser.this.m_ExplorerBut.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_ExplorerFrame.pack();
                    GUIChooser.this.m_ExplorerFrame.setSize(800, 600);
                    GUIChooser.this.m_ExplorerFrame.setVisible(true);
                }
            }
        });
        this.m_ExperimenterBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GUIChooser.this.m_ExperimenterFrame == null) {
                    GUIChooser.this.m_ExperimenterBut.setEnabled(false);
                    GUIChooser.this.m_ExperimenterFrame = new JFrame("Weka Experiment Environment");
                    GUIChooser.this.m_ExperimenterFrame.setIconImage(GUIChooser.this.m_Icon);
                    GUIChooser.this.m_ExperimenterFrame.getContentPane().setLayout(new BorderLayout());
                    GUIChooser.this.m_ExperimenterFrame.getContentPane().add((Component)new Experimenter(false), "Center");
                    GUIChooser.this.m_ExperimenterFrame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent w) {
                            GUIChooser.this.m_ExperimenterFrame.dispose();
                            GUIChooser.this.m_ExperimenterFrame = null;
                            GUIChooser.this.m_ExperimenterBut.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_ExperimenterFrame.pack();
                    GUIChooser.this.m_ExperimenterFrame.setSize(800, 600);
                    GUIChooser.this.m_ExperimenterFrame.setVisible(true);
                }
            }
        });
        KnowledgeFlowApp.addStartupListener(new StartUpListener(){

            public void startUpComplete() {
                if (GUIChooser.this.m_KnowledgeFlowFrame == null) {
                    final KnowledgeFlowApp kna = KnowledgeFlowApp.getSingleton();
                    GUIChooser.this.m_KnowledgeFlowBut.setEnabled(false);
                    GUIChooser.this.m_KnowledgeFlowFrame = new JFrame("Weka KnowledgeFlow Environment");
                    GUIChooser.this.m_KnowledgeFlowFrame.setIconImage(GUIChooser.this.m_Icon);
                    GUIChooser.this.m_KnowledgeFlowFrame.getContentPane().setLayout(new BorderLayout());
                    GUIChooser.this.m_KnowledgeFlowFrame.getContentPane().add((Component)kna, "Center");
                    GUIChooser.this.m_KnowledgeFlowFrame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent w) {
                            kna.clearLayout();
                            GUIChooser.this.m_KnowledgeFlowFrame.dispose();
                            GUIChooser.this.m_KnowledgeFlowFrame = null;
                            GUIChooser.this.m_KnowledgeFlowBut.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_KnowledgeFlowFrame.pack();
                    GUIChooser.this.m_KnowledgeFlowFrame.setSize(1000, 750);
                    GUIChooser.this.m_KnowledgeFlowFrame.setVisible(true);
                }
            }
        });
        this.m_KnowledgeFlowBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                KnowledgeFlow.startApp();
            }
        });
        this.m_SimpleBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GUIChooser.this.m_SimpleCLI == null) {
                    GUIChooser.this.m_SimpleBut.setEnabled(false);
                    try {
                        GUIChooser.this.m_SimpleCLI = new SimpleCLI();
                        GUIChooser.this.m_SimpleCLI.setIconImage(GUIChooser.this.m_Icon);
                    }
                    catch (Exception ex) {
                        throw new Error("Couldn't start SimpleCLI!");
                    }
                    GUIChooser.this.m_SimpleCLI.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent w) {
                            GUIChooser.this.m_SimpleCLI.dispose();
                            GUIChooser.this.m_SimpleCLI = null;
                            GUIChooser.this.m_SimpleBut.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_SimpleCLI.setVisible(true);
                }
            }
        });
        this.setJMenuBar(this.m_jMenuBar);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent w) {
                GUIChooser.this.dispose();
                GUIChooser.this.checkExit();
            }
        });
        this.pack();
    }

    protected void insertMenuItem(JMenu menu, JMenuItem menuitem) {
        this.insertMenuItem(menu, menuitem, 0);
    }

    protected void insertMenuItem(JMenu menu, JMenuItem menuitem, int startIndex) {
        boolean inserted = false;
        String newStr = menuitem.getText().toLowerCase();
        for (int i = startIndex; i < menu.getMenuComponentCount(); ++i) {
            JMenuItem current;
            String currentStr;
            if (!(menu.getMenuComponent(i) instanceof JMenuItem) || (currentStr = (current = (JMenuItem)menu.getMenuComponent(i)).getText().toLowerCase()).compareTo(newStr) <= 0) continue;
            inserted = true;
            menu.insert(menuitem, i);
            break;
        }
        if (!inserted) {
            menu.add(menuitem);
        }
    }

    protected Container createFrame(GUIChooser parent, String title, Component c, LayoutManager layout, Object layoutConstraints, int width, int height, JMenuBar menu, boolean listener, boolean visible) {
        ChildFrameSDI result = null;
        final ChildFrameSDI frame = new ChildFrameSDI(parent, title);
        frame.setLayout(layout);
        if (c != null) {
            frame.getContentPane().add(c, layoutConstraints);
        }
        frame.setJMenuBar(menu);
        frame.pack();
        if (width > -1 && height > -1) {
            frame.setSize(width, height);
        }
        frame.validate();
        int screenHeight = this.getGraphicsConfiguration().getBounds().height;
        int screenWidth = this.getGraphicsConfiguration().getBounds().width;
        frame.setLocation((screenWidth - frame.getBounds().width) / 2, (screenHeight - frame.getBounds().height) / 2);
        if (listener) {
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    frame.dispose();
                }
            });
        }
        if (visible) {
            frame.setVisible(true);
        }
        result = frame;
        return result;
    }

    protected void createTitle(String title) {
        String newTitle = "Weka " + new Version();
        if (title.length() != 0) {
            newTitle = newTitle + " - " + title;
        }
        this.setTitle(newTitle);
    }

    public void addChildFrame(Container c) {
        this.m_ChildFrames.add(c);
    }

    public boolean removeChildFrame(Container c) {
        boolean result = this.m_ChildFrames.remove(c);
        return result;
    }

    private void checkExit() {
        if (!this.isVisible() && this.m_ExplorerFrame == null && this.m_ExperimenterFrame == null && this.m_KnowledgeFlowFrame == null && this.m_SimpleCLI == null && this.m_ArffViewers.size() == 0 && this.m_SqlViewerFrame == null && this.m_GroovyConsoleFrame == null && this.m_JythonConsoleFrame == null && this.m_EnsembleLibraryFrame == null && this.m_Plots.size() == 0 && this.m_ROCs.size() == 0 && this.m_TreeVisualizers.size() == 0 && this.m_GraphVisualizers.size() == 0 && this.m_BoundaryVisualizerFrame == null && this.m_SystemInfoFrame == null) {
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        Logger.log(Logger.Level.INFO, "Logging started");
        LookAndFeel.setLookAndFeel();
        try {
            m_chooser = new GUIChooser();
            m_chooser.setVisible(true);
            Thread memMonitor = new Thread(){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                26.sleep(4000L);
                                System.gc();
                                if (!m_Memory.isOutOfMemory()) continue;
                                m_chooser.dispose();
                                if (m_chooser.m_ExperimenterFrame != null) {
                                    m_chooser.m_ExperimenterFrame.dispose();
                                    m_chooser.m_ExperimenterFrame = null;
                                }
                                if (m_chooser.m_ExplorerFrame != null) {
                                    m_chooser.m_ExplorerFrame.dispose();
                                    m_chooser.m_ExplorerFrame = null;
                                }
                                if (m_chooser.m_KnowledgeFlowFrame != null) {
                                    m_chooser.m_KnowledgeFlowFrame.dispose();
                                    m_chooser.m_KnowledgeFlowFrame = null;
                                }
                                if (m_chooser.m_SimpleCLI != null) {
                                    m_chooser.m_SimpleCLI.dispose();
                                    m_chooser.m_SimpleCLI = null;
                                }
                                if (m_chooser.m_ArffViewers.size() > 0) {
                                    for (int i = 0; i < m_chooser.m_ArffViewers.size(); ++i) {
                                        ArffViewer av = (ArffViewer)m_chooser.m_ArffViewers.get(i);
                                        av.dispose();
                                    }
                                    m_chooser.m_ArffViewers.clear();
                                }
                                m_chooser = null;
                                System.gc();
                                m_Memory.stopThreads();
                                m_chooser;
                                m_LogWindow.setVisible(true);
                                m_chooser;
                                m_LogWindow.toFront();
                                System.err.println("\ndisplayed message:");
                                m_Memory.showOutOfMemory();
                                System.err.println("\nexiting...");
                                System.exit(-1);
                            }
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            };
            memMonitor.setPriority(5);
            memMonitor.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    static {
        m_Memory = new Memory(true);
    }

    public static class ChildFrameSDI
    extends JFrame {
        private static final long serialVersionUID = 8588293938686425618L;
        protected GUIChooser m_Parent;

        public ChildFrameSDI(GUIChooser parent, String title) {
            super(title);
            this.m_Parent = parent;
            this.addWindowListener(new WindowAdapter(){

                public void windowActivated(WindowEvent e) {
                    if (ChildFrameSDI.this.getParentFrame() != null) {
                        ChildFrameSDI.this.getParentFrame().createTitle(ChildFrameSDI.this.getTitle());
                    }
                }
            });
            if (this.getParentFrame() != null) {
                this.getParentFrame().addChildFrame(this);
                this.setIconImage(this.getParentFrame().getIconImage());
            }
        }

        public GUIChooser getParentFrame() {
            return this.m_Parent;
        }

        public void dispose() {
            if (this.getParentFrame() != null) {
                this.getParentFrame().removeChildFrame(this);
                this.getParentFrame().createTitle("");
            }
            super.dispose();
        }
    }
}

