/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.Enumeration;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SparseInstance;
import weka.core.Utils;

public class BinarySparseInstance
extends SparseInstance {
    private static final long serialVersionUID = -5297388762342528737L;

    public BinarySparseInstance(Instance instance) {
        this.m_Weight = instance.m_Weight;
        this.m_Dataset = null;
        this.m_NumAttributes = instance.numAttributes();
        if (instance instanceof SparseInstance) {
            this.m_AttValues = null;
            this.m_Indices = ((SparseInstance)instance).m_Indices;
        } else {
            int[] nArray = new int[instance.numAttributes()];
            int n = 0;
            for (int i = 0; i < instance.numAttributes(); ++i) {
                if (instance.value(i) == 0.0) continue;
                nArray[n] = i;
                ++n;
            }
            this.m_AttValues = null;
            this.m_Indices = new int[n];
            System.arraycopy(nArray, 0, this.m_Indices, 0, n);
        }
    }

    public BinarySparseInstance(SparseInstance sparseInstance) {
        this.m_AttValues = null;
        this.m_Indices = sparseInstance.m_Indices;
        this.m_Weight = sparseInstance.m_Weight;
        this.m_NumAttributes = sparseInstance.m_NumAttributes;
        this.m_Dataset = null;
    }

    public BinarySparseInstance(double d, double[] dArray) {
        this.m_Weight = d;
        this.m_Dataset = null;
        this.m_NumAttributes = dArray.length;
        int[] nArray = new int[this.m_NumAttributes];
        int n = 0;
        for (int i = 0; i < this.m_NumAttributes; ++i) {
            if (dArray[i] == 0.0) continue;
            nArray[n] = i;
            ++n;
        }
        this.m_AttValues = null;
        this.m_Indices = new int[n];
        System.arraycopy(nArray, 0, this.m_Indices, 0, n);
    }

    public BinarySparseInstance(double d, int[] nArray, int n) {
        this.m_AttValues = null;
        this.m_Indices = nArray;
        this.m_Weight = d;
        this.m_NumAttributes = n;
        this.m_Dataset = null;
    }

    public BinarySparseInstance(int n) {
        this.m_AttValues = null;
        this.m_NumAttributes = n;
        this.m_Indices = new int[n];
        for (int i = 0; i < this.m_Indices.length; ++i) {
            this.m_Indices[i] = i;
        }
        this.m_Weight = 1.0;
        this.m_Dataset = null;
    }

    public Object copy() {
        return new BinarySparseInstance(this);
    }

    public Instance mergeInstance(Instance instance) {
        int n;
        int[] nArray = new int[this.numValues() + instance.numValues()];
        int n2 = 0;
        for (n = 0; n < this.numValues(); ++n) {
            nArray[n2++] = this.index(n);
        }
        for (n = 0; n < instance.numValues(); ++n) {
            if (instance.valueSparse(n) == 0.0) continue;
            nArray[n2++] = this.numAttributes() + instance.index(n);
        }
        if (n2 != nArray.length) {
            int[] nArray2 = new int[n2];
            System.arraycopy(nArray, 0, nArray2, 0, n2);
            nArray = nArray2;
        }
        return new BinarySparseInstance(1.0, nArray, this.numAttributes() + instance.numAttributes());
    }

    public void replaceMissingValues(double[] dArray) {
    }

    public void setValue(int n, double d) {
        int n2 = this.locateIndex(n);
        if (n2 >= 0 && this.m_Indices[n2] == n) {
            if (d == 0.0) {
                int[] nArray = new int[this.m_Indices.length - 1];
                System.arraycopy(this.m_Indices, 0, nArray, 0, n2);
                System.arraycopy(this.m_Indices, n2 + 1, nArray, n2, this.m_Indices.length - n2 - 1);
                this.m_Indices = nArray;
            }
        } else if (d != 0.0) {
            int[] nArray = new int[this.m_Indices.length + 1];
            System.arraycopy(this.m_Indices, 0, nArray, 0, n2 + 1);
            nArray[n2 + 1] = n;
            System.arraycopy(this.m_Indices, n2 + 1, nArray, n2 + 2, this.m_Indices.length - n2 - 1);
            this.m_Indices = nArray;
        }
    }

    public void setValueSparse(int n, double d) {
        if (d == 0.0) {
            int[] nArray = new int[this.m_Indices.length - 1];
            System.arraycopy(this.m_Indices, 0, nArray, 0, n);
            System.arraycopy(this.m_Indices, n + 1, nArray, n, this.m_Indices.length - n - 1);
            this.m_Indices = nArray;
        }
    }

    public double[] toDoubleArray() {
        double[] dArray = new double[this.m_NumAttributes];
        for (int i = 0; i < this.m_Indices.length; ++i) {
            dArray[this.m_Indices[i]] = 1.0;
        }
        return dArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        for (int i = 0; i < this.m_Indices.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            if (this.m_Dataset == null) {
                stringBuffer.append(this.m_Indices[i] + " 1");
                continue;
            }
            if (this.m_Dataset.attribute(this.m_Indices[i]).isNominal() || this.m_Dataset.attribute(this.m_Indices[i]).isString()) {
                stringBuffer.append(this.m_Indices[i] + " " + Utils.quote(this.m_Dataset.attribute(this.m_Indices[i]).value(1)));
                continue;
            }
            stringBuffer.append(this.m_Indices[i] + " 1");
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public double value(int n) {
        int n2 = this.locateIndex(n);
        if (n2 >= 0 && this.m_Indices[n2] == n) {
            return 1.0;
        }
        return 0.0;
    }

    public final double valueSparse(int n) {
        int n2 = this.m_Indices[n];
        return 1.0;
    }

    void forceDeleteAttributeAt(int n) {
        int n2 = this.locateIndex(n);
        --this.m_NumAttributes;
        if (n2 >= 0 && this.m_Indices[n2] == n) {
            int[] nArray = new int[this.m_Indices.length - 1];
            System.arraycopy(this.m_Indices, 0, nArray, 0, n2);
            for (int i = n2; i < this.m_Indices.length - 1; ++i) {
                nArray[i] = this.m_Indices[i + 1] - 1;
            }
            this.m_Indices = nArray;
        } else {
            int[] nArray = new int[this.m_Indices.length];
            System.arraycopy(this.m_Indices, 0, nArray, 0, n2 + 1);
            for (int i = n2 + 1; i < this.m_Indices.length - 1; ++i) {
                nArray[i] = this.m_Indices[i] - 1;
            }
            this.m_Indices = nArray;
        }
    }

    void forceInsertAttributeAt(int n) {
        int n2 = this.locateIndex(n);
        ++this.m_NumAttributes;
        if (n2 >= 0 && this.m_Indices[n2] == n) {
            int[] nArray = new int[this.m_Indices.length + 1];
            System.arraycopy(this.m_Indices, 0, nArray, 0, n2);
            nArray[n2] = n;
            for (int i = n2; i < this.m_Indices.length; ++i) {
                nArray[i + 1] = this.m_Indices[i] + 1;
            }
            this.m_Indices = nArray;
        } else {
            int[] nArray = new int[this.m_Indices.length + 1];
            System.arraycopy(this.m_Indices, 0, nArray, 0, n2 + 1);
            nArray[n2 + 1] = n;
            for (int i = n2 + 1; i < this.m_Indices.length; ++i) {
                nArray[i + 1] = this.m_Indices[i] + 1;
            }
            this.m_Indices = nArray;
        }
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            int n;
            Attribute attribute = new Attribute("length");
            Attribute attribute2 = new Attribute("weight");
            FastVector fastVector = new FastVector(3);
            fastVector.addElement("first");
            fastVector.addElement("second");
            Attribute attribute3 = new Attribute("position", fastVector);
            FastVector fastVector2 = new FastVector(3);
            fastVector2.addElement(attribute);
            fastVector2.addElement(attribute2);
            fastVector2.addElement(attribute3);
            Instances instances = new Instances("race", fastVector2, 0);
            instances.setClassIndex(attribute3.index());
            BinarySparseInstance binarySparseInstance = new BinarySparseInstance(3);
            binarySparseInstance.setValue(attribute, 5.3);
            binarySparseInstance.setValue(attribute2, 300.0);
            binarySparseInstance.setValue(attribute3, "first");
            binarySparseInstance.setDataset(instances);
            System.out.println("The instance: " + binarySparseInstance);
            System.out.println("First attribute: " + binarySparseInstance.attribute(0));
            System.out.println("Class attribute: " + binarySparseInstance.classAttribute());
            System.out.println("Class index: " + binarySparseInstance.classIndex());
            System.out.println("Class is missing: " + binarySparseInstance.classIsMissing());
            System.out.println("Class value (internal format): " + binarySparseInstance.classValue());
            SparseInstance sparseInstance = (SparseInstance)binarySparseInstance.copy();
            System.out.println("Shallow copy: " + sparseInstance);
            sparseInstance.setDataset(binarySparseInstance.dataset());
            System.out.println("Shallow copy with dataset set: " + sparseInstance);
            System.out.print("All stored values in internal format: ");
            for (n = 0; n < binarySparseInstance.numValues(); ++n) {
                if (n > 0) {
                    System.out.print(",");
                }
                System.out.print(binarySparseInstance.valueSparse(n));
            }
            System.out.println();
            System.out.print("All values set to zero: ");
            while (binarySparseInstance.numValues() > 0) {
                binarySparseInstance.setValueSparse(0, 0.0);
            }
            for (n = 0; n < binarySparseInstance.numValues(); ++n) {
                if (n > 0) {
                    System.out.print(",");
                }
                System.out.print(binarySparseInstance.valueSparse(n));
            }
            System.out.println();
            System.out.print("All values set to one: ");
            for (n = 0; n < binarySparseInstance.numAttributes(); ++n) {
                binarySparseInstance.setValue(n, 1.0);
            }
            for (n = 0; n < binarySparseInstance.numValues(); ++n) {
                if (n > 0) {
                    System.out.print(",");
                }
                System.out.print(binarySparseInstance.valueSparse(n));
            }
            System.out.println();
            sparseInstance.setDataset(null);
            sparseInstance.deleteAttributeAt(0);
            sparseInstance.insertAttributeAt(0);
            sparseInstance.setDataset(binarySparseInstance.dataset());
            System.out.println("Copy with first attribute deleted and inserted: " + sparseInstance);
            sparseInstance.setDataset(null);
            sparseInstance.deleteAttributeAt(1);
            sparseInstance.insertAttributeAt(1);
            sparseInstance.setDataset(binarySparseInstance.dataset());
            System.out.println("Copy with second attribute deleted and inserted: " + sparseInstance);
            sparseInstance.setDataset(null);
            sparseInstance.deleteAttributeAt(2);
            sparseInstance.insertAttributeAt(2);
            sparseInstance.setDataset(binarySparseInstance.dataset());
            System.out.println("Copy with third attribute deleted and inserted: " + sparseInstance);
            System.out.println("Enumerating attributes (leaving out class):");
            Enumeration enumeration = binarySparseInstance.enumerateAttributes();
            while (enumeration.hasMoreElements()) {
                object = (Attribute)enumeration.nextElement();
                System.out.println(object);
            }
            System.out.println("Header of original and copy equivalent: " + binarySparseInstance.equalHeaders(sparseInstance));
            System.out.println("Length of copy missing: " + sparseInstance.isMissing(attribute));
            System.out.println("Weight of copy missing: " + sparseInstance.isMissing(attribute2.index()));
            System.out.println("Length of copy missing: " + Instance.isMissingValue(sparseInstance.value(attribute)));
            System.out.println("Missing value coded as: " + Instance.missingValue());
            System.out.println("Number of attributes: " + sparseInstance.numAttributes());
            System.out.println("Number of classes: " + sparseInstance.numClasses());
            object = new double[]{2.0, 3.0, 0.0};
            sparseInstance.replaceMissingValues((double[])object);
            System.out.println("Copy with missing value replaced: " + sparseInstance);
            sparseInstance.setClassMissing();
            System.out.println("Copy with missing class: " + sparseInstance);
            sparseInstance.setClassValue(0.0);
            System.out.println("Copy with class value set to first value: " + sparseInstance);
            sparseInstance.setClassValue("second");
            System.out.println("Copy with class value set to \"second\": " + sparseInstance);
            sparseInstance.setMissing(1);
            System.out.println("Copy with second attribute set to be missing: " + sparseInstance);
            sparseInstance.setMissing(attribute);
            System.out.println("Copy with length set to be missing: " + sparseInstance);
            sparseInstance.setValue(0, 0.0);
            System.out.println("Copy with first attribute set to 0: " + sparseInstance);
            sparseInstance.setValue(attribute2, 1.0);
            System.out.println("Copy with weight attribute set to 1: " + sparseInstance);
            sparseInstance.setValue(attribute3, "second");
            System.out.println("Copy with position set to \"second\": " + sparseInstance);
            sparseInstance.setValue(2, "first");
            System.out.println("Copy with last attribute set to \"first\": " + sparseInstance);
            System.out.println("Current weight of instance copy: " + sparseInstance.weight());
            sparseInstance.setWeight(2.0);
            System.out.println("Current weight of instance copy (set to 2): " + sparseInstance.weight());
            System.out.println("Last value of copy: " + sparseInstance.toString(2));
            System.out.println("Value of position for copy: " + sparseInstance.toString(attribute3));
            System.out.println("Last value of copy (internal format): " + sparseInstance.value(2));
            System.out.println("Value of position for copy (internal format): " + sparseInstance.value(attribute3));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

