/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public class ListSelectorDialog
extends JDialog {
    protected JButton m_SelectBut = new JButton("Select");
    protected JButton m_CancelBut = new JButton("Cancel");
    protected JButton m_PatternBut = new JButton("Pattern");
    protected JList m_List;
    protected int m_Result;
    public static final int APPROVE_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    protected String m_PatternRegEx = ".*";

    public ListSelectorDialog(Frame frame, JList jList) {
        super(frame, "Select items", true);
        this.m_List = jList;
        this.m_CancelBut.setMnemonic('C');
        this.m_CancelBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListSelectorDialog.this.m_Result = 1;
                ListSelectorDialog.this.setVisible(false);
            }
        });
        this.m_SelectBut.setMnemonic('S');
        this.m_SelectBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListSelectorDialog.this.m_Result = 0;
                ListSelectorDialog.this.setVisible(false);
            }
        });
        this.m_PatternBut.setMnemonic('P');
        this.m_PatternBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListSelectorDialog.this.selectPattern();
            }
        });
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        Box box = new Box(0);
        box.add(this.m_SelectBut);
        box.add(Box.createHorizontalStrut(10));
        box.add(this.m_PatternBut);
        box.add(Box.createHorizontalStrut(10));
        box.add(this.m_CancelBut);
        container.add((Component)box, "South");
        container.add((Component)new JScrollPane(this.m_List), "Center");
        this.getRootPane().setDefaultButton(this.m_SelectBut);
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (double)this.getWidth() > dimension.getWidth() ? (int)dimension.getWidth() : this.getWidth();
        int n2 = (double)this.getHeight() > dimension.getHeight() ? (int)dimension.getHeight() : this.getHeight();
        this.setSize(n, n2);
    }

    public int showDialog() {
        this.m_Result = 1;
        int[] nArray = this.m_List.getSelectedIndices();
        this.setVisible(true);
        if (this.m_Result == 1) {
            this.m_List.setSelectedIndices(nArray);
        }
        return this.m_Result;
    }

    protected void selectPattern() {
        String string = JOptionPane.showInputDialog(this.m_PatternBut.getParent(), "Enter a Perl regular expression ('.*' for all)", this.m_PatternRegEx);
        if (string != null) {
            try {
                Pattern.compile(string);
                this.m_PatternRegEx = string;
                this.m_List.clearSelection();
                for (int i = 0; i < this.m_List.getModel().getSize(); ++i) {
                    if (!Pattern.matches(string, this.m_List.getModel().getElementAt(i).toString())) continue;
                    this.m_List.addSelectionInterval(i, i);
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.m_PatternBut.getParent(), "'" + string + "' is not a valid Perl regular expression!\n" + "Error: " + exception, "Error in Pattern...", 0);
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
            defaultListModel.addElement("one");
            defaultListModel.addElement("two");
            defaultListModel.addElement("three");
            defaultListModel.addElement("four");
            defaultListModel.addElement("five");
            JList jList = new JList(defaultListModel);
            ListSelectorDialog listSelectorDialog = new ListSelectorDialog(null, jList);
            int n = listSelectorDialog.showDialog();
            if (n == 0) {
                System.err.println("Fields Selected");
                int[] nArray = jList.getSelectedIndices();
                for (int i = 0; i < nArray.length; ++i) {
                    System.err.println("" + nArray[i] + " " + defaultListModel.elementAt(nArray[i]));
                }
            } else {
                System.err.println("Cancelled");
            }
            System.exit(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

