/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.BatchConverter;
import weka.core.converters.URLSourcedLoader;
import weka.core.xml.XMLInstances;

public class XRFFLoader
extends AbstractFileLoader
implements BatchConverter,
URLSourcedLoader {
    private static final long serialVersionUID = 3764533621135196582L;
    public static String FILE_EXTENSION = XMLInstances.FILE_EXTENSION;
    public static String FILE_EXTENSION_COMPRESSED = FILE_EXTENSION + ".gz";
    protected String m_URL = "http://";
    protected transient Reader m_sourceReader = null;
    protected XMLInstances m_XMLInstances;

    public String globalInfo() {
        return "Reads a source that is in the XML version of the ARFF format. It automatically decompresses the data if the extension is '" + FILE_EXTENSION_COMPRESSED + "'.";
    }

    public String getFileExtension() {
        return FILE_EXTENSION;
    }

    public String[] getFileExtensions() {
        return new String[]{FILE_EXTENSION, FILE_EXTENSION_COMPRESSED};
    }

    public String getFileDescription() {
        return "XRFF data files";
    }

    public void reset() throws IOException {
        this.m_structure = null;
        this.m_XMLInstances = null;
        this.setRetrieval(0);
        if (this.m_File != null) {
            this.setFile(new File(this.m_File));
        } else if (this.m_URL != null && !this.m_URL.equals("http://")) {
            this.setURL(this.m_URL);
        }
    }

    public void setSource(File file) throws IOException {
        this.m_structure = null;
        this.m_XMLInstances = null;
        this.setRetrieval(0);
        if (file == null) {
            throw new IOException("Source file object is null!");
        }
        try {
            if (file.getName().endsWith(FILE_EXTENSION_COMPRESSED)) {
                this.setSource(new GZIPInputStream(new FileInputStream(file)));
            } else {
                this.setSource(new FileInputStream(file));
            }
        }
        catch (FileNotFoundException ex) {
            throw new IOException("File not found");
        }
        this.m_sourceFile = file;
        this.m_File = file.getAbsolutePath();
    }

    public void setSource(URL url) throws IOException {
        this.m_structure = null;
        this.m_XMLInstances = null;
        this.setRetrieval(0);
        this.setSource(url.openStream());
        this.m_URL = url.toString();
    }

    public void setURL(String url) throws IOException {
        this.m_URL = url;
        this.setSource(new URL(url));
    }

    public String retrieveURL() {
        return this.m_URL;
    }

    public void setSource(InputStream in) throws IOException {
        this.m_File = new File(System.getProperty("user.dir")).getAbsolutePath();
        this.m_URL = "http://";
        this.m_sourceReader = new BufferedReader(new InputStreamReader(in));
    }

    public Instances getStructure() throws IOException {
        if (this.m_sourceReader == null) {
            throw new IOException("No source has been specified");
        }
        if (this.m_structure == null) {
            try {
                this.m_XMLInstances = new XMLInstances(this.m_sourceReader);
                this.m_structure = new Instances(this.m_XMLInstances.getInstances(), 0);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return new Instances(this.m_structure, 0);
    }

    public Instances getDataSet() throws IOException {
        if (this.m_sourceReader == null) {
            throw new IOException("No source has been specified");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Cannot mix getting Instances in both incremental and batch modes");
        }
        this.setRetrieval(1);
        if (this.m_structure == null) {
            this.getStructure();
        }
        try {
            this.m_sourceReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.m_XMLInstances.getInstances();
    }

    public Instance getNextInstance(Instances structure) throws IOException {
        throw new IOException("XRFFLoader can't read data sets incrementally.");
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 4985 $");
    }

    public static void main(String[] args) {
        XRFFLoader.runFileLoader(new XRFFLoader(), args);
    }
}

