/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.StringTokenizer;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Statistics;
import weka.core.Utils;
import weka.experiment.Stats;

public class PairedStats
implements RevisionHandler {
    public Stats xStats = new Stats();
    public Stats yStats = new Stats();
    public Stats differencesStats = new Stats();
    public double differencesProbability;
    public double correlation;
    public double xySum;
    public double count;
    public int differencesSignificance;
    public double sigLevel;
    protected int m_degreesOfFreedom = 0;

    public PairedStats(double d) {
        this.sigLevel = d;
    }

    public void setDegreesOfFreedom(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("PairedStats: degrees of freedom must be >= 1");
        }
        this.m_degreesOfFreedom = n;
    }

    public int getDegreesOfFreedom() {
        return this.m_degreesOfFreedom;
    }

    public void add(double d, double d2) {
        this.xStats.add(d);
        this.yStats.add(d2);
        this.differencesStats.add(d - d2);
        this.xySum += d * d2;
        this.count += 1.0;
    }

    public void subtract(double d, double d2) {
        this.xStats.subtract(d);
        this.yStats.subtract(d2);
        this.differencesStats.subtract(d - d2);
        this.xySum -= d * d2;
        this.count -= 1.0;
    }

    public void add(double[] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null) {
            throw new NullPointerException();
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Arrays must be of the same length");
        }
        for (int i = 0; i < dArray.length; ++i) {
            this.add(dArray[i], dArray2[i]);
        }
    }

    public void subtract(double[] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null) {
            throw new NullPointerException();
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Arrays must be of the same length");
        }
        for (int i = 0; i < dArray.length; ++i) {
            this.subtract(dArray[i], dArray2[i]);
        }
    }

    public void calculateDerived() {
        double d;
        this.xStats.calculateDerived();
        this.yStats.calculateDerived();
        this.differencesStats.calculateDerived();
        this.correlation = Double.NaN;
        if (!(Double.isNaN(this.xStats.stdDev) || Double.isNaN(this.yStats.stdDev) || Utils.eq(this.xStats.stdDev, 0.0))) {
            d = (this.xySum - this.xStats.sum * this.yStats.sum / this.count) / (this.xStats.sumSq - this.xStats.sum * this.xStats.mean);
            this.correlation = !Utils.eq(this.yStats.stdDev, 0.0) ? d * this.xStats.stdDev / this.yStats.stdDev : 1.0;
        }
        if (Utils.gr(this.differencesStats.stdDev, 0.0)) {
            d = this.differencesStats.mean * Math.sqrt(this.count) / this.differencesStats.stdDev;
            this.differencesProbability = this.m_degreesOfFreedom >= 1 ? Statistics.FProbability(d * d, 1, this.m_degreesOfFreedom) : (this.count > 1.0 ? Statistics.FProbability(d * d, 1, (int)this.count - 1) : 1.0);
        } else {
            this.differencesProbability = this.differencesStats.sumSq == 0.0 ? 1.0 : 0.0;
        }
        this.differencesSignificance = 0;
        if (this.differencesProbability <= this.sigLevel) {
            this.differencesSignificance = this.xStats.mean > this.yStats.mean ? 1 : -1;
        }
    }

    public String toString() {
        return "Analysis for " + Utils.doubleToString(this.count, 0) + " points:\n" + "                " + "         Column 1" + "         Column 2" + "       Difference\n" + "Minimums        " + Utils.doubleToString(this.xStats.min, 17, 4) + Utils.doubleToString(this.yStats.min, 17, 4) + Utils.doubleToString(this.differencesStats.min, 17, 4) + '\n' + "Maximums        " + Utils.doubleToString(this.xStats.max, 17, 4) + Utils.doubleToString(this.yStats.max, 17, 4) + Utils.doubleToString(this.differencesStats.max, 17, 4) + '\n' + "Sums            " + Utils.doubleToString(this.xStats.sum, 17, 4) + Utils.doubleToString(this.yStats.sum, 17, 4) + Utils.doubleToString(this.differencesStats.sum, 17, 4) + '\n' + "SumSquares      " + Utils.doubleToString(this.xStats.sumSq, 17, 4) + Utils.doubleToString(this.yStats.sumSq, 17, 4) + Utils.doubleToString(this.differencesStats.sumSq, 17, 4) + '\n' + "Means           " + Utils.doubleToString(this.xStats.mean, 17, 4) + Utils.doubleToString(this.yStats.mean, 17, 4) + Utils.doubleToString(this.differencesStats.mean, 17, 4) + '\n' + "SDs             " + Utils.doubleToString(this.xStats.stdDev, 17, 4) + Utils.doubleToString(this.yStats.stdDev, 17, 4) + Utils.doubleToString(this.differencesStats.stdDev, 17, 4) + '\n' + "Prob(differences) " + Utils.doubleToString(this.differencesProbability, 4) + " (sigflag " + this.differencesSignificance + ")\n" + "Correlation       " + Utils.doubleToString(this.correlation, 4) + "\n";
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.10 $");
    }

    public static void main(String[] stringArray) {
        try {
            String string;
            PairedStats pairedStats = new PairedStats(0.05);
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(System.in));
            while ((string = lineNumberReader.readLine()) != null) {
                if ((string = string.trim()).equals("") || string.startsWith("@") || string.startsWith("%")) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ,\t\n\r\f");
                int n = 0;
                double d = 0.0;
                double d2 = 0.0;
                while (stringTokenizer.hasMoreTokens()) {
                    double d3 = new Double(stringTokenizer.nextToken());
                    if (n == 0) {
                        d = d3;
                    } else if (n == 1) {
                        d2 = d3;
                    } else {
                        System.err.println("MSG: Too many values in line \"" + string + "\", skipped.");
                        break;
                    }
                    ++n;
                }
                if (n != 2) continue;
                pairedStats.add(d, d2);
            }
            pairedStats.calculateDerived();
            System.err.println(pairedStats);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

