/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Environment
implements RevisionHandler {
    private static Environment m_systemWide = new Environment();
    private Map<String, String> m_envVars = new TreeMap<String, String>();

    public Environment() {
        Object object;
        Map<String, String> map = System.getenv();
        Set<String> set = map.keySet();
        for (String object22 : set) {
            object = map.get(object22);
            this.m_envVars.put(object22, (String)object);
        }
        Properties properties = System.getProperties();
        object = properties.propertyNames();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            String string2 = properties.getProperty(string);
            this.m_envVars.put(string, string2);
        }
        this.m_envVars.put("weka.version", Version.VERSION);
    }

    public static Environment getSystemWide() {
        return m_systemWide;
    }

    public static boolean containsEnvVariables(String string) {
        return string.indexOf("${") >= 0;
    }

    public String substitute(String string) throws Exception {
        int n;
        int n2 = string.indexOf("${");
        while (n2 >= 0 && (n = string.indexOf(125)) >= 0 && n > (n2 += 2) + 1) {
            String string2 = string.substring(n2, n);
            String string3 = this.m_envVars.get(string2);
            if (string3 == null) {
                throw new Exception("[Environment] Variable " + string2 + " doesn't seem to be set.");
            }
            String string4 = "${" + string2 + "}";
            string = string.replace(string4, string3);
            n2 = string.indexOf("${");
        }
        return string;
    }

    public void addVariable(String string, String string2) {
        this.m_envVars.put(string, string2);
    }

    public void removeVariable(String string) {
        this.m_envVars.remove(string);
    }

    public Set<String> getVariableNames() {
        return this.m_envVars.keySet();
    }

    public String getVariableValue(String string) {
        return this.m_envVars.get(string);
    }

    public static void main(String[] stringArray) {
        Environment environment = new Environment();
        if (stringArray.length == 0) {
            System.err.println("Usage: java weka.core.Environment <string> <string> ...");
        } else {
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = environment.substitute(stringArray[i]);
                    System.out.println("Original string:\n" + stringArray[i] + "\n\nNew string:\n" + string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5562 $");
    }
}

