/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.util.Enumeration;
import java.util.Vector;
import weka.clusterers.SimpleKMeans;
import weka.clusterers.SingleClustererEnhancer;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.AllFilter;
import weka.filters.Filter;
import weka.filters.SupervisedFilter;

public class FilteredClusterer
extends SingleClustererEnhancer {
    private static final long serialVersionUID = 1420005943163412943L;
    protected Filter m_Filter;
    protected Instances m_FilteredInstances;

    public FilteredClusterer() {
        this.m_Clusterer = new SimpleKMeans();
        this.m_Filter = new AllFilter();
    }

    public String globalInfo() {
        return "Class for running an arbitrary clusterer on data that has been passed through an arbitrary filter. Like the clusterer, the structure of the filter is based exclusively on the training data and test instances will be processed by the filter without changing their structure.";
    }

    protected String defaultFilterString() {
        return AllFilter.class.getName();
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tFull class name of filter to use, followed\n\tby filter options.\n\teg: \"weka.filters.unsupervised.attribute.Remove -V -R 1,2\"\n(default: " + this.defaultFilterString() + ")", "F", 1, "-F <filter specification>"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('F', stringArray);
        if (string.length() > 0) {
            String[] stringArray2 = Utils.splitOptions(string);
            if (stringArray2.length == 0) {
                throw new IllegalArgumentException("Invalid filter specification string");
            }
            string = stringArray2[0];
            stringArray2[0] = "";
            this.setFilter((Filter)Utils.forName(Filter.class, string, stringArray2));
        } else {
            this.setFilter(new AllFilter());
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-F");
        vector.add(this.getFilterSpec());
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String filterTipText() {
        return "The filter to be used.";
    }

    public void setFilter(Filter filter) {
        this.m_Filter = filter;
        if (this.m_Filter instanceof SupervisedFilter) {
            System.out.println("WARNING: you are using a supervised filter, which will leak information about the class attribute!");
        }
    }

    public Filter getFilter() {
        return this.m_Filter;
    }

    protected String getFilterSpec() {
        Filter filter = this.getFilter();
        String string = filter.getClass().getName();
        if (filter instanceof OptionHandler) {
            string = string + " " + Utils.joinOptions(((OptionHandler)((Object)filter)).getOptions());
        }
        return string;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities;
        if (this.getFilter() == null) {
            capabilities = super.getCapabilities();
            capabilities.disableAll();
            capabilities.enable(Capabilities.Capability.NO_CLASS);
        } else {
            capabilities = this.getFilter().getCapabilities();
        }
        for (Capabilities.Capability capability : Capabilities.Capability.values()) {
            capabilities.enableDependency(capability);
        }
        return capabilities;
    }

    public void buildClusterer(Instances instances) throws Exception {
        if (this.m_Clusterer == null) {
            throw new Exception("No base clusterer has been set!");
        }
        if (instances.classIndex() > -1) {
            instances = new Instances(instances);
            instances.deleteWithMissingClass();
        }
        this.m_Filter.setInputFormat(instances);
        instances = Filter.useFilter(instances, this.m_Filter);
        this.getClusterer().getCapabilities().testWithFail(instances);
        this.m_FilteredInstances = instances.stringFreeStructure();
        this.m_Clusterer.buildClusterer(instances);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_Filter.numPendingOutput() > 0) {
            throw new Exception("Filter output queue not empty!");
        }
        if (!this.m_Filter.input(instance)) {
            throw new Exception("Filter didn't make the test instance immediately available!");
        }
        this.m_Filter.batchFinished();
        Instance instance2 = this.m_Filter.output();
        return this.m_Clusterer.distributionForInstance(instance2);
    }

    public String toString() {
        String string = this.m_FilteredInstances == null ? "FilteredClusterer: No model built yet." : "FilteredClusterer using " + this.getClustererSpec() + " on data filtered through " + this.getFilterSpec() + "\n\nFiltered Header\n" + this.m_FilteredInstances.toString() + "\n\nClusterer Model\n" + this.m_Clusterer.toString();
        return string;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5538 $");
    }

    public static void main(String[] stringArray) {
        FilteredClusterer.runClusterer(new FilteredClusterer(), stringArray);
    }
}

