/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch.kdtrees;

import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.neighboursearch.kdtrees.KDTreeNode;
import weka.core.neighboursearch.kdtrees.KDTreeNodeSplitter;

public class KMeansInpiredMethod
extends KDTreeNodeSplitter
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -866783749124714304L;

    public String globalInfo() {
        return "The class that splits a node into two such that the overall sum of squared distances of points to their centres on both sides of the (axis-parallel) splitting plane is minimum.\n\nFor more information see also:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.MASTERSTHESIS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Ashraf Masood Kibriya");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Fast Algorithms for Nearest Neighbour Search");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2007");
        technicalInformation.setValue(TechnicalInformation.Field.SCHOOL, "Department of Computer Science, School of Computing and Mathematical Sciences, University of Waikato");
        technicalInformation.setValue(TechnicalInformation.Field.ADDRESS, "Hamilton, New Zealand");
        return technicalInformation;
    }

    public void splitNode(KDTreeNode kDTreeNode, int n, double[][] dArray, double[][] dArray2) throws Exception {
        int n2;
        this.correctlyInitialized();
        int n3 = -1;
        double d = Double.NEGATIVE_INFINITY;
        double[] dArray3 = new double[this.m_Instances.numAttributes()];
        double[] dArray4 = new double[this.m_Instances.numAttributes()];
        double[] dArray5 = new double[this.m_Instances.numAttributes()];
        double[] dArray6 = new double[this.m_Instances.numAttributes()];
        double d2 = Double.POSITIVE_INFINITY;
        for (n2 = 0; n2 < this.m_Instances.numAttributes(); ++n2) {
            double d3;
            int n4;
            if (kDTreeNode.m_NodeRanges[n2][2] == 0.0 || n2 == this.m_Instances.classIndex()) continue;
            KMeansInpiredMethod.quickSort(this.m_Instances, this.m_InstList, n2, kDTreeNode.m_Start, kDTreeNode.m_End);
            for (n4 = kDTreeNode.m_Start; n4 <= kDTreeNode.m_End; ++n4) {
                for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
                    if (i == this.m_Instances.classIndex()) continue;
                    d3 = this.m_Instances.instance(this.m_InstList[n4]).value(i);
                    if (this.m_NormalizeNodeWidth) {
                        d3 = Double.isNaN(dArray2[i][0]) || dArray2[i][0] == dArray2[i][1] ? 0.0 : (d3 - dArray2[i][0]) / dArray2[i][2];
                    }
                    if (n4 == kDTreeNode.m_Start) {
                        dArray6[i] = 0.0;
                        dArray5[i] = 0.0;
                        dArray4[i] = 0.0;
                        dArray3[i] = 0.0;
                    }
                    int n5 = i;
                    dArray4[n5] = dArray4[n5] + d3;
                    int n6 = i;
                    dArray6[n6] = dArray6[n6] + d3 * d3;
                }
            }
            for (n4 = kDTreeNode.m_Start; n4 <= kDTreeNode.m_End - 1; ++n4) {
                Instance instance = this.m_Instances.instance(this.m_InstList[n4]);
                double d4 = 0.0;
                double d5 = 0.0;
                for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
                    if (i == this.m_Instances.classIndex()) continue;
                    d3 = instance.value(i);
                    if (this.m_NormalizeNodeWidth) {
                        d3 = Double.isNaN(dArray2[i][0]) || dArray2[i][0] == dArray2[i][1] ? 0.0 : (d3 - dArray2[i][0]) / dArray2[i][2];
                    }
                    int n7 = i;
                    dArray3[n7] = dArray3[n7] + d3;
                    int n8 = i;
                    dArray4[n8] = dArray4[n8] - d3;
                    int n9 = i;
                    dArray5[n9] = dArray5[n9] + d3 * d3;
                    int n10 = i;
                    dArray6[n10] = dArray6[n10] - d3 * d3;
                    double d6 = dArray3[i] / (double)(n4 - kDTreeNode.m_Start + 1);
                    d6 *= d6;
                    double d7 = dArray4[i] / (double)(kDTreeNode.m_End - n4);
                    d7 *= d7;
                    d5 += dArray5[i] - (double)(n4 - kDTreeNode.m_Start + 1) * d6;
                    d4 += dArray6[i] - (double)(kDTreeNode.m_End - n4) * d7;
                }
                if (!(d2 > d5 + d4)) continue;
                d2 = d5 + d4;
                d = n4 < kDTreeNode.m_End ? (this.m_Instances.instance(this.m_InstList[n4]).value(n2) + this.m_Instances.instance(this.m_InstList[n4 + 1]).value(n2)) / 2.0 : this.m_Instances.instance(this.m_InstList[n4]).value(n2);
                n3 = n2;
            }
        }
        n2 = this.rearrangePoints(this.m_InstList, kDTreeNode.m_Start, kDTreeNode.m_End, n3, d);
        if (n2 == kDTreeNode.m_Start || n2 > kDTreeNode.m_End) {
            System.out.println("node.m_Start: " + kDTreeNode.m_Start + " node.m_End: " + kDTreeNode.m_End + " splitDim: " + n3 + " splitVal: " + d + " node.min: " + kDTreeNode.m_NodeRanges[n3][0] + " node.max: " + kDTreeNode.m_NodeRanges[n3][1] + " node.numInstances: " + kDTreeNode.numInstances());
            if (n2 == kDTreeNode.m_Start) {
                throw new Exception("Left child is empty in node " + kDTreeNode.m_NodeNumber + ". Not possible with " + "KMeanInspiredMethod splitting method. Please " + "check code.");
            }
            throw new Exception("Right child is empty in node " + kDTreeNode.m_NodeNumber + ". Not possible with " + "KMeansInspiredMethod splitting method. Please " + "check code.");
        }
        kDTreeNode.m_SplitDim = n3;
        kDTreeNode.m_SplitValue = d;
        kDTreeNode.m_Left = new KDTreeNode(n + 1, kDTreeNode.m_Start, n2 - 1, this.m_EuclideanDistance.initializeRanges(this.m_InstList, kDTreeNode.m_Start, n2 - 1));
        kDTreeNode.m_Right = new KDTreeNode(n + 2, n2, kDTreeNode.m_End, this.m_EuclideanDistance.initializeRanges(this.m_InstList, n2, kDTreeNode.m_End));
    }

    protected static int partition(Instances instances, int[] nArray, int n, int n2, int n3) {
        double d = instances.instance(nArray[(n2 + n3) / 2]).value(n);
        while (n2 < n3) {
            while (instances.instance(nArray[n2]).value(n) < d && n2 < n3) {
                ++n2;
            }
            while (instances.instance(nArray[n3]).value(n) > d && n2 < n3) {
                --n3;
            }
            if (n2 >= n3) continue;
            int n4 = nArray[n2];
            nArray[n2] = nArray[n3];
            nArray[n3] = n4;
            ++n2;
            --n3;
        }
        if (n2 == n3 && instances.instance(nArray[n3]).value(n) > d) {
            --n3;
        }
        return n3;
    }

    protected static void quickSort(Instances instances, int[] nArray, int n, int n2, int n3) {
        if (n2 < n3) {
            int n4 = KMeansInpiredMethod.partition(instances, nArray, n, n2, n3);
            KMeansInpiredMethod.quickSort(instances, nArray, n, n2, n4);
            KMeansInpiredMethod.quickSort(instances, nArray, n, n4 + 1, n3);
        }
    }

    private static void checkSort(Instances instances, int[] nArray, int n, int n2, int n3) throws Exception {
        for (int i = n2 + 1; i <= n3; ++i) {
            if (!(instances.instance(nArray[i - 1]).value(n) > instances.instance(nArray[i]).value(n))) continue;
            System.out.println("value[i-1]: " + instances.instance(nArray[i - 1]).value(n));
            System.out.println("value[i]: " + instances.instance(nArray[i]).value(n));
            System.out.println("indices[i-1]: " + nArray[i - 1]);
            System.out.println("indices[i]: " + nArray[i]);
            System.out.println("i: " + i);
            if (instances.instance(nArray[i - 1]).value(n) > instances.instance(nArray[i]).value(n)) {
                System.out.println("value[i-1] > value[i]");
            }
            throw new Exception("Indices not sorted correctly.");
        }
    }

    protected int rearrangePoints(int[] nArray, int n, int n2, int n3, double d) {
        int n4 = n - 1;
        for (int i = n; i <= n2; ++i) {
            if (!this.m_EuclideanDistance.valueIsSmallerEqual(this.m_Instances.instance(nArray[i]), n3, d)) continue;
            int n5 = nArray[++n4];
            nArray[n4] = nArray[i];
            nArray[i] = n5;
        }
        return n4 + 1;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }
}

