/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.unsupervised.attribute.Discretize;

public class PKIDiscretize
extends Discretize
implements TechnicalInformationHandler {
    static final long serialVersionUID = 6153101248977702675L;

    public boolean setInputFormat(Instances instances) throws Exception {
        this.m_FindNumBins = true;
        return super.setInputFormat(instances);
    }

    protected void findNumBins(int n) {
        Instances instances = this.getInputFormat();
        int n2 = instances.numInstances();
        for (int i = 0; i < instances.numInstances(); ++i) {
            if (!instances.instance(i).isMissing(n)) continue;
            --n2;
        }
        this.m_NumBins = (int)Math.sqrt(n2);
        if (this.m_NumBins > 0) {
            this.calculateCutPointsByEqualFrequencyBinning(n);
        }
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tUnsets the class index temporarily before the filter is\n\tapplied to the data.\n\t(default: no)", "unset-class-temporarily", 1, "-unset-class-temporarily"));
        vector.addElement(new Option("\tSpecifies list of columns to Discretize. First and last are valid indexes.\n\t(default: first-last)", "R", 1, "-R <col1,col2-col4,...>"));
        vector.addElement(new Option("\tInvert matching sense of column indexes.", "V", 0, "-V"));
        vector.addElement(new Option("\tOutput binary attributes for discretized attributes.", "D", 0, "-D"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setIgnoreClass(Utils.getFlag("unset-class-temporarily", stringArray));
        this.setMakeBinary(Utils.getFlag('D', stringArray));
        this.setInvertSelection(Utils.getFlag('V', stringArray));
        String string = Utils.getOption('R', stringArray);
        if (string.length() != 0) {
            this.setAttributeIndices(string);
        } else {
            this.setAttributeIndices("first-last");
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        if (this.getMakeBinary()) {
            vector.add("-D");
        }
        if (this.getInvertSelection()) {
            vector.add("-V");
        }
        if (!this.getAttributeIndices().equals("")) {
            vector.add("-R");
            vector.add(this.getAttributeIndices());
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String globalInfo() {
        return "Discretizes numeric attributes using equal frequency binning, where the number of bins is equal to the square root of the number of non-missing values.\n\nFor more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Ying Yang and Geoffrey I. Webb");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Proportional k-Interval Discretization for Naive-Bayes Classifiers");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "12th European Conference on Machine Learning");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2001");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "564-575");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "Springer");
        technicalInformation.setValue(TechnicalInformation.Field.SERIES, "LNCS");
        technicalInformation.setValue(TechnicalInformation.Field.VOLUME, "2167");
        return technicalInformation;
    }

    public String findNumBinsTipText() {
        return "Ignored.";
    }

    public boolean getFindNumBins() {
        return false;
    }

    public void setFindNumBins(boolean bl) {
    }

    public String useEqualFrequencyTipText() {
        return "Always true.";
    }

    public boolean getUseEqualFrequency() {
        return true;
    }

    public void setUseEqualFrequency(boolean bl) {
    }

    public String binsTipText() {
        return "Ignored.";
    }

    public int getBins() {
        return 0;
    }

    public void setBins(int n) {
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.9 $");
    }

    public static void main(String[] stringArray) {
        PKIDiscretize.runFilter(new PKIDiscretize(), stringArray);
    }
}

