/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch.kdtrees;

import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.neighboursearch.kdtrees.KDTreeNode;
import weka.core.neighboursearch.kdtrees.KDTreeNodeSplitter;

public class MidPointOfWidestDimension
extends KDTreeNodeSplitter
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -7617277960046591906L;

    public String globalInfo() {
        return "The class that splits a KDTree node based on the midpoint value of a dimension in which the node's points have the widest spread.\n\nFor more information see also:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.TECHREPORT);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Andrew Moore");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1991");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "A tutorial on kd-trees");
        technicalInformation.setValue(TechnicalInformation.Field.HOWPUBLISHED, "Extract from PhD Thesis");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "University of Cambridge Computer Laboratory Technical Report No. 209");
        technicalInformation.setValue(TechnicalInformation.Field.HTTP, "http://www.autonlab.org/autonweb/14665.html");
        return technicalInformation;
    }

    public void splitNode(KDTreeNode kDTreeNode, int n, double[][] dArray, double[][] dArray2) throws Exception {
        this.correctlyInitialized();
        int n2 = this.widestDim(dArray, dArray2);
        double d = this.m_EuclideanDistance.getMiddle(dArray[n2]);
        int n3 = this.rearrangePoints(this.m_InstList, kDTreeNode.m_Start, kDTreeNode.m_End, n2, d);
        if (n3 == kDTreeNode.m_Start || n3 > kDTreeNode.m_End) {
            if (n3 == kDTreeNode.m_Start) {
                throw new Exception("Left child is empty in node " + kDTreeNode.m_NodeNumber + ". Not possible with " + "MidPointofWidestDim splitting method. Please " + "check code.");
            }
            throw new Exception("Right child is empty in node " + kDTreeNode.m_NodeNumber + ". Not possible with " + "MidPointofWidestDim splitting method. Please " + "check code.");
        }
        kDTreeNode.m_SplitDim = n2;
        kDTreeNode.m_SplitValue = d;
        kDTreeNode.m_Left = new KDTreeNode(n + 1, kDTreeNode.m_Start, n3 - 1, this.m_EuclideanDistance.initializeRanges(this.m_InstList, kDTreeNode.m_Start, n3 - 1));
        kDTreeNode.m_Right = new KDTreeNode(n + 2, n3, kDTreeNode.m_End, this.m_EuclideanDistance.initializeRanges(this.m_InstList, n3, kDTreeNode.m_End));
    }

    protected int rearrangePoints(int[] nArray, int n, int n2, int n3, double d) {
        int n4 = n - 1;
        for (int i = n; i <= n2; ++i) {
            if (!this.m_EuclideanDistance.valueIsSmallerEqual(this.m_Instances.instance(nArray[i]), n3, d)) continue;
            int n5 = nArray[++n4];
            nArray[n4] = nArray[i];
            nArray[i] = n5;
        }
        return n4 + 1;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }
}

