/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import weka.classifiers.Classifier;
import weka.classifiers.Sourcable;
import weka.classifiers.rules.ZeroR;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.ContingencyTables;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class DecisionStump
extends Classifier
implements WeightedInstancesHandler,
Sourcable {
    static final long serialVersionUID = 1618384535950391L;
    private int m_AttIndex;
    private double m_SplitPoint;
    private double[][] m_Distribution;
    private Instances m_Instances;
    private Classifier m_ZeroR;

    public String globalInfo() {
        return "Class for building and using a decision stump. Usually used in conjunction with a boosting algorithm. Does regression (based on mean-squared error) or classification (based on entropy). Missing is treated as a separate value.";
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.NUMERIC_CLASS);
        capabilities.enable(Capabilities.Capability.DATE_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        int n;
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        int n2 = -1;
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        if (instances.numAttributes() == 1) {
            System.err.println("Cannot build model (only class attribute present in data!), using ZeroR model instead!");
            this.m_ZeroR = new ZeroR();
            this.m_ZeroR.buildClassifier(instances);
            return;
        }
        this.m_ZeroR = null;
        double[][] dArray = new double[3][instances.numClasses()];
        this.m_Instances = new Instances(instances);
        int n3 = this.m_Instances.classAttribute().isNominal() ? this.m_Instances.numClasses() : 1;
        boolean bl = true;
        for (n = 0; n < this.m_Instances.numAttributes(); ++n) {
            if (n == this.m_Instances.classIndex()) continue;
            this.m_Distribution = new double[3][n3];
            double d3 = this.m_Instances.attribute(n).isNominal() ? this.findSplitNominal(n) : this.findSplitNumeric(n);
            if (bl || d3 < d) {
                d = d3;
                n2 = n;
                d2 = this.m_SplitPoint;
                for (int i = 0; i < 3; ++i) {
                    System.arraycopy(this.m_Distribution[i], 0, dArray[i], 0, n3);
                }
            }
            bl = false;
        }
        this.m_AttIndex = n2;
        this.m_SplitPoint = d2;
        this.m_Distribution = dArray;
        if (this.m_Instances.classAttribute().isNominal()) {
            for (n = 0; n < this.m_Distribution.length; ++n) {
                double d4 = Utils.sum(this.m_Distribution[n]);
                if (d4 == 0.0) {
                    System.arraycopy(this.m_Distribution[2], 0, this.m_Distribution[n], 0, this.m_Distribution[2].length);
                    Utils.normalize(this.m_Distribution[n]);
                    continue;
                }
                Utils.normalize(this.m_Distribution[n], d4);
            }
        }
        this.m_Instances = new Instances(this.m_Instances, 0);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_ZeroR != null) {
            return this.m_ZeroR.distributionForInstance(instance);
        }
        return this.m_Distribution[this.whichSubset(instance)];
    }

    public String toSource(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer("class ");
        Attribute attribute = this.m_Instances.classAttribute();
        stringBuffer.append(string).append(" {\n  public static double classify(Object[] i) {\n");
        stringBuffer.append("    /* " + this.m_Instances.attribute(this.m_AttIndex).name() + " */\n");
        stringBuffer.append("    if (i[").append(this.m_AttIndex);
        stringBuffer.append("] == null) { return ");
        stringBuffer.append(this.sourceClass(attribute, this.m_Distribution[2])).append(";");
        if (this.m_Instances.attribute(this.m_AttIndex).isNominal()) {
            stringBuffer.append(" } else if (((String)i[").append(this.m_AttIndex);
            stringBuffer.append("]).equals(\"");
            stringBuffer.append(this.m_Instances.attribute(this.m_AttIndex).value((int)this.m_SplitPoint));
            stringBuffer.append("\")");
        } else {
            stringBuffer.append(" } else if (((Double)i[").append(this.m_AttIndex);
            stringBuffer.append("]).doubleValue() <= ").append(this.m_SplitPoint);
        }
        stringBuffer.append(") { return ");
        stringBuffer.append(this.sourceClass(attribute, this.m_Distribution[0])).append(";");
        stringBuffer.append(" } else { return ");
        stringBuffer.append(this.sourceClass(attribute, this.m_Distribution[1])).append(";");
        stringBuffer.append(" }\n  }\n}\n");
        return stringBuffer.toString();
    }

    private String sourceClass(Attribute attribute, double[] dArray) {
        if (attribute.isNominal()) {
            return Integer.toString(Utils.maxIndex(dArray));
        }
        return Double.toString(dArray[0]);
    }

    public String toString() {
        if (this.m_ZeroR != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getClass().getName().replaceAll(".*\\.", "") + "\n");
            stringBuffer.append(this.getClass().getName().replaceAll(".*\\.", "").replaceAll(".", "=") + "\n\n");
            stringBuffer.append("Warning: No model could be built, hence ZeroR model is used:\n\n");
            stringBuffer.append(this.m_ZeroR.toString());
            return stringBuffer.toString();
        }
        if (this.m_Instances == null) {
            return "Decision Stump: No model built yet.";
        }
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Decision Stump\n\n");
            stringBuffer.append("Classifications\n\n");
            Attribute attribute = this.m_Instances.attribute(this.m_AttIndex);
            if (attribute.isNominal()) {
                stringBuffer.append(attribute.name() + " = " + attribute.value((int)this.m_SplitPoint) + " : ");
                stringBuffer.append(this.printClass(this.m_Distribution[0]));
                stringBuffer.append(attribute.name() + " != " + attribute.value((int)this.m_SplitPoint) + " : ");
                stringBuffer.append(this.printClass(this.m_Distribution[1]));
            } else {
                stringBuffer.append(attribute.name() + " <= " + this.m_SplitPoint + " : ");
                stringBuffer.append(this.printClass(this.m_Distribution[0]));
                stringBuffer.append(attribute.name() + " > " + this.m_SplitPoint + " : ");
                stringBuffer.append(this.printClass(this.m_Distribution[1]));
            }
            stringBuffer.append(attribute.name() + " is missing : ");
            stringBuffer.append(this.printClass(this.m_Distribution[2]));
            if (this.m_Instances.classAttribute().isNominal()) {
                stringBuffer.append("\nClass distributions\n\n");
                if (attribute.isNominal()) {
                    stringBuffer.append(attribute.name() + " = " + attribute.value((int)this.m_SplitPoint) + "\n");
                    stringBuffer.append(this.printDist(this.m_Distribution[0]));
                    stringBuffer.append(attribute.name() + " != " + attribute.value((int)this.m_SplitPoint) + "\n");
                    stringBuffer.append(this.printDist(this.m_Distribution[1]));
                } else {
                    stringBuffer.append(attribute.name() + " <= " + this.m_SplitPoint + "\n");
                    stringBuffer.append(this.printDist(this.m_Distribution[0]));
                    stringBuffer.append(attribute.name() + " > " + this.m_SplitPoint + "\n");
                    stringBuffer.append(this.printDist(this.m_Distribution[1]));
                }
                stringBuffer.append(attribute.name() + " is missing\n");
                stringBuffer.append(this.printDist(this.m_Distribution[2]));
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "Can't print decision stump classifier!";
        }
    }

    private String printDist(double[] dArray) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_Instances.classAttribute().isNominal()) {
            int n;
            for (n = 0; n < this.m_Instances.numClasses(); ++n) {
                stringBuffer.append(this.m_Instances.classAttribute().value(n) + "\t");
            }
            stringBuffer.append("\n");
            for (n = 0; n < this.m_Instances.numClasses(); ++n) {
                stringBuffer.append(dArray[n] + "\t");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private String printClass(double[] dArray) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_Instances.classAttribute().isNominal()) {
            stringBuffer.append(this.m_Instances.classAttribute().value(Utils.maxIndex(dArray)));
        } else {
            stringBuffer.append(dArray[0]);
        }
        return stringBuffer.toString() + "\n";
    }

    private double findSplitNominal(int n) throws Exception {
        if (this.m_Instances.classAttribute().isNominal()) {
            return this.findSplitNominalNominal(n);
        }
        return this.findSplitNominalNumeric(n);
    }

    private double findSplitNominalNominal(int n) throws Exception {
        int n2;
        double d = Double.MAX_VALUE;
        double[][] dArray = new double[this.m_Instances.attribute(n).numValues() + 1][this.m_Instances.numClasses()];
        double[] dArray2 = new double[this.m_Instances.numClasses()];
        double[][] dArray3 = new double[3][this.m_Instances.numClasses()];
        int n3 = 0;
        for (n2 = 0; n2 < this.m_Instances.numInstances(); ++n2) {
            Instance instance = this.m_Instances.instance(n2);
            if (instance.isMissing(n)) {
                ++n3;
                double[] dArray4 = dArray[this.m_Instances.attribute(n).numValues()];
                int n4 = (int)instance.classValue();
                dArray4[n4] = dArray4[n4] + instance.weight();
                continue;
            }
            double[] dArray5 = dArray[(int)instance.value(n)];
            int n5 = (int)instance.classValue();
            dArray5[n5] = dArray5[n5] + instance.weight();
        }
        for (n2 = 0; n2 < this.m_Instances.attribute(n).numValues(); ++n2) {
            for (int i = 0; i < this.m_Instances.numClasses(); ++i) {
                int n6 = i;
                dArray2[n6] = dArray2[n6] + dArray[n2][i];
            }
        }
        System.arraycopy(dArray[this.m_Instances.attribute(n).numValues()], 0, this.m_Distribution[2], 0, this.m_Instances.numClasses());
        for (n2 = 0; n2 < this.m_Instances.attribute(n).numValues(); ++n2) {
            int n7;
            for (n7 = 0; n7 < this.m_Instances.numClasses(); ++n7) {
                this.m_Distribution[0][n7] = dArray[n2][n7];
                this.m_Distribution[1][n7] = dArray2[n7] - dArray[n2][n7];
            }
            double d2 = ContingencyTables.entropyConditionedOnRows(this.m_Distribution);
            if (!(d2 < d)) continue;
            d = d2;
            this.m_SplitPoint = n2;
            for (n7 = 0; n7 < 3; ++n7) {
                System.arraycopy(this.m_Distribution[n7], 0, dArray3[n7], 0, this.m_Instances.numClasses());
            }
        }
        if (n3 == 0) {
            System.arraycopy(dArray2, 0, dArray3[2], 0, this.m_Instances.numClasses());
        }
        this.m_Distribution = dArray3;
        return d;
    }

    private double findSplitNominalNumeric(int n) throws Exception {
        int n2;
        double d = Double.MAX_VALUE;
        double[] dArray = new double[this.m_Instances.attribute(n).numValues()];
        double[] dArray2 = new double[this.m_Instances.attribute(n).numValues()];
        double[] dArray3 = new double[this.m_Instances.attribute(n).numValues()];
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double[] dArray4 = new double[3];
        double[] dArray5 = new double[3];
        double[][] dArray6 = new double[3][1];
        for (n2 = 0; n2 < this.m_Instances.numInstances(); ++n2) {
            Instance instance = this.m_Instances.instance(n2);
            if (instance.isMissing(n)) {
                double[] dArray7 = this.m_Distribution[2];
                dArray7[0] = dArray7[0] + instance.classValue() * instance.weight();
                dArray4[2] = dArray4[2] + instance.classValue() * instance.classValue() * instance.weight();
                dArray5[2] = dArray5[2] + instance.weight();
            } else {
                int n3 = (int)instance.value(n);
                dArray3[n3] = dArray3[n3] + instance.weight();
                int n4 = (int)instance.value(n);
                dArray2[n4] = dArray2[n4] + instance.classValue() * instance.weight();
                int n5 = (int)instance.value(n);
                dArray[n5] = dArray[n5] + instance.classValue() * instance.classValue() * instance.weight();
            }
            d5 += instance.weight();
            d6 += instance.classValue() * instance.weight();
        }
        if (d5 <= 0.0) {
            return d;
        }
        for (n2 = 0; n2 < this.m_Instances.attribute(n).numValues(); ++n2) {
            d4 += dArray3[n2];
            d2 += dArray[n2];
            d3 += dArray2[n2];
        }
        for (n2 = 0; n2 < this.m_Instances.attribute(n).numValues(); ++n2) {
            this.m_Distribution[0][0] = dArray2[n2];
            dArray4[0] = dArray[n2];
            dArray5[0] = dArray3[n2];
            this.m_Distribution[1][0] = d3 - dArray2[n2];
            dArray4[1] = d2 - dArray[n2];
            dArray5[1] = d4 - dArray3[n2];
            double d7 = this.variance(this.m_Distribution, dArray4, dArray5);
            if (!(d7 < d)) continue;
            d = d7;
            this.m_SplitPoint = n2;
            for (int i = 0; i < 3; ++i) {
                dArray6[i][0] = dArray5[i] > 0.0 ? this.m_Distribution[i][0] / dArray5[i] : d6 / d5;
            }
        }
        this.m_Distribution = dArray6;
        return d;
    }

    private double findSplitNumeric(int n) throws Exception {
        if (this.m_Instances.classAttribute().isNominal()) {
            return this.findSplitNumericNominal(n);
        }
        return this.findSplitNumericNumeric(n);
    }

    private double findSplitNumericNominal(int n) throws Exception {
        Instance instance;
        int n2;
        double d = Double.MAX_VALUE;
        int n3 = 0;
        double[] dArray = new double[this.m_Instances.numClasses()];
        double[][] dArray2 = new double[3][this.m_Instances.numClasses()];
        for (n2 = 0; n2 < this.m_Instances.numInstances(); ++n2) {
            instance = this.m_Instances.instance(n2);
            if (!instance.isMissing(n)) {
                double[] dArray3 = this.m_Distribution[1];
                int n4 = (int)instance.classValue();
                dArray3[n4] = dArray3[n4] + instance.weight();
                continue;
            }
            double[] dArray4 = this.m_Distribution[2];
            int n5 = (int)instance.classValue();
            dArray4[n5] = dArray4[n5] + instance.weight();
            ++n3;
        }
        System.arraycopy(this.m_Distribution[1], 0, dArray, 0, this.m_Instances.numClasses());
        for (n2 = 0; n2 < 3; ++n2) {
            System.arraycopy(this.m_Distribution[n2], 0, dArray2[n2], 0, this.m_Instances.numClasses());
        }
        this.m_Instances.sort(n);
        for (n2 = 0; n2 < this.m_Instances.numInstances() - (n3 + 1); ++n2) {
            instance = this.m_Instances.instance(n2);
            Instance instance2 = this.m_Instances.instance(n2 + 1);
            double[] dArray5 = this.m_Distribution[0];
            int n6 = (int)instance.classValue();
            dArray5[n6] = dArray5[n6] + instance.weight();
            double[] dArray6 = this.m_Distribution[1];
            int n7 = (int)instance.classValue();
            dArray6[n7] = dArray6[n7] - instance.weight();
            if (!(instance.value(n) < instance2.value(n))) continue;
            double d2 = (instance.value(n) + instance2.value(n)) / 2.0;
            double d3 = ContingencyTables.entropyConditionedOnRows(this.m_Distribution);
            if (!(d3 < d)) continue;
            this.m_SplitPoint = d2;
            d = d3;
            for (int i = 0; i < 3; ++i) {
                System.arraycopy(this.m_Distribution[i], 0, dArray2[i], 0, this.m_Instances.numClasses());
            }
        }
        if (n3 == 0) {
            System.arraycopy(dArray, 0, dArray2[2], 0, this.m_Instances.numClasses());
        }
        this.m_Distribution = dArray2;
        return d;
    }

    private double findSplitNumericNumeric(int n) throws Exception {
        Instance instance;
        int n2;
        double d = Double.MAX_VALUE;
        int n3 = 0;
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        double[][] dArray3 = new double[3][1];
        double d2 = 0.0;
        double d3 = 0.0;
        for (n2 = 0; n2 < this.m_Instances.numInstances(); ++n2) {
            instance = this.m_Instances.instance(n2);
            if (!instance.isMissing(n)) {
                double[] dArray4 = this.m_Distribution[1];
                dArray4[0] = dArray4[0] + instance.classValue() * instance.weight();
                dArray[1] = dArray[1] + instance.classValue() * instance.classValue() * instance.weight();
                dArray2[1] = dArray2[1] + instance.weight();
            } else {
                double[] dArray5 = this.m_Distribution[2];
                dArray5[0] = dArray5[0] + instance.classValue() * instance.weight();
                dArray[2] = dArray[2] + instance.classValue() * instance.classValue() * instance.weight();
                dArray2[2] = dArray2[2] + instance.weight();
                ++n3;
            }
            d3 += instance.weight();
            d2 += instance.classValue() * instance.weight();
        }
        if (d3 <= 0.0) {
            return d;
        }
        this.m_Instances.sort(n);
        for (n2 = 0; n2 < this.m_Instances.numInstances() - (n3 + 1); ++n2) {
            instance = this.m_Instances.instance(n2);
            Instance instance2 = this.m_Instances.instance(n2 + 1);
            double[] dArray6 = this.m_Distribution[0];
            dArray6[0] = dArray6[0] + instance.classValue() * instance.weight();
            dArray[0] = dArray[0] + instance.classValue() * instance.classValue() * instance.weight();
            dArray2[0] = dArray2[0] + instance.weight();
            double[] dArray7 = this.m_Distribution[1];
            dArray7[0] = dArray7[0] - instance.classValue() * instance.weight();
            dArray[1] = dArray[1] - instance.classValue() * instance.classValue() * instance.weight();
            dArray2[1] = dArray2[1] - instance.weight();
            if (!(instance.value(n) < instance2.value(n))) continue;
            double d4 = (instance.value(n) + instance2.value(n)) / 2.0;
            double d5 = this.variance(this.m_Distribution, dArray, dArray2);
            if (!(d5 < d)) continue;
            this.m_SplitPoint = d4;
            d = d5;
            for (int i = 0; i < 3; ++i) {
                dArray3[i][0] = dArray2[i] > 0.0 ? this.m_Distribution[i][0] / dArray2[i] : d2 / d3;
            }
        }
        this.m_Distribution = dArray3;
        return d;
    }

    private double variance(double[][] dArray, double[] dArray2, double[] dArray3) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray3[i] > 0.0)) continue;
            d += dArray2[i] - dArray[i][0] * dArray[i][0] / dArray3[i];
        }
        return d;
    }

    private int whichSubset(Instance instance) throws Exception {
        if (instance.isMissing(this.m_AttIndex)) {
            return 2;
        }
        if (instance.attribute(this.m_AttIndex).isNominal()) {
            if ((double)((int)instance.value(this.m_AttIndex)) == this.m_SplitPoint) {
                return 0;
            }
            return 1;
        }
        if (instance.value(this.m_AttIndex) <= this.m_SplitPoint) {
            return 0;
        }
        return 1;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.27 $");
    }

    public static void main(String[] stringArray) {
        DecisionStump.runClassifier(new DecisionStump(), stringArray);
    }
}

