/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import weka.core.Attribute;
import weka.core.AttributeStats;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.UnassignedClassException;
import weka.core.Utils;
import weka.core.converters.ArffLoader;
import weka.core.converters.ConverterUtils;
import weka.experiment.Stats;

public class Instances
implements Serializable {
    static final long serialVersionUID = -19412345060742748L;
    public static final String FILE_EXTENSION = ".arff";
    public static final String SERIALIZED_OBJ_FILE_EXTENSION = ".bsi";
    public static final String ARFF_RELATION = "@relation";
    public static final String ARFF_DATA = "@data";
    protected String m_RelationName;
    protected FastVector m_Attributes;
    protected FastVector m_Instances;
    protected int m_ClassIndex;
    protected int m_Lines = 0;

    public Instances(Reader reader) throws IOException {
        ArffLoader.ArffReader arffReader = new ArffLoader.ArffReader(reader);
        Instances instances = arffReader.getData();
        this.initialize(instances, instances.numInstances());
        instances.copyInstances(0, this, instances.numInstances());
        this.compactify();
    }

    @Deprecated
    public Instances(Reader reader, int n) throws IOException {
        ArffLoader.ArffReader arffReader = new ArffLoader.ArffReader(reader, 0);
        Instances instances = arffReader.getStructure();
        this.initialize(instances, n);
        this.m_Lines = arffReader.getLineNo();
    }

    public Instances(Instances instances) {
        this(instances, instances.numInstances());
        instances.copyInstances(0, this, instances.numInstances());
    }

    public Instances(Instances instances, int n) {
        this.initialize(instances, n);
    }

    protected void initialize(Instances instances, int n) {
        if (n < 0) {
            n = 0;
        }
        this.m_ClassIndex = instances.m_ClassIndex;
        this.m_RelationName = instances.m_RelationName;
        this.m_Attributes = instances.m_Attributes;
        this.m_Instances = new FastVector(n);
    }

    public Instances(Instances instances, int n, int n2) {
        this(instances, n2);
        if (n < 0 || n + n2 > instances.numInstances()) {
            throw new IllegalArgumentException("Parameters first and/or toCopy out of range");
        }
        instances.copyInstances(n, this, n2);
    }

    public Instances(String string, FastVector fastVector, int n) {
        this.m_RelationName = string;
        this.m_ClassIndex = -1;
        this.m_Attributes = fastVector;
        for (int i = 0; i < this.numAttributes(); ++i) {
            this.attribute(i).setIndex(i);
        }
        this.m_Instances = new FastVector(n);
    }

    public Instances stringFreeStructure() {
        FastVector fastVector = (FastVector)this.m_Attributes.copy();
        for (int i = 0; i < fastVector.size(); ++i) {
            Attribute attribute = (Attribute)fastVector.elementAt(i);
            if (attribute.type() == 2) {
                fastVector.setElementAt(new Attribute(attribute.name(), (FastVector)null), i);
                continue;
            }
            if (attribute.type() != 4) continue;
            fastVector.setElementAt(new Attribute(attribute.name(), new Instances(attribute.relation(), 0)), i);
        }
        Instances instances = new Instances(this.relationName(), fastVector, 0);
        instances.m_ClassIndex = this.m_ClassIndex;
        return instances;
    }

    public void add(Instance instance) {
        Instance instance2 = (Instance)instance.copy();
        instance2.setDataset(this);
        this.m_Instances.addElement(instance2);
    }

    public Attribute attribute(int n) {
        return (Attribute)this.m_Attributes.elementAt(n);
    }

    public Attribute attribute(String string) {
        for (int i = 0; i < this.numAttributes(); ++i) {
            if (!this.attribute(i).name().equals(string)) continue;
            return this.attribute(i);
        }
        return null;
    }

    public boolean checkForAttributeType(int n) {
        int n2 = 0;
        while (n2 < this.m_Attributes.size()) {
            if (this.attribute(n2++).type() != n) continue;
            return true;
        }
        return false;
    }

    public boolean checkForStringAttributes() {
        return this.checkForAttributeType(2);
    }

    public boolean checkInstance(Instance instance) {
        if (instance.numAttributes() != this.numAttributes()) {
            return false;
        }
        for (int i = 0; i < this.numAttributes(); ++i) {
            if (instance.isMissing(i) || !this.attribute(i).isNominal() && !this.attribute(i).isString()) continue;
            if (!Utils.eq(instance.value(i), (int)instance.value(i))) {
                return false;
            }
            if (!Utils.sm(instance.value(i), 0.0) && !Utils.gr(instance.value(i), this.attribute(i).numValues())) continue;
            return false;
        }
        return true;
    }

    public Attribute classAttribute() {
        if (this.m_ClassIndex < 0) {
            throw new UnassignedClassException("Class index is negative (not set)!");
        }
        return this.attribute(this.m_ClassIndex);
    }

    public int classIndex() {
        return this.m_ClassIndex;
    }

    public void compactify() {
        this.m_Instances.trimToSize();
    }

    public void delete() {
        this.m_Instances = new FastVector();
    }

    public void delete(int n) {
        this.m_Instances.removeElementAt(n);
    }

    public void deleteAttributeAt(int n) {
        int n2;
        if (n < 0 || n >= this.m_Attributes.size()) {
            throw new IllegalArgumentException("Index out of range");
        }
        if (n == this.m_ClassIndex) {
            throw new IllegalArgumentException("Can't delete class attribute");
        }
        this.freshAttributeInfo();
        if (this.m_ClassIndex > n) {
            --this.m_ClassIndex;
        }
        this.m_Attributes.removeElementAt(n);
        for (n2 = n; n2 < this.m_Attributes.size(); ++n2) {
            Attribute attribute = (Attribute)this.m_Attributes.elementAt(n2);
            attribute.setIndex(attribute.index() - 1);
        }
        for (n2 = 0; n2 < this.numInstances(); ++n2) {
            this.instance(n2).forceDeleteAttributeAt(n);
        }
    }

    public void deleteAttributeType(int n) {
        int n2 = 0;
        while (n2 < this.m_Attributes.size()) {
            if (this.attribute(n2).type() == n) {
                this.deleteAttributeAt(n2);
                continue;
            }
            ++n2;
        }
    }

    public void deleteStringAttributes() {
        this.deleteAttributeType(2);
    }

    public void deleteWithMissing(int n) {
        FastVector fastVector = new FastVector(this.numInstances());
        for (int i = 0; i < this.numInstances(); ++i) {
            if (this.instance(i).isMissing(n)) continue;
            fastVector.addElement(this.instance(i));
        }
        this.m_Instances = fastVector;
    }

    public void deleteWithMissing(Attribute attribute) {
        this.deleteWithMissing(attribute.index());
    }

    public void deleteWithMissingClass() {
        if (this.m_ClassIndex < 0) {
            throw new UnassignedClassException("Class index is negative (not set)!");
        }
        this.deleteWithMissing(this.m_ClassIndex);
    }

    public Enumeration enumerateAttributes() {
        return this.m_Attributes.elements(this.m_ClassIndex);
    }

    public Enumeration enumerateInstances() {
        return this.m_Instances.elements();
    }

    public boolean equalHeaders(Instances instances) {
        if (this.m_ClassIndex != instances.m_ClassIndex) {
            return false;
        }
        if (this.m_Attributes.size() != instances.m_Attributes.size()) {
            return false;
        }
        for (int i = 0; i < this.m_Attributes.size(); ++i) {
            if (this.attribute(i).equals(instances.attribute(i))) continue;
            return false;
        }
        return true;
    }

    public Instance firstInstance() {
        return (Instance)this.m_Instances.firstElement();
    }

    public Random getRandomNumberGenerator(long l) {
        Random random = new Random(l);
        random.setSeed((long)this.instance(random.nextInt(this.numInstances())).toString().hashCode() + l);
        return random;
    }

    public void insertAttributeAt(Attribute attribute, int n) {
        int n2;
        if (n < 0 || n > this.m_Attributes.size()) {
            throw new IllegalArgumentException("Index out of range");
        }
        attribute = (Attribute)attribute.copy();
        this.freshAttributeInfo();
        attribute.setIndex(n);
        this.m_Attributes.insertElementAt(attribute, n);
        for (n2 = n + 1; n2 < this.m_Attributes.size(); ++n2) {
            Attribute attribute2 = (Attribute)this.m_Attributes.elementAt(n2);
            attribute2.setIndex(attribute2.index() + 1);
        }
        for (n2 = 0; n2 < this.numInstances(); ++n2) {
            this.instance(n2).forceInsertAttributeAt(n);
        }
        if (this.m_ClassIndex >= n) {
            ++this.m_ClassIndex;
        }
    }

    public Instance instance(int n) {
        return (Instance)this.m_Instances.elementAt(n);
    }

    public double kthSmallestValue(Attribute attribute, int n) {
        return this.kthSmallestValue(attribute.index(), n);
    }

    public double kthSmallestValue(int n, int n2) {
        if (!this.attribute(n).isNumeric()) {
            throw new IllegalArgumentException("Instances: attribute must be numeric to compute kth-smallest value.");
        }
        int n3 = this.numInstances() - 1;
        int n4 = 0;
        while (n4 <= n3) {
            if (this.instance(n3).isMissing(n)) {
                --n3;
                continue;
            }
            if (this.instance(n4).isMissing(n)) {
                this.swap(n4, n3);
                --n3;
            }
            ++n4;
        }
        if (n2 < 1 || n2 > n3 + 1) {
            throw new IllegalArgumentException("Instances: value for k for computing kth-smallest value too large.");
        }
        return this.instance(this.select(n, 0, n3, n2)).value(n);
    }

    public Instance lastInstance() {
        return (Instance)this.m_Instances.lastElement();
    }

    public double meanOrMode(int n) {
        if (this.attribute(n).isNumeric()) {
            double d = 0.0;
            double d2 = 0.0;
            for (int i = 0; i < this.numInstances(); ++i) {
                if (this.instance(i).isMissing(n)) continue;
                d += this.instance(i).weight();
                d2 += this.instance(i).weight() * this.instance(i).value(n);
            }
            if (d <= 0.0) {
                return 0.0;
            }
            return d2 / d;
        }
        if (this.attribute(n).isNominal()) {
            int[] nArray = new int[this.attribute(n).numValues()];
            for (int i = 0; i < this.numInstances(); ++i) {
                if (this.instance(i).isMissing(n)) continue;
                int n2 = (int)this.instance(i).value(n);
                nArray[n2] = (int)((double)nArray[n2] + this.instance(i).weight());
            }
            return Utils.maxIndex(nArray);
        }
        return 0.0;
    }

    public double meanOrMode(Attribute attribute) {
        return this.meanOrMode(attribute.index());
    }

    public int numAttributes() {
        return this.m_Attributes.size();
    }

    public int numClasses() {
        if (this.m_ClassIndex < 0) {
            throw new UnassignedClassException("Class index is negative (not set)!");
        }
        if (!this.classAttribute().isNominal()) {
            return 1;
        }
        return this.classAttribute().numValues();
    }

    public int numDistinctValues(int n) {
        if (this.attribute(n).isNumeric()) {
            Instance instance;
            double[] dArray = this.attributeToDoubleArray(n);
            int[] nArray = Utils.sort(dArray);
            double d = 0.0;
            int n2 = 0;
            for (int i = 0; i < nArray.length && !(instance = this.instance(nArray[i])).isMissing(n); ++i) {
                if (i != 0 && !(instance.value(n) > d)) continue;
                d = instance.value(n);
                ++n2;
            }
            return n2;
        }
        return this.attribute(n).numValues();
    }

    public int numDistinctValues(Attribute attribute) {
        return this.numDistinctValues(attribute.index());
    }

    public int numInstances() {
        return this.m_Instances.size();
    }

    public void randomize(Random random) {
        for (int i = this.numInstances() - 1; i > 0; --i) {
            this.swap(i, random.nextInt(i + 1));
        }
    }

    @Deprecated
    public boolean readInstance(Reader reader) throws IOException {
        ArffLoader.ArffReader arffReader = new ArffLoader.ArffReader(reader, this, this.m_Lines, 1);
        Instance instance = arffReader.readInstance(arffReader.getData(), false);
        this.m_Lines = arffReader.getLineNo();
        if (instance != null) {
            this.add(instance);
            return true;
        }
        return false;
    }

    public String relationName() {
        return this.m_RelationName;
    }

    public void renameAttribute(int n, String string) {
        Attribute attribute = this.attribute(n).copy(string);
        FastVector fastVector = new FastVector(this.numAttributes());
        for (int i = 0; i < this.numAttributes(); ++i) {
            if (i == n) {
                fastVector.addElement(attribute);
                continue;
            }
            fastVector.addElement(this.attribute(i));
        }
        this.m_Attributes = fastVector;
    }

    public void renameAttribute(Attribute attribute, String string) {
        this.renameAttribute(attribute.index(), string);
    }

    public void renameAttributeValue(int n, int n2, String string) {
        Attribute attribute = (Attribute)this.attribute(n).copy();
        FastVector fastVector = new FastVector(this.numAttributes());
        attribute.setValue(n2, string);
        for (int i = 0; i < this.numAttributes(); ++i) {
            if (i == n) {
                fastVector.addElement(attribute);
                continue;
            }
            fastVector.addElement(this.attribute(i));
        }
        this.m_Attributes = fastVector;
    }

    public void renameAttributeValue(Attribute attribute, String string, String string2) {
        int n = attribute.indexOfValue(string);
        if (n == -1) {
            throw new IllegalArgumentException(string + " not found");
        }
        this.renameAttributeValue(attribute.index(), n, string2);
    }

    public Instances resample(Random random) {
        Instances instances = new Instances(this, this.numInstances());
        while (instances.numInstances() < this.numInstances()) {
            instances.add(this.instance(random.nextInt(this.numInstances())));
        }
        return instances;
    }

    public Instances resampleWithWeights(Random random) {
        double[] dArray = new double[this.numInstances()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.instance(i).weight();
        }
        return this.resampleWithWeights(random, dArray);
    }

    public Instances resampleWithWeights(Random random, double[] dArray) {
        int n;
        if (dArray.length != this.numInstances()) {
            throw new IllegalArgumentException("weights.length != numInstances.");
        }
        Instances instances = new Instances(this, this.numInstances());
        if (this.numInstances() == 0) {
            return instances;
        }
        double[] dArray2 = new double[this.numInstances()];
        double d = 0.0;
        double d2 = Utils.sum(dArray);
        for (n = 0; n < this.numInstances(); ++n) {
            dArray2[n] = d += random.nextDouble();
        }
        Utils.normalize(dArray2, d / d2);
        dArray2[this.numInstances() - 1] = d2;
        n = 0;
        d = 0.0;
        for (int i = 0; n < this.numInstances() && i < this.numInstances(); ++i) {
            if (dArray[i] < 0.0) {
                throw new IllegalArgumentException("Weights have to be positive.");
            }
            d += dArray[i];
            while (n < this.numInstances() && dArray2[n] <= d) {
                instances.add(this.instance(i));
                instances.instance(n).setWeight(1.0);
                ++n;
            }
        }
        return instances;
    }

    public void setClass(Attribute attribute) {
        this.m_ClassIndex = attribute.index();
    }

    public void setClassIndex(int n) {
        if (n >= this.numAttributes()) {
            throw new IllegalArgumentException("Invalid class index: " + n);
        }
        this.m_ClassIndex = n;
    }

    public void setRelationName(String string) {
        this.m_RelationName = string;
    }

    public void sort(int n) {
        int n2 = this.numInstances() - 1;
        int n3 = 0;
        while (n3 <= n2) {
            if (this.instance(n2).isMissing(n)) {
                --n2;
                continue;
            }
            if (this.instance(n3).isMissing(n)) {
                this.swap(n3, n2);
                --n2;
            }
            ++n3;
        }
        this.quickSort(n, 0, n2);
    }

    public void sort(Attribute attribute) {
        this.sort(attribute.index());
    }

    public void stratify(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Number of folds must be greater than 1");
        }
        if (this.m_ClassIndex < 0) {
            throw new UnassignedClassException("Class index is negative (not set)!");
        }
        if (this.classAttribute().isNominal()) {
            for (int i = 1; i < this.numInstances(); ++i) {
                Instance instance = this.instance(i - 1);
                for (int j = i; j < this.numInstances(); ++j) {
                    Instance instance2 = this.instance(j);
                    if (instance.classValue() != instance2.classValue() && (!instance.classIsMissing() || !instance2.classIsMissing())) continue;
                    this.swap(i, j);
                    ++i;
                }
            }
            this.stratStep(n);
        }
    }

    public double sumOfWeights() {
        double d = 0.0;
        for (int i = 0; i < this.numInstances(); ++i) {
            d += this.instance(i).weight();
        }
        return d;
    }

    public Instances testCV(int n, int n2) {
        int n3;
        if (n < 2) {
            throw new IllegalArgumentException("Number of folds must be at least 2!");
        }
        if (n > this.numInstances()) {
            throw new IllegalArgumentException("Can't have more folds than instances!");
        }
        int n4 = this.numInstances() / n;
        if (n2 < this.numInstances() % n) {
            ++n4;
            n3 = n2;
        } else {
            n3 = this.numInstances() % n;
        }
        Instances instances = new Instances(this, n4);
        int n5 = n2 * (this.numInstances() / n) + n3;
        this.copyInstances(n5, instances, n4);
        return instances;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ARFF_RELATION).append(" ").append(Utils.quote(this.m_RelationName)).append("\n\n");
        for (int i = 0; i < this.numAttributes(); ++i) {
            stringBuffer.append(this.attribute(i)).append("\n");
        }
        stringBuffer.append("\n").append(ARFF_DATA).append("\n");
        stringBuffer.append(this.stringWithoutHeader());
        return stringBuffer.toString();
    }

    protected String stringWithoutHeader() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.numInstances(); ++i) {
            stringBuffer.append(this.instance(i));
            if (i >= this.numInstances() - 1) continue;
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public Instances trainCV(int n, int n2) {
        int n3;
        if (n < 2) {
            throw new IllegalArgumentException("Number of folds must be at least 2!");
        }
        if (n > this.numInstances()) {
            throw new IllegalArgumentException("Can't have more folds than instances!");
        }
        int n4 = this.numInstances() / n;
        if (n2 < this.numInstances() % n) {
            ++n4;
            n3 = n2;
        } else {
            n3 = this.numInstances() % n;
        }
        Instances instances = new Instances(this, this.numInstances() - n4);
        int n5 = n2 * (this.numInstances() / n) + n3;
        this.copyInstances(0, instances, n5);
        this.copyInstances(n5 + n4, instances, this.numInstances() - n5 - n4);
        return instances;
    }

    public Instances trainCV(int n, int n2, Random random) {
        Instances instances = this.trainCV(n, n2);
        instances.randomize(random);
        return instances;
    }

    public double variance(int n) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        if (!this.attribute(n).isNumeric()) {
            throw new IllegalArgumentException("Can't compute variance because attribute is not numeric!");
        }
        for (int i = 0; i < this.numInstances(); ++i) {
            if (this.instance(i).isMissing(n)) continue;
            d += this.instance(i).weight() * this.instance(i).value(n);
            d2 += this.instance(i).weight() * this.instance(i).value(n) * this.instance(i).value(n);
            d3 += this.instance(i).weight();
        }
        if (d3 <= 1.0) {
            return 0.0;
        }
        double d4 = (d2 - d * d / d3) / (d3 - 1.0);
        if (d4 < 0.0) {
            return 0.0;
        }
        return d4;
    }

    public double variance(Attribute attribute) {
        return this.variance(attribute.index());
    }

    public AttributeStats attributeStats(int n) {
        AttributeStats attributeStats = new AttributeStats();
        if (this.attribute(n).isNominal()) {
            attributeStats.nominalCounts = new int[this.attribute(n).numValues()];
        }
        if (this.attribute(n).isNumeric()) {
            attributeStats.numericStats = new Stats();
        }
        attributeStats.totalCount = this.numInstances();
        double[] dArray = this.attributeToDoubleArray(n);
        int[] nArray = Utils.sort(dArray);
        int n2 = 0;
        double d = Instance.missingValue();
        for (int i = 0; i < this.numInstances(); ++i) {
            Instance instance = this.instance(nArray[i]);
            if (instance.isMissing(n)) {
                attributeStats.missingCount = this.numInstances() - i;
                break;
            }
            if (instance.value(n) == d) {
                ++n2;
                continue;
            }
            attributeStats.addDistinct(d, n2);
            n2 = 1;
            d = instance.value(n);
        }
        attributeStats.addDistinct(d, n2);
        --attributeStats.distinctCount;
        return attributeStats;
    }

    public double[] attributeToDoubleArray(int n) {
        double[] dArray = new double[this.numInstances()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.instance(i).value(n);
        }
        return dArray;
    }

    public String toSummaryString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Relation Name:  ").append(this.relationName()).append('\n');
        stringBuffer.append("Num Instances:  ").append(this.numInstances()).append('\n');
        stringBuffer.append("Num Attributes: ").append(this.numAttributes()).append('\n');
        stringBuffer.append('\n');
        stringBuffer.append(Utils.padLeft("", 5)).append(Utils.padRight("Name", 25));
        stringBuffer.append(Utils.padLeft("Type", 5)).append(Utils.padLeft("Nom", 5));
        stringBuffer.append(Utils.padLeft("Int", 5)).append(Utils.padLeft("Real", 5));
        stringBuffer.append(Utils.padLeft("Missing", 12));
        stringBuffer.append(Utils.padLeft("Unique", 12));
        stringBuffer.append(Utils.padLeft("Dist", 6)).append('\n');
        for (int i = 0; i < this.numAttributes(); ++i) {
            long l;
            Attribute attribute = this.attribute(i);
            AttributeStats attributeStats = this.attributeStats(i);
            stringBuffer.append(Utils.padLeft("" + (i + 1), 4)).append(' ');
            stringBuffer.append(Utils.padRight(attribute.name(), 25)).append(' ');
            switch (attribute.type()) {
                case 1: {
                    stringBuffer.append(Utils.padLeft("Nom", 4)).append(' ');
                    l = Math.round(100.0 * (double)attributeStats.intCount / (double)attributeStats.totalCount);
                    stringBuffer.append(Utils.padLeft("" + l, 3)).append("% ");
                    stringBuffer.append(Utils.padLeft("0", 3)).append("% ");
                    l = Math.round(100.0 * (double)attributeStats.realCount / (double)attributeStats.totalCount);
                    stringBuffer.append(Utils.padLeft("" + l, 3)).append("% ");
                    break;
                }
                case 0: {
                    stringBuffer.append(Utils.padLeft("Num", 4)).append(' ');
                    stringBuffer.append(Utils.padLeft("0", 3)).append("% ");
                    l = Math.round(100.0 * (double)attributeStats.intCount / (double)attributeStats.totalCount);
                    stringBuffer.append(Utils.padLeft("" + l, 3)).append("% ");
                    l = Math.round(100.0 * (double)attributeStats.realCount / (double)attributeStats.totalCount);
                    stringBuffer.append(Utils.padLeft("" + l, 3)).append("% ");
                    break;
                }
                case 3: {
                    stringBuffer.append(Utils.padLeft("Dat", 4)).append(' ');
                    stringBuffer.append(Utils.padLeft("0", 3)).append("% ");
                    l = Math.round(100.0 * (double)attributeStats.intCount / (double)attributeStats.totalCount);
                    stringBuffer.append(Utils.padLeft("" + l, 3)).append("% ");
                    l = Math.round(100.0 * (double)attributeStats.realCount / (double)attributeStats.totalCount);
                    stringBuffer.append(Utils.padLeft("" + l, 3)).append("% ");
                    break;
                }
                case 2: {
                    stringBuffer.append(Utils.padLeft("Str", 4)).append(' ');
                    l = Math.round(100.0 * (double)attributeStats.intCount / (double)attributeStats.totalCount);
                    stringBuffer.append(Utils.padLeft("" + l, 3)).append("% ");
                    stringBuffer.append(Utils.padLeft("0", 3)).append("% ");
                    l = Math.round(100.0 * (double)attributeStats.realCount / (double)attributeStats.totalCount);
                    stringBuffer.append(Utils.padLeft("" + l, 3)).append("% ");
                    break;
                }
                case 4: {
                    stringBuffer.append(Utils.padLeft("Rel", 4)).append(' ');
                    l = Math.round(100.0 * (double)attributeStats.intCount / (double)attributeStats.totalCount);
                    stringBuffer.append(Utils.padLeft("" + l, 3)).append("% ");
                    stringBuffer.append(Utils.padLeft("0", 3)).append("% ");
                    l = Math.round(100.0 * (double)attributeStats.realCount / (double)attributeStats.totalCount);
                    stringBuffer.append(Utils.padLeft("" + l, 3)).append("% ");
                    break;
                }
                default: {
                    stringBuffer.append(Utils.padLeft("???", 4)).append(' ');
                    stringBuffer.append(Utils.padLeft("0", 3)).append("% ");
                    l = Math.round(100.0 * (double)attributeStats.intCount / (double)attributeStats.totalCount);
                    stringBuffer.append(Utils.padLeft("" + l, 3)).append("% ");
                    l = Math.round(100.0 * (double)attributeStats.realCount / (double)attributeStats.totalCount);
                    stringBuffer.append(Utils.padLeft("" + l, 3)).append("% ");
                }
            }
            stringBuffer.append(Utils.padLeft("" + attributeStats.missingCount, 5)).append(" /");
            l = Math.round(100.0 * (double)attributeStats.missingCount / (double)attributeStats.totalCount);
            stringBuffer.append(Utils.padLeft("" + l, 3)).append("% ");
            stringBuffer.append(Utils.padLeft("" + attributeStats.uniqueCount, 5)).append(" /");
            l = Math.round(100.0 * (double)attributeStats.uniqueCount / (double)attributeStats.totalCount);
            stringBuffer.append(Utils.padLeft("" + l, 3)).append("% ");
            stringBuffer.append(Utils.padLeft("" + attributeStats.distinctCount, 5)).append(' ');
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    protected void copyInstances(int n, Instances instances, int n2) {
        for (int i = 0; i < n2; ++i) {
            instances.add(this.instance(n + i));
        }
    }

    protected void freshAttributeInfo() {
        this.m_Attributes = (FastVector)this.m_Attributes.copyElements();
    }

    protected String instancesAndWeights() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.numInstances(); ++i) {
            stringBuffer.append(this.instance(i) + " " + this.instance(i).weight());
            if (i >= this.numInstances() - 1) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    protected int partition(int n, int n2, int n3) {
        double d = this.instance((n2 + n3) / 2).value(n);
        while (n2 < n3) {
            while (this.instance(n2).value(n) < d && n2 < n3) {
                ++n2;
            }
            while (this.instance(n3).value(n) > d && n2 < n3) {
                --n3;
            }
            if (n2 >= n3) continue;
            this.swap(n2, n3);
            ++n2;
            --n3;
        }
        if (n2 == n3 && this.instance(n3).value(n) > d) {
            --n3;
        }
        return n3;
    }

    protected void quickSort(int n, int n2, int n3) {
        if (n2 < n3) {
            int n4 = this.partition(n, n2, n3);
            this.quickSort(n, n2, n4);
            this.quickSort(n, n4 + 1, n3);
        }
    }

    protected int select(int n, int n2, int n3, int n4) {
        if (n2 == n3) {
            return n2;
        }
        int n5 = this.partition(n, n2, n3);
        if (n5 - n2 + 1 >= n4) {
            return this.select(n, n2, n5, n4);
        }
        return this.select(n, n5 + 1, n3, n4 - (n5 - n2 + 1));
    }

    protected void stratStep(int n) {
        FastVector fastVector = new FastVector(this.m_Instances.capacity());
        int n2 = 0;
        while (fastVector.size() < this.numInstances()) {
            for (int i = n2; i < this.numInstances(); i += n) {
                fastVector.addElement(this.instance(i));
            }
            ++n2;
        }
        this.m_Instances = fastVector;
    }

    public void swap(int n, int n2) {
        this.m_Instances.swap(n, n2);
    }

    public static Instances mergeInstances(Instances instances, Instances instances2) {
        int n;
        if (instances.numInstances() != instances2.numInstances()) {
            throw new IllegalArgumentException("Instance sets must be of the same size");
        }
        FastVector fastVector = new FastVector();
        for (n = 0; n < instances.numAttributes(); ++n) {
            fastVector.addElement(instances.attribute(n));
        }
        for (n = 0; n < instances2.numAttributes(); ++n) {
            fastVector.addElement(instances2.attribute(n));
        }
        Instances instances3 = new Instances(instances.relationName() + '_' + instances2.relationName(), fastVector, instances.numInstances());
        for (int i = 0; i < instances.numInstances(); ++i) {
            instances3.add(instances.instance(i).mergeInstance(instances2.instance(i)));
        }
        return instances3;
    }

    public static void test(String[] stringArray) {
        Random random = new Random(2L);
        try {
            int n;
            int n2;
            Object object;
            if (stringArray.length > 1) {
                throw new Exception("Usage: Instances [<filename>]");
            }
            FastVector fastVector = new FastVector(2);
            fastVector.addElement("first_value");
            fastVector.addElement("second_value");
            FastVector fastVector2 = new FastVector(2);
            fastVector2.addElement(new Attribute("nominal_attribute", fastVector));
            fastVector2.addElement(new Attribute("numeric_attribute"));
            Instances instances = new Instances("test_set", fastVector2, 10);
            instances.add(new Instance(instances.numAttributes()));
            instances.add(new Instance(instances.numAttributes()));
            instances.add(new Instance(instances.numAttributes()));
            instances.setClassIndex(0);
            System.out.println("\nSet of instances created from scratch:\n");
            System.out.println(instances);
            if (stringArray.length == 1) {
                object = stringArray[0];
                FileReader fileReader = new FileReader((String)object);
                System.out.println("\nFirst five instances from file:\n");
                instances = new Instances(fileReader, 1);
                instances.setClassIndex(instances.numAttributes() - 1);
                for (n2 = 0; n2 < 5 && instances.readInstance(fileReader); ++n2) {
                }
                System.out.println(instances);
                fileReader = new FileReader((String)object);
                instances = new Instances(fileReader);
                instances.setClassIndex(instances.numAttributes() - 1);
                System.out.println("\nDataset:\n");
                System.out.println(instances);
                System.out.println("\nClass index: " + instances.classIndex());
            }
            System.out.println("\nClass name: " + instances.classAttribute().name());
            System.out.println("\nClass index: " + instances.classIndex());
            System.out.println("\nClass is nominal: " + instances.classAttribute().isNominal());
            System.out.println("\nClass is numeric: " + instances.classAttribute().isNumeric());
            System.out.println("\nClasses:\n");
            for (n2 = 0; n2 < instances.numClasses(); ++n2) {
                System.out.println(instances.classAttribute().value(n2));
            }
            System.out.println("\nClass values and labels of instances:\n");
            for (n2 = 0; n2 < instances.numInstances(); ++n2) {
                object = instances.instance(n2);
                System.out.print(((Instance)object).classValue() + "\t");
                System.out.print(((Instance)object).toString(((Instance)object).classIndex()));
                if (instances.instance(n2).classIsMissing()) {
                    System.out.println("\tis missing");
                    continue;
                }
                System.out.println();
            }
            System.out.println("\nCreating random weights for instances.");
            for (n2 = 0; n2 < instances.numInstances(); ++n2) {
                instances.instance(n2).setWeight(random.nextDouble());
            }
            System.out.println("\nInstances and their weights:\n");
            System.out.println(instances.instancesAndWeights());
            System.out.print("\nSum of weights: ");
            System.out.println(instances.sumOfWeights());
            Instances instances2 = new Instances(instances);
            object = new Attribute("Inserted");
            instances2.insertAttributeAt((Attribute)object, 0);
            System.out.println("\nSet with inserted attribute:\n");
            System.out.println(instances2);
            System.out.println("\nClass name: " + instances2.classAttribute().name());
            instances2.deleteAttributeAt(0);
            System.out.println("\nSet with attribute deleted:\n");
            System.out.println(instances2);
            System.out.println("\nClass name: " + instances2.classAttribute().name());
            System.out.println("\nHeaders equal: " + instances.equalHeaders(instances2) + "\n");
            System.out.println("\nData (internal values):\n");
            for (n2 = 0; n2 < instances.numInstances(); ++n2) {
                for (n = 0; n < instances.numAttributes(); ++n) {
                    if (instances.instance(n2).isMissing(n)) {
                        System.out.print("? ");
                        continue;
                    }
                    System.out.print(instances.instance(n2).value(n) + " ");
                }
                System.out.println();
            }
            System.out.println("\nEmpty dataset:\n");
            Instances instances3 = new Instances(instances, 0);
            System.out.println(instances3);
            System.out.println("\nClass name: " + instances3.classAttribute().name());
            if (instances3.classAttribute().isNominal()) {
                Instances instances4 = new Instances(instances3, 0);
                instances4.renameAttribute(instances4.classAttribute(), "new_name");
                instances4.renameAttributeValue(instances4.classAttribute(), instances4.classAttribute().value(0), "new_val_name");
                System.out.println("\nDataset with names changed:\n" + instances4);
                System.out.println("\nOriginal dataset:\n" + instances3);
            }
            int n3 = instances.numInstances() / 4;
            int n4 = instances.numInstances() / 2;
            System.out.print("\nSubset of dataset: ");
            System.out.println(n4 + " instances from " + (n3 + 1) + ". instance");
            instances2 = new Instances(instances, n3, n4);
            System.out.println("\nClass name: " + instances2.classAttribute().name());
            System.out.println("\nInstances and their weights:\n");
            System.out.println(instances2.instancesAndWeights());
            System.out.print("\nSum of weights: ");
            System.out.println(instances2.sumOfWeights());
            System.out.println("\nTrain and test folds for 3-fold CV:");
            if (instances.classAttribute().isNominal()) {
                instances.stratify(3);
            }
            for (n = 0; n < 3; ++n) {
                Instances instances5 = instances.trainCV(3, n, new Random(1L));
                Instances instances6 = instances.testCV(3, n);
                System.out.println("\nTrain: ");
                System.out.println("\nInstances and their weights:\n");
                System.out.println(instances5.instancesAndWeights());
                System.out.print("\nSum of weights: ");
                System.out.println(instances5.sumOfWeights());
                System.out.println("\nClass name: " + instances5.classAttribute().name());
                System.out.println("\nTest: ");
                System.out.println("\nInstances and their weights:\n");
                System.out.println(instances6.instancesAndWeights());
                System.out.print("\nSum of weights: ");
                System.out.println(instances6.sumOfWeights());
                System.out.println("\nClass name: " + instances6.classAttribute().name());
            }
            System.out.println("\nRandomized dataset:");
            instances.randomize(random);
            System.out.println("\nInstances and their weights:\n");
            System.out.println(instances.instancesAndWeights());
            System.out.print("\nSum of weights: ");
            System.out.println(instances.sumOfWeights());
            System.out.print("\nInstances sorted according to first attribute:\n ");
            instances.sort(0);
            System.out.println("\nInstances and their weights:\n");
            System.out.println(instances.instancesAndWeights());
            System.out.print("\nSum of weights: ");
            System.out.println(instances.sumOfWeights());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                ConverterUtils.DataSource dataSource = new ConverterUtils.DataSource(System.in);
                Instances instances = dataSource.getDataSet();
                System.out.println(instances.toSummaryString());
            } else if (stringArray.length == 1 && !stringArray[0].equals("-h") && !stringArray[0].equals("help")) {
                ConverterUtils.DataSource dataSource = new ConverterUtils.DataSource(stringArray[0]);
                Instances instances = dataSource.getDataSet();
                System.out.println(instances.toSummaryString());
            } else if (stringArray.length == 3 && stringArray[0].toLowerCase().equals("merge")) {
                ConverterUtils.DataSource dataSource = new ConverterUtils.DataSource(stringArray[1]);
                ConverterUtils.DataSource dataSource2 = new ConverterUtils.DataSource(stringArray[2]);
                Instances instances = Instances.mergeInstances(dataSource.getDataSet(), dataSource2.getDataSet());
                System.out.println(instances);
            } else if (stringArray.length == 3 && stringArray[0].toLowerCase().equals("append")) {
                ConverterUtils.DataSource dataSource = new ConverterUtils.DataSource(stringArray[1]);
                ConverterUtils.DataSource dataSource3 = new ConverterUtils.DataSource(stringArray[2]);
                if (!dataSource.getStructure().equalHeaders(dataSource3.getStructure())) {
                    throw new Exception("The two datasets have different headers!");
                }
                Instances instances = dataSource.getStructure();
                System.out.println(dataSource.getStructure());
                while (dataSource.hasMoreElements(instances)) {
                    System.out.println(dataSource.nextElement(instances));
                }
                instances = dataSource3.getStructure();
                while (dataSource3.hasMoreElements(instances)) {
                    System.out.println(dataSource3.nextElement(instances));
                }
            } else if (stringArray.length == 3 && stringArray[0].toLowerCase().equals("randomize")) {
                ConverterUtils.DataSource dataSource = new ConverterUtils.DataSource(stringArray[2]);
                Instances instances = dataSource.getDataSet();
                instances.randomize(new Random(Integer.parseInt(stringArray[1])));
                System.out.println(instances);
            } else {
                System.err.println("\nUsage:\n\tweka.core.Instances help\n\tweka.core.Instances <filename>\n\tweka.core.Instances merge <filename1> <filename2>\n\tweka.core.Instances append <filename1> <filename2>\n\tweka.core.Instances randomize <seed> <filename>\n");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

