/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Serializable;
import weka.core.Attribute;
import weka.core.AttributeLocator;
import weka.core.Instance;
import weka.core.Instances;

public class RelationalLocator
extends AttributeLocator {
    private static final long serialVersionUID = 4646872277151854732L;

    public RelationalLocator(Instances instances) {
        super(instances, 4);
    }

    public RelationalLocator(Instances instances, int n, int n2) {
        super(instances, 4, n, n2);
    }

    public RelationalLocator(Instances instances, int[] nArray) {
        super(instances, 4, nArray);
    }

    public static void copyRelationalValues(Instance instance, Instances instances, AttributeLocator attributeLocator) {
        if (instance.dataset() == null) {
            throw new IllegalArgumentException("Instance has no dataset assigned!!");
        }
        if (instance.dataset().numAttributes() != instances.numAttributes()) {
            throw new IllegalArgumentException("Src and Dest differ in # of attributes!!");
        }
        RelationalLocator.copyRelationalValues(instance, true, instance.dataset(), attributeLocator, instances, attributeLocator);
    }

    public static void copyRelationalValues(Instance instance, boolean bl, Instances instances, AttributeLocator attributeLocator, Instances instances2, AttributeLocator attributeLocator2) {
        Serializable serializable;
        if (instances == instances2) {
            return;
        }
        if (attributeLocator.getAttributeIndices().length != attributeLocator2.getAttributeIndices().length) {
            throw new IllegalArgumentException("Src and Dest relational indices differ in length!!");
        }
        if (attributeLocator.getLocatorIndices().length != attributeLocator2.getLocatorIndices().length) {
            throw new IllegalArgumentException("Src and Dest locator indices differ in length!!");
        }
        for (int i = 0; i < attributeLocator.getAttributeIndices().length; ++i) {
            int n = bl ? attributeLocator.getActualIndex(attributeLocator.getAttributeIndices()[i]) : attributeLocator2.getActualIndex(attributeLocator2.getAttributeIndices()[i]);
            Attribute attribute = instances.attribute(attributeLocator.getActualIndex(attributeLocator.getAttributeIndices()[i]));
            serializable = instances2.attribute(attributeLocator2.getActualIndex(attributeLocator2.getAttributeIndices()[i]));
            if (instance.isMissing(n)) continue;
            int n2 = ((Attribute)serializable).addRelation(attribute.relation((int)instance.value(n)));
            instance.setValue(n, (double)n2);
        }
        int[] nArray = attributeLocator.getLocatorIndices();
        int[] nArray2 = attributeLocator2.getLocatorIndices();
        for (int i = 0; i < nArray.length; ++i) {
            serializable = bl ? instance.relationalValue(attributeLocator.getActualIndex(nArray[i])) : instance.relationalValue(attributeLocator2.getActualIndex(nArray2[i]));
            AttributeLocator attributeLocator3 = attributeLocator.getLocator(nArray[i]);
            Instances instances3 = attributeLocator3.getData();
            AttributeLocator attributeLocator4 = attributeLocator2.getLocator(nArray2[i]);
            Instances instances4 = attributeLocator4.getData();
            for (int j = 0; j < ((Instances)serializable).numInstances(); ++j) {
                RelationalLocator.copyRelationalValues(((Instances)serializable).instance(j), bl, instances3, attributeLocator3, instances4, attributeLocator4);
            }
        }
    }
}

