/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class SimpleLinearRegression
extends Classifier
implements WeightedInstancesHandler {
    static final long serialVersionUID = 1679336022895414137L;
    private Attribute m_attribute;
    private int m_attributeIndex;
    private double m_slope;
    private double m_intercept;
    private boolean m_suppressErrorMessage = false;

    public String globalInfo() {
        return "Learns a simple linear regression model. Picks the attribute that results in the lowest squared error. Missing values are not allowed. Can only deal with numeric attributes.";
    }

    public double classifyInstance(Instance instance) throws Exception {
        if (this.m_attribute == null) {
            return this.m_intercept;
        }
        if (instance.isMissing(this.m_attribute.index())) {
            throw new Exception("SimpleLinearRegression: No missing values!");
        }
        return this.m_intercept + this.m_slope * instance.value(this.m_attribute.index());
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_CLASS);
        capabilities.enable(Capabilities.Capability.DATE_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        double d = instances.meanOrMode(instances.classIndex());
        double d2 = Double.MAX_VALUE;
        this.m_attribute = null;
        int n = -1;
        double d3 = Double.NaN;
        double d4 = Double.NaN;
        for (int i = 0; i < instances.numAttributes(); ++i) {
            double d5;
            if (i == instances.classIndex()) continue;
            this.m_attribute = instances.attribute(i);
            double d6 = instances.meanOrMode(i);
            double d7 = 0.0;
            double d8 = 0.0;
            this.m_slope = 0.0;
            for (int j = 0; j < instances.numInstances(); ++j) {
                Instance instance = instances.instance(j);
                if (instance.isMissing(i) || instance.classIsMissing()) continue;
                d5 = instance.value(i) - d6;
                double d9 = instance.classValue() - d;
                double d10 = instance.weight() * d5;
                double d11 = instance.weight() * d9;
                this.m_slope += d10 * d9;
                d7 += d10 * d5;
                d8 += d11 * d9;
            }
            if (d7 == 0.0) continue;
            double d12 = this.m_slope;
            this.m_slope /= d7;
            this.m_intercept = d - this.m_slope * d6;
            d5 = d8 - this.m_slope * d12;
            if (!(d5 < d2)) continue;
            d2 = d5;
            n = i;
            d3 = this.m_slope;
            d4 = this.m_intercept;
        }
        if (n == -1) {
            if (!this.m_suppressErrorMessage) {
                System.err.println("----- no useful attribute found");
            }
            this.m_attribute = null;
            this.m_attributeIndex = 0;
            this.m_slope = 0.0;
            this.m_intercept = d;
        } else {
            this.m_attribute = instances.attribute(n);
            this.m_attributeIndex = n;
            this.m_slope = d3;
            this.m_intercept = d4;
        }
    }

    public boolean foundUsefulAttribute() {
        return this.m_attribute != null;
    }

    public int getAttributeIndex() {
        return this.m_attributeIndex;
    }

    public double getSlope() {
        return this.m_slope;
    }

    public double getIntercept() {
        return this.m_intercept;
    }

    public void setSuppressErrorMessage(boolean bl) {
        this.m_suppressErrorMessage = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_attribute == null) {
            stringBuffer.append("Predicting constant " + this.m_intercept);
        } else {
            stringBuffer.append("Linear regression on " + this.m_attribute.name() + "\n\n");
            stringBuffer.append(Utils.doubleToString(this.m_slope, 2) + " * " + this.m_attribute.name());
            if (this.m_intercept > 0.0) {
                stringBuffer.append(" + " + Utils.doubleToString(this.m_intercept, 2));
            } else {
                stringBuffer.append(" - " + Utils.doubleToString(-this.m_intercept, 2));
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new SimpleLinearRegression(), stringArray));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }
}

