/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.StartSetHandler;
import weka.attributeSelection.SubsetEvaluator;
import weka.attributeSelection.UnsupervisedSubsetEvaluator;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class GeneticSearch
extends ASSearch
implements StartSetHandler,
OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -1618264232838472679L;
    private int[] m_starting;
    private Range m_startRange;
    private boolean m_hasClass;
    private int m_classIndex;
    private int m_numAttribs;
    private GABitSet[] m_population;
    private int m_popSize;
    private GABitSet m_best;
    private int m_bestFeatureCount;
    private int m_lookupTableSize;
    private Hashtable m_lookupTable;
    private Random m_random;
    private int m_seed;
    private double m_pCrossover;
    private double m_pMutation;
    private double m_sumFitness;
    private double m_maxFitness;
    private double m_minFitness;
    private double m_avgFitness;
    private int m_maxGenerations;
    private int m_reportFrequency;
    private StringBuffer m_generationReports;

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(6);
        vector.addElement(new Option("\tSpecify a starting set of attributes.\n\tEg. 1,3,5-7.If supplied, the starting set becomes\n\tone member of the initial random\n\tpopulation.", "P", 1, "-P <start set>"));
        vector.addElement(new Option("\tSet the size of the population.\n\t(default = 10).", "Z", 1, "-Z <population size>"));
        vector.addElement(new Option("\tSet the number of generations.\n\t(default = 20)", "G", 1, "-G <number of generations>"));
        vector.addElement(new Option("\tSet the probability of crossover.\n\t(default = 0.6)", "C", 1, "-C <probability of crossover>"));
        vector.addElement(new Option("\tSet the probability of mutation.\n\t(default = 0.033)", "M", 1, "-M <probability of mutation>"));
        vector.addElement(new Option("\tSet frequency of generation reports.\n\te.g, setting the value to 5 will \n\t report every 5th generation\n\t(default = number of generations)", "R", 1, "-R <report frequency>"));
        vector.addElement(new Option("\tSet the random number seed.\n\t(default = 1)", "S", 1, "-S <seed>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.resetOptions();
        String string = Utils.getOption('P', stringArray);
        if (string.length() != 0) {
            this.setStartSet(string);
        }
        if ((string = Utils.getOption('Z', stringArray)).length() != 0) {
            this.setPopulationSize(Integer.parseInt(string));
        }
        if ((string = Utils.getOption('G', stringArray)).length() != 0) {
            this.setMaxGenerations(Integer.parseInt(string));
            this.setReportFrequency(Integer.parseInt(string));
        }
        if ((string = Utils.getOption('C', stringArray)).length() != 0) {
            this.setCrossoverProb(new Double(string));
        }
        if ((string = Utils.getOption('M', stringArray)).length() != 0) {
            this.setMutationProb(new Double(string));
        }
        if ((string = Utils.getOption('R', stringArray)).length() != 0) {
            this.setReportFrequency(Integer.parseInt(string));
        }
        if ((string = Utils.getOption('S', stringArray)).length() != 0) {
            this.setSeed(Integer.parseInt(string));
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[14];
        int n = 0;
        if (!this.getStartSet().equals("")) {
            stringArray[n++] = "-P";
            stringArray[n++] = "" + this.startSetToString();
        }
        stringArray[n++] = "-Z";
        stringArray[n++] = "" + this.getPopulationSize();
        stringArray[n++] = "-G";
        stringArray[n++] = "" + this.getMaxGenerations();
        stringArray[n++] = "-C";
        stringArray[n++] = "" + this.getCrossoverProb();
        stringArray[n++] = "-M";
        stringArray[n++] = "" + this.getMutationProb();
        stringArray[n++] = "-R";
        stringArray[n++] = "" + this.getReportFrequency();
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.getSeed();
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String startSetTipText() {
        return "Set a start point for the search. This is specified as a comma seperated list off attribute indexes starting at 1. It can include ranges. Eg. 1,2,5-9,17. The start set becomes one of the population members of the initial population.";
    }

    public void setStartSet(String string) throws Exception {
        this.m_startRange.setRanges(string);
    }

    public String getStartSet() {
        return this.m_startRange.getRanges();
    }

    public String seedTipText() {
        return "Set the random seed.";
    }

    public void setSeed(int n) {
        this.m_seed = n;
    }

    public int getSeed() {
        return this.m_seed;
    }

    public String reportFrequencyTipText() {
        return "Set how frequently reports are generated. Default is equal to the number of generations meaning that a report will be printed for initial and final generations. Setting the value to 5 will result in a report being printed every 5 generations.";
    }

    public void setReportFrequency(int n) {
        this.m_reportFrequency = n;
    }

    public int getReportFrequency() {
        return this.m_reportFrequency;
    }

    public String mutationProbTipText() {
        return "Set the probability of mutation occuring.";
    }

    public void setMutationProb(double d) {
        this.m_pMutation = d;
    }

    public double getMutationProb() {
        return this.m_pMutation;
    }

    public String crossoverProbTipText() {
        return "Set the probability of crossover. This is the probability that two population members will exchange genetic material.";
    }

    public void setCrossoverProb(double d) {
        this.m_pCrossover = d;
    }

    public double getCrossoverProb() {
        return this.m_pCrossover;
    }

    public String maxGenerationsTipText() {
        return "Set the number of generations to evaluate.";
    }

    public void setMaxGenerations(int n) {
        this.m_maxGenerations = n;
    }

    public int getMaxGenerations() {
        return this.m_maxGenerations;
    }

    public String populationSizeTipText() {
        return "Set the population size. This is the number of individuals (attribute sets) in the population.";
    }

    public void setPopulationSize(int n) {
        this.m_popSize = n;
    }

    public int getPopulationSize() {
        return this.m_popSize;
    }

    public String globalInfo() {
        return "GeneticSearch:\n\nPerforms a search using the simple genetic algorithm described in Goldberg (1989).\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.BOOK);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "David E. Goldberg");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1989");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Genetic algorithms in search, optimization and machine learning");
        technicalInformation.setValue(TechnicalInformation.Field.ISBN, "0201157675");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "Addison-Wesley");
        return technicalInformation;
    }

    public GeneticSearch() {
        this.resetOptions();
    }

    private String startSetToString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_starting == null) {
            return this.getStartSet();
        }
        for (int i = 0; i < this.m_starting.length; ++i) {
            boolean bl = false;
            if (!this.m_hasClass || this.m_hasClass && i != this.m_classIndex) {
                stringBuffer.append(this.m_starting[i] + 1);
                bl = true;
            }
            if (i == this.m_starting.length - 1) {
                stringBuffer.append("");
                continue;
            }
            if (!bl) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\tGenetic search.\n\tStart set: ");
        if (this.m_starting == null) {
            stringBuffer.append("no attributes\n");
        } else {
            stringBuffer.append(this.startSetToString() + "\n");
        }
        stringBuffer.append("\tPopulation size: " + this.m_popSize);
        stringBuffer.append("\n\tNumber of generations: " + this.m_maxGenerations);
        stringBuffer.append("\n\tProbability of crossover: " + Utils.doubleToString(this.m_pCrossover, 6, 3));
        stringBuffer.append("\n\tProbability of mutation: " + Utils.doubleToString(this.m_pMutation, 6, 3));
        stringBuffer.append("\n\tReport frequency: " + this.m_reportFrequency);
        stringBuffer.append("\n\tRandom number seed: " + this.m_seed + "\n");
        stringBuffer.append(this.m_generationReports.toString());
        return stringBuffer.toString();
    }

    public int[] search(ASEvaluation aSEvaluation, Instances instances) throws Exception {
        this.m_best = null;
        this.m_generationReports = new StringBuffer();
        if (!(aSEvaluation instanceof SubsetEvaluator)) {
            throw new Exception(aSEvaluation.getClass().getName() + " is not a " + "Subset evaluator!");
        }
        if (aSEvaluation instanceof UnsupervisedSubsetEvaluator) {
            this.m_hasClass = false;
        } else {
            this.m_hasClass = true;
            this.m_classIndex = instances.classIndex();
        }
        SubsetEvaluator subsetEvaluator = (SubsetEvaluator)aSEvaluation;
        this.m_numAttribs = instances.numAttributes();
        this.m_startRange.setUpper(this.m_numAttribs - 1);
        if (!this.getStartSet().equals("")) {
            this.m_starting = this.m_startRange.getSelection();
        }
        this.m_lookupTable = new Hashtable(this.m_lookupTableSize);
        this.m_random = new Random(this.m_seed);
        this.m_population = new GABitSet[this.m_popSize];
        this.initPopulation();
        this.evaluatePopulation(subsetEvaluator);
        this.populationStatistics();
        this.scalePopulation();
        this.checkBest();
        this.m_generationReports.append(this.populationReport(0));
        for (int i = 1; i <= this.m_maxGenerations; ++i) {
            this.generation();
            this.evaluatePopulation(subsetEvaluator);
            this.populationStatistics();
            this.scalePopulation();
            boolean bl = this.checkBest();
            if (i != this.m_maxGenerations && i % this.m_reportFrequency != 0 && !bl) continue;
            this.m_generationReports.append(this.populationReport(i));
            if (bl) break;
        }
        return this.attributeList(this.m_best.getChromosome());
    }

    private int[] attributeList(BitSet bitSet) {
        int n = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bitSet.get(i)) continue;
            ++n;
        }
        int[] nArray = new int[n];
        n = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bitSet.get(i)) continue;
            nArray[n++] = i;
        }
        return nArray;
    }

    private boolean checkBest() throws Exception {
        BitSet bitSet;
        int n;
        int n2 = this.m_numAttribs;
        double d = -1.7976931348623157E308;
        GABitSet gABitSet = null;
        boolean bl = false;
        int n3 = Integer.MAX_VALUE;
        if (this.m_maxFitness - this.m_minFitness > 0.0) {
            for (int i = 0; i < this.m_popSize; ++i) {
                if (this.m_population[i].getObjective() > d) {
                    d = this.m_population[i].getObjective();
                    gABitSet = this.m_population[i];
                    n3 = this.countFeatures(gABitSet.getChromosome());
                    continue;
                }
                if (!Utils.eq(this.m_population[i].getObjective(), d) || (n = this.countFeatures(this.m_population[i].getChromosome())) >= n3) continue;
                d = this.m_population[i].getObjective();
                gABitSet = this.m_population[i];
                n3 = n;
            }
        } else {
            for (int i = 0; i < this.m_popSize; ++i) {
                bitSet = this.m_population[i].getChromosome();
                n = this.countFeatures(bitSet);
                if (n >= n2) continue;
                n2 = n;
                gABitSet = this.m_population[i];
                d = gABitSet.getObjective();
            }
            bl = true;
        }
        n = 0;
        bitSet = gABitSet.getChromosome();
        n = this.countFeatures(bitSet);
        if (this.m_best == null) {
            this.m_best = (GABitSet)gABitSet.clone();
            this.m_bestFeatureCount = n;
        } else if (d > this.m_best.getObjective()) {
            this.m_best = (GABitSet)gABitSet.clone();
            this.m_bestFeatureCount = n;
        } else if (Utils.eq(this.m_best.getObjective(), d) && n < this.m_bestFeatureCount) {
            this.m_best = (GABitSet)gABitSet.clone();
            this.m_bestFeatureCount = n;
        }
        return bl;
    }

    private int countFeatures(BitSet bitSet) {
        int n = 0;
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bitSet.get(i)) continue;
            ++n;
        }
        return n;
    }

    private void generation() throws Exception {
        int n;
        int n2 = 0;
        double d = -1.7976931348623157E308;
        int n3 = 0;
        GABitSet[] gABitSetArray = new GABitSet[this.m_popSize];
        for (n = 0; n < this.m_popSize; ++n) {
            int n4;
            if (this.m_population[n].getFitness() > d) {
                n2 = n;
                d = this.m_population[n].getFitness();
                n3 = this.countFeatures(this.m_population[n].getChromosome());
                continue;
            }
            if (!Utils.eq(this.m_population[n].getFitness(), d) || (n4 = this.countFeatures(this.m_population[n].getChromosome())) >= n3) continue;
            n2 = n;
            d = this.m_population[n].getFitness();
            n3 = n4;
        }
        gABitSetArray[0] = (GABitSet)this.m_population[n2].clone();
        gABitSetArray[1] = gABitSetArray[0];
        for (n2 = 2; n2 < this.m_popSize; n2 += 2) {
            int n5;
            int n6 = this.select();
            int n7 = this.select();
            gABitSetArray[n2] = (GABitSet)this.m_population[n6].clone();
            gABitSetArray[n2 + 1] = (GABitSet)this.m_population[n7].clone();
            if (n6 == n7) {
                int n8;
                if (this.m_hasClass) {
                    while ((n8 = Math.abs(this.m_random.nextInt()) % this.m_numAttribs) == this.m_classIndex) {
                    }
                } else {
                    n8 = this.m_random.nextInt() % this.m_numAttribs;
                }
                if (gABitSetArray[n2].get(n8)) {
                    gABitSetArray[n2].clear(n8);
                    continue;
                }
                gABitSetArray[n2].set(n8);
                continue;
            }
            double d2 = this.m_random.nextDouble();
            if (this.m_numAttribs >= 3 && d2 < this.m_pCrossover) {
                n5 = Math.abs(this.m_random.nextInt());
                n5 %= this.m_numAttribs - 2;
                ++n5;
                for (n = 0; n < n5; ++n) {
                    if (this.m_population[n6].get(n)) {
                        gABitSetArray[n2 + 1].set(n);
                    } else {
                        gABitSetArray[n2 + 1].clear(n);
                    }
                    if (this.m_population[n7].get(n)) {
                        gABitSetArray[n2].set(n);
                        continue;
                    }
                    gABitSetArray[n2].clear(n);
                }
            }
            for (n5 = 0; n5 < 2; ++n5) {
                for (n = 0; n < this.m_numAttribs; ++n) {
                    d2 = this.m_random.nextDouble();
                    if (!(d2 < this.m_pMutation) || this.m_hasClass && n == this.m_classIndex) continue;
                    if (gABitSetArray[n2 + n5].get(n)) {
                        gABitSetArray[n2 + n5].clear(n);
                        continue;
                    }
                    gABitSetArray[n2 + n5].set(n);
                }
            }
        }
        this.m_population = gABitSetArray;
    }

    private int select() {
        int n;
        double d = 0.0;
        double d2 = this.m_random.nextDouble() * this.m_sumFitness;
        for (n = 0; n < this.m_popSize && !((d += this.m_population[n].getFitness()) >= d2); ++n) {
        }
        return n;
    }

    private void evaluatePopulation(SubsetEvaluator subsetEvaluator) throws Exception {
        for (int i = 0; i < this.m_popSize; ++i) {
            if (!this.m_lookupTable.containsKey(this.m_population[i].getChromosome())) {
                double d = subsetEvaluator.evaluateSubset(this.m_population[i].getChromosome());
                this.m_population[i].setObjective(d);
                this.m_lookupTable.put(this.m_population[i].getChromosome(), this.m_population[i]);
                continue;
            }
            GABitSet gABitSet = (GABitSet)this.m_lookupTable.get(this.m_population[i].getChromosome());
            this.m_population[i].setObjective(gABitSet.getObjective());
        }
    }

    private void initPopulation() throws Exception {
        int n;
        int n2 = 0;
        if (this.m_starting != null) {
            this.m_population[0] = new GABitSet();
            for (n = 0; n < this.m_starting.length; ++n) {
                if (this.m_starting[n] == this.m_classIndex) continue;
                this.m_population[0].set(this.m_starting[n]);
            }
            n2 = 1;
        }
        for (n = n2; n < this.m_popSize; ++n) {
            this.m_population[n] = new GABitSet();
            int n3 = this.m_random.nextInt();
            if ((n3 = n3 % this.m_numAttribs - 1) < 0) {
                n3 *= -1;
            }
            if (n3 == 0) {
                n3 = 1;
            }
            for (int i = 0; i < n3; ++i) {
                int n4;
                boolean bl = false;
                do {
                    if ((n4 = this.m_random.nextInt()) < 0) {
                        n4 *= -1;
                    }
                    n4 %= this.m_numAttribs;
                    if (this.m_hasClass) {
                        if (n4 == this.m_classIndex) continue;
                        bl = true;
                        continue;
                    }
                    bl = true;
                } while (!bl);
                if (n4 > this.m_numAttribs) {
                    throw new Exception("Problem in population init");
                }
                this.m_population[n].set(n4);
            }
        }
    }

    private void populationStatistics() {
        this.m_minFitness = this.m_maxFitness = this.m_population[0].getObjective();
        this.m_sumFitness = this.m_maxFitness;
        for (int i = 1; i < this.m_popSize; ++i) {
            this.m_sumFitness += this.m_population[i].getObjective();
            if (this.m_population[i].getObjective() > this.m_maxFitness) {
                this.m_maxFitness = this.m_population[i].getObjective();
                continue;
            }
            if (!(this.m_population[i].getObjective() < this.m_minFitness)) continue;
            this.m_minFitness = this.m_population[i].getObjective();
        }
        this.m_avgFitness = this.m_sumFitness / (double)this.m_popSize;
    }

    private void scalePopulation() {
        double d;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 2.0;
        if (this.m_minFitness > (d4 * this.m_avgFitness - this.m_maxFitness) / (d4 - 1.0)) {
            d = this.m_maxFitness - this.m_avgFitness;
            d2 = (d4 - 1.0) * this.m_avgFitness / d;
            d3 = this.m_avgFitness * (this.m_maxFitness - d4 * this.m_avgFitness) / d;
        } else {
            d = this.m_avgFitness - this.m_minFitness;
            d2 = this.m_avgFitness / d;
            d3 = -this.m_minFitness * this.m_avgFitness / d;
        }
        this.m_sumFitness = 0.0;
        for (int i = 0; i < this.m_popSize; ++i) {
            if (d2 == Double.POSITIVE_INFINITY || d2 == Double.NEGATIVE_INFINITY || d3 == Double.POSITIVE_INFINITY || d3 == Double.NEGATIVE_INFINITY) {
                this.m_population[i].setFitness(this.m_population[i].getObjective());
            } else {
                this.m_population[i].setFitness(Math.abs(d2 * this.m_population[i].getObjective() + d3));
            }
            this.m_sumFitness += this.m_population[i].getFitness();
        }
    }

    private String populationReport(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n == 0) {
            stringBuffer.append("\nInitial population\n");
        } else {
            stringBuffer.append("\nGeneration: " + n + "\n");
        }
        stringBuffer.append("merit   \tscaled  \tsubset\n");
        for (int i = 0; i < this.m_popSize; ++i) {
            stringBuffer.append(Utils.doubleToString(Math.abs(this.m_population[i].getObjective()), 8, 5) + "\t" + Utils.doubleToString(this.m_population[i].getFitness(), 8, 5) + "\t");
            stringBuffer.append(this.printPopMember(this.m_population[i].getChromosome()) + "\n");
        }
        return stringBuffer.toString();
    }

    private String printPopMember(BitSet bitSet) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (!bitSet.get(i)) continue;
            stringBuffer.append(i + 1 + " ");
        }
        return stringBuffer.toString();
    }

    private String printPopChrom(BitSet bitSet) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_numAttribs; ++i) {
            if (bitSet.get(i)) {
                stringBuffer.append("1");
                continue;
            }
            stringBuffer.append("0");
        }
        return stringBuffer.toString();
    }

    private void resetOptions() {
        this.m_population = null;
        this.m_popSize = 20;
        this.m_lookupTableSize = 1001;
        this.m_pCrossover = 0.6;
        this.m_pMutation = 0.033;
        this.m_reportFrequency = this.m_maxGenerations = 20;
        this.m_starting = null;
        this.m_startRange = new Range();
        this.m_seed = 1;
    }

    protected class GABitSet
    implements Cloneable,
    Serializable {
        static final long serialVersionUID = -2930607837482622224L;
        private BitSet m_chromosome = new BitSet();
        private double m_objective = -1.7976931348623157E308;
        private double m_fitness;

        public Object clone() throws CloneNotSupportedException {
            GABitSet gABitSet = new GABitSet();
            gABitSet.setObjective(this.getObjective());
            gABitSet.setFitness(this.getFitness());
            gABitSet.setChromosome((BitSet)this.m_chromosome.clone());
            return gABitSet;
        }

        public void setObjective(double d) {
            this.m_objective = d;
        }

        public double getObjective() {
            return this.m_objective;
        }

        public void setFitness(double d) {
            this.m_fitness = d;
        }

        public double getFitness() {
            return this.m_fitness;
        }

        public BitSet getChromosome() {
            return this.m_chromosome;
        }

        public void setChromosome(BitSet bitSet) {
            this.m_chromosome = bitSet;
        }

        public void clear(int n) {
            this.m_chromosome.clear(n);
        }

        public void set(int n) {
            this.m_chromosome.set(n);
        }

        public boolean get(int n) {
            return this.m_chromosome.get(n);
        }
    }
}

