/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import weka.core.Option;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.BatchConverter;
import weka.core.converters.IncrementalConverter;

public class SerializedInstancesSaver
extends AbstractFileSaver
implements BatchConverter,
IncrementalConverter {
    public SerializedInstancesSaver() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "Serializes the instances to a file with extension bsi.";
    }

    public String getFileDescription() {
        return "Serializes the instaces to a file";
    }

    public void resetOptions() {
        super.resetOptions();
        this.setFileExtension(".bsi");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDestination(File file) throws IOException {
        boolean bl = false;
        String string = file.getAbsolutePath();
        if (this.retrieveFile() == null) return;
        try {
            block8: {
                try {
                    if (string.lastIndexOf(File.separatorChar) == -1) {
                        bl = file.createNewFile();
                    } else {
                        String string2 = string.substring(0, string.lastIndexOf(File.separatorChar));
                        File file2 = new File(string2);
                        if (file2.exists()) {
                            bl = file.createNewFile();
                        } else {
                            file2.mkdirs();
                            bl = file.createNewFile();
                        }
                    }
                    if (!bl) break block8;
                    this.setFile(file);
                }
                catch (Exception exception) {
                    throw new IOException("Cannot create a new output file. Standard out is used.");
                }
            }
            Object var7_7 = null;
            if (bl) return;
            System.err.println("Cannot create a new output file. Standard out is used.");
            this.setFile(null);
            return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (bl) throw throwable;
            System.err.println("Cannot create a new output file. Standard out is used.");
            this.setFile(null);
            throw throwable;
        }
    }

    public void writeBatch() throws IOException {
        this.resetWriter();
        if (this.getRetrieval() == 2) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        if (this.getInstances() == null) {
            throw new IOException("No instances to save");
        }
        this.setRetrieval(1);
        if (this.retrieveFile() == null) {
            throw new IOException("No output to standard out for serialization.");
        }
        this.setWriteMode(0);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.retrieveFile())));
        objectOutputStream.writeObject(this.getInstances());
        objectOutputStream.flush();
        objectOutputStream.close();
        this.setWriteMode(1);
    }

    public static void main(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            SerializedInstancesSaver serializedInstancesSaver = new SerializedInstancesSaver();
            stringBuffer.append("\n\nSerializedInstancesSaver options:\n\n");
            Enumeration enumeration = serializedInstancesSaver.listOptions();
            while (enumeration.hasMoreElements()) {
                Option option = (Option)enumeration.nextElement();
                stringBuffer.append(option.synopsis() + '\n');
                stringBuffer.append(option.description() + '\n');
            }
            try {
                serializedInstancesSaver.setOptions(stringArray);
            }
            catch (Exception exception) {
                System.out.println("\n" + stringBuffer);
                System.exit(1);
            }
            serializedInstancesSaver.writeBatch();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

