% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.haplo.shapeit-haps.R
\name{read.haplo.shapeit_haps}
\alias{read.haplo.shapeit_haps}
\title{Read haplotype data, selected by region of interest, from a .haps file
(regular ShapeIt output files)}
\usage{
read.haplo.shapeit_haps(filename, map, chr, startpos, endpos)
}
\arguments{
\item{filename}{character, path to a \code{.haps} file containing
haplotype data which is regular ShapeIt output. See
\url{https://mathgen.stats.ox.ac.uk/genetics_software/shapeit/shapeit.html#hapsample}}

\item{map}{object, data.frame contains 3 columns: rsID, chromosome,
position in bp as output by e.g. \code{\link{readMapFile}}.}

\item{chr}{character, chromosome number (basically from 1 to 22 as used by
\href{http://pngu.mgh.harvard.edu/~purcell/plink/data.shtml#ped}{Plink}),
on which the region of interest is located}

\item{startpos}{numeric, start position (in bp, base pairs) of the
region of interest (default: 0)}

\item{endpos}{numeric, end position (in bp, base pairs) of the
region of interest (default: 0)}
}
\value{
matrix object containing the haplotypes selected by the
region of interest
}
\description{
Read haplotype data, selected by region of interest, from a .haps file
(regular ShapeIt output files)
}
\seealso{
\code{\link{read.haplo}},
\code{\link{read.haplo.pedfile}},
\code{\link{read.haplo.bedfile}},
\code{\link{readMapFile}}
}
\keyword{internal}

