% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estim.H0.ASKAT.R
\name{Estim.H0.ASKAT}
\alias{Estim.H0.ASKAT}
\title{Estimation of the variance components under the null model using the ASKAT method}
\usage{
Estim.H0.ASKAT(y, X, S, U)
}
\arguments{
\item{y}{Vector of phenotype values}

\item{X}{A matrix of covariates, including intercept.}

\item{S}{Matrix obtained from spectral decomposition of the
relationship matrix: \eqn{\Phi = U S U^T}.}

\item{U}{Matrix obtained from spectral decomposition of the
relationship matrix: \eqn{\Phi = U S U^T}.}
}
\value{
A vector with the following values:
\itemize{
\item \code{s.e}: variance component due to the error term (residuals)
\item \code{s.g}: variance component due to the polygenic residual
(polygenic background)
\item \code{beta}: the estimate of the effects of the covariate (if
there are some in the data)
}
}
\description{
Estimation of the variance components under the null model using the ASKAT method
}
\author{
Karim Oualkacha

M'Hamed Lajmi Lakhal-Chaieb
}

