% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_volcano.R
\name{plot_volcano}
\alias{plot_volcano}
\title{Plot volcanoplot}
\usage{
plot_volcano(
  data = data,
  comp.names = NULL,
  geneset = NULL,
  geneset.FCflag = "logFC",
  highlight.1 = NULL,
  highlight.2 = NULL,
  upcolor = "#FF0000",
  downcolor = "#0000FF",
  plot.save.to = NULL,
  xlim = c(-4, 4),
  ylim = c(0, 12),
  FCflag = "logFC",
  FDRflag = "adj.P.Val",
  highlight.FC.cutoff = 1.5,
  highlight.FDR.cutoff = 0.05,
  title = "Volcano plot",
  xlab = "log2 Fold Change",
  ylab = "log10(FDR)"
)
}
\arguments{
\item{data}{Summary statistics table or a list contain multiple summary statistics tables from limma or DEseq2, where each row is a gene.}

\item{comp.names}{A character vector that contains the comparison names which correspond to the same order as \code{data}. Required if \code{data} is list. No default.}

\item{geneset}{Summary statistic table that contains the genes which needed to be highlighted, the gene name format (in row names)
needs to be consistent with the main summary statistics table). For example, this summary statistics
table could be the output summary statistics table from the Disease vs Healthy comparison (Only contains
the subsetted significant genes to be highlighted).}

\item{geneset.FCflag}{The column name of fold change in \code{geneset}, Default = "logFC".}

\item{highlight.1}{Genes to be highlighted, in the format of a vector consists of gene names. The gene name format
needs to be consistent to the main summary statistics table.}

\item{highlight.2}{Genes to be highlighted, in the format of a vector consists of gene names. The gene name format
needs to be consistent to the main summary statistics table.}

\item{upcolor}{The color of the gene names in \code{highlight.1} or the positive fold change gene
in \code{geneset}, default = "#FDE725FF" (viridis color palette).}

\item{downcolor}{The color of the gene names in \code{highlight.2} or the negative fold change gene
in \code{geneset}, default = "#440154FF" (viridis color palette).}

\item{plot.save.to}{The file name and address where to save the volcano plot, e.g. "~/address_to_folder/volcano_plot.png".}

\item{xlim}{Range of x axis. Default = \code{c(-3,3)}.}

\item{ylim}{Range of x axis. Default = \code{c(0,6)}.}

\item{FCflag}{Column name of log2FC in the summary statistics table. Default = "logFC".}

\item{FDRflag}{Column name of FDR in the summary statistics table. Default = "adj.P.Val".}

\item{highlight.FC.cutoff}{Fold change cutoff line want to be shown on the plot. Default = 1.5.}

\item{highlight.FDR.cutoff}{FDR cutoff shades want to be shown on the plot. Default = 0.05.}

\item{title}{The plot title. Default "Volcano plot".}

\item{xlab}{The label for x-axis. Default "log2 Fold Change".}

\item{ylab}{The label for y-axis. Default "log10(FDR)".}
}
\value{
The function return a volcano plot as a ggplot object.
}
\description{
This function processes the summary statistics table generated by differential expression analysis
like \code{limma} or \code{DESeq2} to show on the volcano plot with the highlight gene set option (like disease
related genes from Disease vs Healthy comparison).
}
\details{
The function takes the summary statistics table and returns a ggplot, with the option to highlight
genes, e.g. disease signature genes, the genes which are up-regulated and down-regulated in diseased subjects.
}
\examples{
plot_volcano(data = Sample_summary_statistics_table,
             geneset = Sample_disease_gene_set)

plot_volcano(data = list(Sample_summary_statistics_table, Sample_summary_statistics_table1),
            comp.names = c("A", "B"),
            geneset = Sample_disease_gene_set)
}
\references{
Xingpeng Li & Tatiana Gelaf Romer & Olya Besedina, RVA - RNAseq Visualization Automation tool.
}
