% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_pairs.R
\name{chart_pairs}
\alias{chart_pairs}
\title{Pairwise scatter plots for timeseries}
\usage{
chart_pairs(df = df, title = "Time Series Pairs Plot")
}
\arguments{
\item{df}{Wide data frame. \code{tibble}}

\item{title}{Chart title. \code{character}}
}
\value{
A plotly object. \code{htmlwidget}
}
\description{
Plots pairwise scatter plots with the time dimension.
Useful when exploring structural changes in timeseries properties for modeling.
}
\examples{
df <- dfwide \%>\%
  dplyr::select(date, CL01, NG01, HO01, RB01) \%>\%
  tidyr::drop_na()
chart_pairs(df = df, title = "example")
}
\author{
Philippe Cote
}
