% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tradeStats.R
\name{tradeStats}
\alias{tradeStats}
\title{\code{tradeStats}}
\usage{
tradeStats(x, Rf = 0)
}
\arguments{
\item{x}{Univariate xts object of returns or dataframe with date and return variable.}

\item{Rf}{Risk-free rate}
}
\value{
List of risk/reward metrics.
}
\description{
Compute list of risk reward metrics
}
\examples{
library(tidyverse)
library(tidyquant)
x <- tidyquant::tq_get("SPY") \%>\% dplyr::mutate(ret = log(adjusted / dplyr::lag(adjusted)))
x <- x \%>\% stats::na.omit()\%>\% dplyr::select(date,ret)
tradeStats(x = x,Rf=0)
}
\author{
Philippe Cote
}
