% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tradeStats.R
\name{tradeStats}
\alias{tradeStats}
\title{\code{tradeStats}}
\usage{
tradeStats(x, Rf = 0)
}
\arguments{
\item{x}{xts object of returns}

\item{Rf}{Risk-free rate}
}
\value{
List of risk/reward metrics.
}
\description{
Compute list of risk reward metrics
}
\examples{
library(quantmod)
getSymbols("SPY", return.class = "zoo")
SPY$retClCl <- na.omit(quantmod::Delt(Cl(SPY),k=1,type='arithmetic'))
tradeStats(x=SPY$retClCl,Rf=0)
}
\author{
Philippe Cote
}
