% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{fit}
\alias{fit}
\title{Call Julia code to fit the values}
\usage{
fit(rtigerobj, max.iter , eps,
trace, all = TRUE, random = FALSE,
specific = FALSE, nsamples = 20,
post.processing = TRUE)
}
\arguments{
\item{rtigerobj}{an RTIGER object.}

\item{max.iter}{maximum number of iterations to acomplish by the EM.}

\item{eps}{differnece threshold to halt the EM.}

\item{trace}{logical value whether to trace the changes in the parameters along the iterations.}

\item{all}{logical value whether to use all data to fit the model.}

\item{random}{if all FALSE use random samples.}

\item{specific}{if all FALSE use specific samples.}

\item{nsamples}{if random TRUE, how many samples to use.}

\item{post.processing}{logical value, whether to run post.processing process.}
}
\value{
RTIGER object
}
\description{
Call Julia code to fit the values
}
\examples{
\dontrun{
data("fittedExample")
sourceJulia()
myfit = fit(myDat, max.iter = 2, eps=0.01,
            trace = TRUE, all = TRUE,
            random = FALSE, specific = FALSE,
            nsamples = 20, post.processing = TRUE)

}
}
