% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_api_repo.R
\name{repo_mng_init}
\alias{repo_mng_init}
\title{Initializes repository (creates its structure).}
\usage{
repo_mng_init(repo_manager)
}
\arguments{
\item{repo_manager}{repo manager object retrieved with repo_mgr_start.
(type: rsuite_repo_manager)}
}
\description{
Initializes repository (creates its structure).
}
\examples{
# create exemplary project base folder
prj_base <- tempfile("example_")
dir.create(prj_base, recursive = TRUE, showWarnings = FALSE)

# start project
prj <- prj_start("my_project", skip_rc = TRUE, path = prj_base)

# set it to use in project repository and CRAN
prj_config_set_repo_adapters(c("Dir", "CRAN"), prj = prj)

# start managing in project repository
rmgr <- repo_mng_start("Dir", prj = prj, ix = 1)

# initialize its structure
repo_mng_init(rmgr)

# stop repository management
repo_mng_stop(rmgr)

}
\seealso{
Other in repository management: \code{\link{repo_mng_list}},
  \code{\link{repo_mng_remove}},
  \code{\link{repo_mng_start}},
  \code{\link{repo_mng_stop}},
  \code{\link{repo_upload_bioc_package}},
  \code{\link{repo_upload_ext_packages}},
  \code{\link{repo_upload_github_package}},
  \code{\link{repo_upload_package_files}},
  \code{\link{repo_upload_pkgzip}},
  \code{\link{repo_upload_prj_packages}}
}
