% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_api_prj.R
\name{prj_pack}
\alias{prj_pack}
\title{Prepares project source pack tagged with version.}
\usage{
prj_pack(prj = NULL, path = getwd(), pkgs = NULL, inc_master = TRUE,
  pack_ver = NULL, rver = NULL)
}
\arguments{
\item{prj}{project object to pack. if not passed will pack loaded project or
default whichever exists. Will init default project from working
directory if no default project exists. (type: rsuite_project, default: NULL)}

\item{path}{folder path to put output pack into. The folder must exist.
(type: character, default: \code{getwd()})}

\item{pkgs}{names of packages to include into pack. If NULL will include all
project packages (type: character, default: NULL)}

\item{inc_master}{if TRUE will include master scripts into pack.
(type: logical, default: TRUE)}

\item{pack_ver}{if passed enforce version of pack to passed value.
Expected form of version is DD.DD. (type: character, default: NULL)}

\item{rver}{if passed enforce destination R version of pack.
(type: character(1), default: NULL)}
}
\value{
invisible file path to pack file created. The file name will be
   in form prjpack_<ProjectName>_<version>.zip
}
\description{
It collects all sources and assemblies found in project folder and packs them
into single zip file.
}
\details{
The function is heavily used for building project for alternative environments
(like in docker).

Pack generated is stamped with version. It can be enforced with pack_ver
parameter (zip will have suffix <pack_ver>x in the case). If version is not
enforced it is detected out of ZipVersion setting in project PARAMETERS file or
from maximal project packages version number. In that case revision number is
appended to version: version number will be <ZipVersion>_<rc_ver>. Check for
changes in project sources is performed for pack consistency. Resulted pack
is marked with the version detected so while building zip after unpacking will
have the same version as original project.

Before building pack project packages will have version altered: revision will
be added as least number to package version.

Logs all messages onto rsuite logger. Use \code{logging::setLevel} to control
logs verbosity.
}
\examples{
# create exemplary project base folder
prj_base <- tempfile("example_")
dir.create(prj_base, recursive = TRUE, showWarnings = FALSE)

# start project
prj <- prj_start("my_project", skip_rc = TRUE, path = prj_base)

# create package in the project
prj_start_package("mypackage", prj = prj, skip_rc = TRUE)

# build project source pack
pack_fpath <- prj_pack(prj = prj, path = tempdir(), pack_ver = "1.0")

}
\seealso{
Other in project management: \code{\link{prj_build}},
  \code{\link{prj_clean_deps}}, \code{\link{prj_init}},
  \code{\link{prj_install_deps}}, \code{\link{prj_load}},
  \code{\link{prj_lock_env}},
  \code{\link{prj_start_package}}, \code{\link{prj_start}},
  \code{\link{prj_unload}}, \code{\link{prj_zip}}
}
