% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validateMap.R
\name{validateMap}
\alias{validateMap}
\title{Map accuracy assessment}
\usage{
validateMap(map, valData, responseCol, nSamples = 500,
  mode = "classification", classMapping = NULL)
}
\arguments{
\item{map}{RasterLayer. The classified map.}

\item{valData}{SpatialPolygonsDataFrame or SpatialPointsDataFrame with validation data.}

\item{responseCol}{Character. Column containing the validation data in attribute table of \code{valData}.}

\item{nSamples}{Integer. Number of pixels to sample for validation (only applies to polygons).}

\item{mode}{Character. Either 'classification' or 'regression'.}

\item{classMapping}{optional data.frame with columns \code{'class'} and \code{'classID'} defining the mapping from raster integers to class names.}
}
\description{
validate a map from a classification or regression model. This can be useful to update the accuracy assessment after filtering, e.g. for a minimum mapping unit.
}
\note{
Polygons, which are smaller than the map resolution will only be considered if they overlap with a pixel center coordinate, otherwise they will be ignored.
}
\examples{
\dontrun{
library(caret)
library(raster)

## Training data
data(lsat)
poly     <- readRDS(system.file("external/trainingPolygons.rds", package="RStoolbox"))

## Split training data in training and validation set (50\%-50\%)
splitIn   <- createDataPartition(poly$class, p = .5)[[1]]
train <- poly[splitIn,]
val   <- poly[-splitIn,]

## Classify (deliberately poorly)
sc <- superClass(lsat, trainData = train, responseCol = "class", nSamples = 50, model = "mlc")

## Polish map with majority filter

polishedMap <- focal(sc$map, matrix(1,3,3), fun = modal) 

## Validation
## Before filtering
val0 <- validateMap(sc$map, valData = val, responseCol = "class", 
                            classMapping = sc$classMapping)
## After filtering
val1 <- validateMap(polishedMap, valData = val, responseCol = "class",
                             classMapping = sc$classMapping)
}
}
