\name{RSVGTipsDevice}
\alias{RSVGTipsDevice}
\docType{package}
\title{A SVG Graphics Driver with dynamic tips}
\description{
  This package contains a SVG (Scalable Vector Graphics) device that will write to
  a file.  The SVG shapes have optional tooltips and/or
  hyperlinks.  The resulting SVG files should conform the W3C Scalable
  Vector Graphics (SVG) standard (with the possible exception of
  \code{toolTipMode=2}) and do display correctly in
  the SVG viewer in Mozilla Firefox under Windows (XP) and Linux (Ubuntu).
}
\details{
  This graphics device supplies the underlying functions that are called
  by \code{\link{plot}}, \code{\link{lines}}, etc, and the following
  functions that are called by the user to access the special
  capabilities of the SVG device:
  \itemize{
    \item{\code{\link{devSVGTips}}}{Open an SVG device}
    \item{\code{\link{setSVGShapeToolTip}}}{Set a tool tip to be used
      for the next graphics shape drawn}
    \item{\code{\link{setSVGShapeURL}}}{Set a URL to be used
      in the hyperlink for the next graphics shape drawn}
    \item{\code{\link{getSVGToolTipMode}}}{Get the tool tip mode used by
      the current graphics device}
    }
}
\author{
  This driver is a modification by Tony Plate \email{tplate@acm.org} of the RSvgDevice driver written by T Jake Luciani
  \email{jakeluciani@yahoo.com}
}
\seealso{
  \link[=RSVGTipsDevice.future]{Design and future possible features} of the RSVGTips device.

  \code{\link{pictex}}, \code{\link{postscript}}, \code{\link{Devices}}.
  
}
\examples{
library("RSVGTipsDevice")
devSVGTips("svgplot1.svg", toolTipMode=1,
    title="SVG example plot 1: shapes and points, tooltips are title + 1 line")
plot(c(0,10),c(0,10), type="n", xlab="x", ylab="y",
    main="Example SVG plot with title + 1 line tips (mode=1)")
setSVGShapeToolTip(title="A rectangle", desc="that is yellow")
rect(1,1,4,6, col='yellow')
setSVGShapeToolTip(title="1st circle with title only")
points(5.5,7.5,cex=20,pch=19,col='red')
setSVGShapeToolTip(title="A triangle", desc="big and green")
polygon(c(3,6,8), c(3,6,3), col='green')
# no tooltips on these points
points(2:8, 8:2, cex=3, pch=19, col='black')
# tooltips on each these points
invisible(sapply(1:7, function(x)
{setSVGShapeToolTip(title=paste("point", x))
 points(x+1, 8-x, cex=3, pch=1, col='black')}))
dev.off()

devSVGTips("svgplot2.svg", toolTipMode=2,
    title="SVG example plot 2: shapes and points, tooltips are title + 2 lines")
getSVGToolTipMode()
setSVGShapeToolTip(title="First circle title only")
plot(1:3, cex=10, main="Example SVG plot with title + 2 line tips (mode=2)")
setSVGShapeToolTip(title="A rectangle", desc="with a 1 line tip")
rect(1,1,2,2)
setSVGShapeToolTip(title="second circle", desc1="first line of description", desc2="second line of description")
points(1.5,2.5,cex=20,pch=19,col='red')
dev.off()

devSVGTips("svgplot3.svg", toolTipMode=2,
    title="SVG example plot 3: shapes, tooltips are title + 2 lines")
plot(c(0,10),c(0,10), type="n", xlab="x", ylab="y",
    main="Example SVG plot, tooltips are title + 2 lines (mode=2)")
setSVGShapeToolTip(title="A rectangle", desc="that is yellow")
rect(1,1,4,6, col='yellow')
setSVGShapeToolTip(title="1st circle", desc1="1st line of description",
    desc2="2nd line of description")
points(5.5,7.5,cex=20,pch=19,col='red')
setSVGShapeToolTip(title="A triangle", desc1="green", desc2="big")
polygon(c(3,6,8), c(3,6,3), col='green')
# no tooltips on these points
points(2:8, 8:2, cex=3, pch=19, col='black')
# tooltips on each of these points
invisible(sapply(1:7, function(x)
{setSVGShapeToolTip(title=paste("point", x))
 points(x+1, 8-x, cex=3, pch=1, col='black')}))
dev.off()

devSVGTips("svgplot4.svg", title="SVG example plot 4: points and no tooltips")
plot(1:11,(-5:5)^2, type='b', main="Simple Example Plot with no tooltips")
dev.off()

devSVGTips("svgplot5.svg",
    title="SVG example plot 5: points and a rectangle, no tooltips")
plot(1:3)
rect(1,1,2,2)
dev.off()

devSVGTips("svgplot6.svg",
    title="SVG example plot 6: supply XML code for tips (title + 1 line)")
setSVGShapeContents("<title>first circle</title>")
plot(1:3, cex=10)
setSVGShapeContents("<title>hah!</title>")
rect(1,1,2,2)
setSVGShapeContents("<title>second circle</title><desc>description</desc>")
points(1.5,2.5,cex=20,pch=19,col='red')
dev.off()

devSVGTips("svgplot7.svg", toolTipMode=2,
    title="SVG example plot 7: supply XML code for tips (title + 2 lines)")
setSVGShapeContents("<title>first circle</title>")
plot(1:3, cex=10)
setSVGShapeContents("<title>hah!</title>")
rect(1,1,2,2)
setSVGShapeContents("<title>second circle</title><desc1>first line of description</desc1><desc2>second line of description</desc2>")
points(1.5,2.5,cex=20,pch=19,col='red')
dev.off()

devSVGTips("svgplot8.svg", toolTipMode=1,
    title="SVG example plot 8: tooltips + hyperlink")
plot(c(0,10),c(0,10), type="n", xlab="x", ylab="y",
    main="Example SVG plot with title + 1 line tips (mode=1) + hyperlink")
setSVGShapeToolTip(title="A rectangle", desc="that is yellow")
rect(1,1,4,6, col='yellow')
setSVGShapeToolTip(title="1st circle with title only")
points(5.5,7.5,cex=20,pch=19,col='red')
setSVGShapeToolTip(title="A triangle", desc="big and green")
polygon(c(3,6,8), c(3,6,3), col='green')
# no tooltips on these points
points(2:8, 8:2, cex=3, pch=19, col='black')
# tooltips on each these points
invisible(sapply(1:7, function(x)
{setSVGShapeToolTip(title=paste("point", x))
 points(x+1, 8-x, cex=3, pch=1, col='black')}))
# Hyperlink to www.r-project.org
setSVGShapeToolTip(title="www.r-project.org", desc="click to visit!")
setSVGShapeURL("http://www.r-project.org")
rect(8,6,10,7, col='blue')
dev.off()

devSVGTips("svgplot9.svg", toolTipMode=1,
    title="SVG example plot 9: line and point types")
plot(c(0,20),c(0,5), type="n", xlab="x", ylab="y",
    main="Example SVG plot with different line and point types")
for (i in 0:16) {
    lines(i+(0:4), (1:5), col=max(i,1), pch=i, lty=i, type="b")
    text(i, 0.5, lab=as.character(i), cex=2^(abs((i-8)/4)-1))
}
dev.off()

}
\keyword{device}
\keyword{package}
