% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sym.row.plot.R
\name{sym.row.plot}
\alias{sym.row.plot}
\title{Function for plotting one row or one column from the symbolic data table}
\usage{
sym.row.plot(data, col = NA, matrix.form = NA, border = FALSE, size = 1,
  title = TRUE, show.type = FALSE, reduce = FALSE)
}
\arguments{
\item{data}{The row of the symbolic data table.}

\item{col}{A specification for the default plotting color.}

\item{matrix.form}{A vector of the form c(num.rows,num.columns)}

\item{border}{A logical value indicating whether border should be plotted.}

\item{size}{The magnification to be used for each graphic.}

\item{title}{A logical value indicating whether title should be plotted.}

\item{show.type}{A logical value indicating whether type should be plotted.}

\item{reduce}{A logical value indicating whether values different from zero should be plotted in modal and set graphics.}
}
\value{
A plot of one row from symbolic data table.
}
\description{
Function for plotting one row or one column from the symbolic data table
}
\examples{
\dontrun{
data(oils)
sym.row.plot(oils[3,])
sym.row.plot(oils[3,],matrix.form = c(2,2),border=TRUE)
}
}
\author{
Andres Navarro
}
