% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply.mod.seasonal.R
\name{apply.mod.seasonal}
\alias{apply.mod.seasonal}
\title{apply.mod.seasonal}
\usage{
apply.mod.seasonal(df, datecol, model, season, threshold)
}
\arguments{
\item{df}{dataframe with reflectance values}

\item{datecol}{string, name of column with imagery dates}

\item{model}{calibrated GLM}

\item{season}{vector of months to include in the season}

\item{threshold}{numeric value above which is considered unreasonable/noise}
}
\value{
dataframe of predicted values and confidence intervals
}
\description{
Apply GLM to remotely sensed record
}
\examples{
data(srdataforapplication)
data(utahsummermod)
estdata <- apply.mod.seasonal(df=srdataforapplication,
datecol="ImageDate",model=utahsummermod,season=c("July","August","September"),threshold=500)
}
