\name{rsaga.target}
\alias{rsaga.target}
\title{Define target grid for interpolation}
\usage{
  rsaga.target(target = c("user.defined", "target.grid", "header"),
    user.cellsize = 100, user.x.extent, user.y.extent,
    target.grid, header, env = rsaga.env())
}
\arguments{
  \item{target}{character: method used for defining the
  target grid; note: \code{"target.grid"} currently doesn't
  seem to work in SAGA GIS 2.1.0}

  \item{user.cellsize}{Only for
  \code{target="user.defined"}: raster resolution (in the
  grid's map units)}

  \item{user.x.extent}{See \code{user.y.extent}}

  \item{user.y.extent}{Only for
  \code{target="user.defined"}: numeric vectors of length
  2: minimum and maximum coordinates of grid cell center
  points}

  \item{target.grid}{Only for \code{target="target.grid"}:
  character string giving the name of a SAGA grid file that
  specifies the extent and resolution of the target grid;
  this target grid file may be overwritten, depending on
  the specifics of the SAGA GIS module used.}

  \item{header}{Only for \code{target="header"}: list:
  ASCII grid header (as returned e.g. by
  \code{\link{read.ascii.grid.header}}) or defined
  manually; must at least have components \code{ncols},
  \code{nrows}, \code{cellsize}, and either
  \code{x/yllcorner} or \code{x/yllcenter}.}

  \item{env}{A SAGA geoprocessing environment, see
  \code{\link{rsaga.env}}.)}
}
\description{
  Define the resolution and extent of a target grid for
  interpolation by SAGA modules based on (1) user-provided
  x/y coordinates, (2) an existing SAGA grid file, or (3)
  the header data of an ASCII grid. Intended to be used
  with RSAGA's interpolation functions. Currently works
  with SAGA GIS 2.0.5 - 2.0.8 and partially with SAGA GIS
  2.1.0 (not with \code{target="target.grid"}).
}
\note{
  This function is to be used with RSAGA functions
  \code{\link{rsaga.inverse.distance}},
  \code{\link{rsaga.nearest.neighbour}} and
  \code{\link{rsaga.modified.quadratic.shephard}}. Note
  that these are currently only compatible with SAGA GIS
  2.0.5 and higher, and that SAGA GIS 2.1.0 has some yet
  unresolved issues with the target grid parameterization
  (\code{target="target.grid"}).
}
\examples{
\dontrun{
# IDW interpolation of attribute "z" from the point shapefile
# 'points.shp' to a grid with the same extent and resolution
# as the (pre-existing) geology grid:
rsaga.inverse.distance("points", "dem", field = "z", maxdist = 1000,
    target = rsaga.target(target="target.grid",
    target.grid = "geology"))
}
}
\seealso{
  \code{\link{read.ascii.grid.header}}
}
\keyword{interface}
\keyword{spatial}

