% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RBC.R
\name{RBC}
\alias{RBC}
\title{Rate By Clade}
\usage{
RBC(RR,y,n.shift=c("clust","fix"),NS=3,clus=.5,f=NULL,foldername)
}
\arguments{
\item{RR}{an object fitted by the function \code{\link{RRphylo}}.}

\item{y}{either a single vector variable or a multivariate dataset of class \sQuote{matrix}.}

\item{n.shift}{it specifies whether the function automatically searches for shifts (\code{"clust"}) or the number of shifts to search for has to be set by the user (\code{"fix"}).}

\item{NS}{the number of shifts to be specified for \code{n.shift = "fix"}. It is set at 3 by default.}

\item{clus}{the proportion of clusters to be used in parallel computing.}

\item{f}{the size of the smallest clade to be tested in \code{'RBC'}. By default, nodes subtending to at least one tenth of the tree tips are tested.}

\item{foldername}{the path of the folder where plots are to be found.}
}
\value{
\strong{rbc} brownian rate values for all possible clades identified (i.e. subtrees having number of tips > \code{f}).

\strong{best.model} best Brownian rate variation ("non-censored") model selected by means of likelihood ratio test.

\strong{alternative.models} alternative Brownian rate variation ("non-censored") model selected by means of LRT.

\strong{n.shifts} the number of shifts for the \code{RBC} analysis.
}
\description{
The \code{'RBC'} function (\cite{Piras et al. 2018}) provides a test for Brownian rate variation via the non-censored approach (\cite{O'Meara et al. 2006}).
}
\details{
The user indicates the minimum size of the clades to be tested for rate variation must be (by setting the argument \code{'f'}, which is by default set at one-tenth of the tree size). Individual nodes are arranged according to their rates (i.e. in descending Brownian rate value). Then, the user is left with two different options to locate the number of potential shifts. First (\code{n.shift = "fix"}), it is possible to specify the number \emph{n} (=\code{'NS'}) of shifts to be searched for all combinations of the \emph{n} nodes with the \emph{n} largest sigma2 (Brownian rate) value, with size 1 to \emph{n}. For instance, with \code{'NS'} = 3 \code{RRphylo} will search through all the eight possible combinations of the 3 nodes with the largest sigma2 values (three combinations with one shift only, one for each node; three combinations of two shifts at two different nodes; and a single combination including all the three shifts for all \code{'NS'}=3 nodes, plus Brownian motion, which means no shift applied). Alternatively (\code{n.shift = "clust"}), all nodes subtending a number of tips as large as \code{f} are partitioned in groups according to their patristic distance, and the number of distinct groups with potential shifts is established via bootstrapped cluster analysis of the internodes distances, by using \pkg{pvclust} package in R (\cite{Suzuki and Shimodaira 2015}).  This way the number of potential shifts are located in topologically distinct parts of the tree. The resulting number of groups \emph{k} is thus taken to be equivalent to the number of shifts to be searched, by examining all possible combinations of the \emph{k} nodes with the largest simga2 values. Of course, it is still possible (and in fact tested) that more than one shift falls in the same region of the tree. Once potential shifts are located, their combinations represent different rate variation models, which are compared to each other (and to a single rate, Brownian motion model) by means of restricted maximum likelihood fitted with the function \code{brownieREML} in \pkg{phytools} (\cite{Revell 2012}), or \code{mvBM} in \pkg{mvMORPH} (\cite{Clavel et al. 2015}) in the multivariate case. The likelihoods of individual models are contrasted to each other to find the best model by means of likelihood ratio test.
}
\examples{
data("DataOrnithodirans")
DataOrnithodirans$treedino->treedino
DataOrnithodirans$massdino->massdino

 \donttest{

    RRphylo(tree=treedino,y=massdino)->RR

# Case 1. RBC fixing the number of shifts at 2
    RBC(RR=RR,y=massdino,n.shift="fix",NS=2,foldername=tempdir())

# Case 2. RBC automatically searching for shifts
    RBC(RR=RR,y=massdino,n.shift="clust",foldername=tempdir())

    }
}
\references{
Piras, P., Silvestro, D., Carotenuto, F., Castiglione, S., Kotsakis, A., Maiorino, L., Melchionna, M., Mondanaro, A., Sansalone, G., Serio, C., Vero, V.A., & Raia, P. (2018). Evolution of the sabertooth mandible: A deadly ecomorphological specialization. \emph{Palaeogeography, Palaeoclimatology, Palaeoecology}, in press

O'Meara, B. C., Ané, C., Sanderson, M. J., & Wainwright, P. C. (2006). Testing for different rates of continuous trait evolution using likelihood. \emph{Evolution}, \strong{60}, 922--933.

Suzuki, R., & Shimodaira, H. (2015). pvclust: Hierarchical Clustering with P-Values via Multiscale Bootstrap Resampling. R package version 2.0-0. https://CRAN.R-project.org/package=pvclust

Revell, L. J. (2012). phytools: An R package for phylogenetic comparative biology (and other things). \emph{Methods in Ecology and Evolution}, \strong{3}, 217--223.doi:10.1111/j.2041-210X.2011.00169.x

Clavel, J., Escarguel, G., & Merceron, G.(2015). mvMORPH: an R package for fitting multivariate evolutionary models to morphometric data. \emph{Methods in Ecology and Evolution}, \strong{6}:1311--1319. doi: 10.1111/2041-210X.12420
}
\author{
Pasquale Raia, Silvia Castiglione, Carmela Serio, Alessandro Mondanaro, Marina Melchionna, Mirko Di Febbraro, Antonio Profico, Francesco Carotenuto
}
