% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RRPP.utils.r
\name{summary.trajectory.analysis}
\alias{summary.trajectory.analysis}
\title{Print/Summary Function for RRPP}
\usage{
\method{summary}{trajectory.analysis}(object, stat.table = TRUE,
  attribute = c("MD", "TC", "SD"), angle.type = c("rad", "deg"),
  confidence = 0.95, show.trajectories = FALSE, ...)
}
\arguments{
\item{object}{Object from \code{\link{trajectory.analysis}}}

\item{stat.table}{Logical argument for whether results should be returned in one table 
(if TRUE) or separate pairwise tables (if FALSE)}

\item{attribute}{Whether magnitude differences (MD, absolute difference in trajectory path lengths), 
trajectory correlations (TC), or trajectory shape differences (SD) are summarized.}

\item{angle.type}{If attribute = "TC", whether angle results are expressed in radians or degrees.}

\item{confidence}{Confidence level to use for upper confidence limit; default = 0.95 (alpha = 0.05)}

\item{show.trajectories}{Logical value to indicate whether trajectories should be printed.}

\item{...}{Other arguments passed onto trajectory.analysis}
}
\description{
Print/Summary Function for RRPP
}
\author{
Michael Collyer
}
\keyword{utilities}
